/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.services.ClassSummaryDetailBase;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public abstract class RuntimeServices {
    protected Session session;
    private int deployedSessionProfileWeight;
    private SessionLog deployedSessionLog;
    public String objectName;
    protected static final String EclipseLink_Product_Name = "EclipseLink";
    protected static String PLATFORM_NAME = "Server";

    public RuntimeServices() {
    }

    public RuntimeServices(Session session) {
        this.session = session;
    }

    protected AbstractSession getSession() {
        return (AbstractSession)this.session;
    }

    public String getSessionName() {
        return this.getSession().getName();
    }

    public boolean getShouldLogMessages() {
        return this.getSession().shouldLogMessages();
    }

    public void setShouldProfilePerformance(boolean shouldProfile) {
        if (shouldProfile && this.getSession().getProfiler() == null) {
            this.getSession().setProfiler(new PerformanceProfiler());
        } else if (!shouldProfile) {
            this.getSession().setProfiler(null);
        }
    }

    public boolean getShouldProfilePerformance() {
        return this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass());
    }

    public void setShouldLogPerformanceProfiler(boolean shouldLogPerformanceProfiler) {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            ((PerformanceProfiler)this.getSession().getProfiler()).setShouldLogProfile(shouldLogPerformanceProfiler);
        }
    }

    public boolean getShouldLogPerformanceProfiler() {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            return ((PerformanceProfiler)this.getSession().getProfiler()).shouldLogProfile();
        }
        return false;
    }

    public void setShouldCacheAllStatements(boolean shouldCacheAllStatements) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldCacheAllStatements(shouldCacheAllStatements);
    }

    public void setStatementCacheSize(int size2) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStatementCacheSize(size2);
    }

    public int getStatementCacheSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStatementCacheSize();
    }

    public void setSequencePreallocationSize(int size2) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).setSequencePreallocationSize(size2);
    }

    public int getSequencePreallocationSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).getSequencePreallocationSize();
    }

    public void updatePoolSize(String poolName, int maxSize, int minSize) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            connectionPool.setMaxNumberOfConnections(maxSize);
            connectionPool.setMinNumberOfConnections(minSize);
        }
    }

    public List getAvailableConnectionPools() {
        Vector<String> list = null;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map<String, ConnectionPool> pools = ((ServerSession)this.getSession()).getConnectionPools();
            list = new Vector(pools.size());
            Iterator<String> poolNames = pools.keySet().iterator();
            while (poolNames.hasNext()) {
                list.add(poolNames.next());
            }
        } else {
            list = new Vector<String>();
        }
        return list;
    }

    public List getSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        Vector<Integer> results = new Vector<Integer>(2);
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            results.add(connectionPool.getMaxNumberOfConnections());
            results.add(connectionPool.getMinNumberOfConnections());
        }
        return results;
    }

    public void addNewConnectionPool(String poolName, int maxSize, int minSize, String platform, String driverClassName, String url, String userName, String password) throws ClassNotFoundException {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            DatabaseLogin login = new DatabaseLogin();
            login.setPlatformClassName(platform);
            login.setDriverClassName(driverClassName);
            login.setConnectionString(url);
            login.setUserName(userName);
            login.setEncryptedPassword(password);
            ((ServerSession)this.getSession()).addConnectionPool(poolName, login, minSize, maxSize);
        }
    }

    public void resetAllConnections() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            for (ConnectionPool pool : ((ServerSession)this.getSession()).getConnectionPools().values()) {
                pool.shutDown();
                pool.startUp();
            }
        } else if (ClassConstants.PublicInterfaceDatabaseSession_Class.isAssignableFrom(this.getSession().getClass())) {
            this.getSession().getAccessor().reestablishConnection(this.getSession());
        }
    }

    public List getClassesInSession() {
        return this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
    }

    public List getObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map2 = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        Vector<Object> results = new Vector<Object>(map2.getSize());
        Enumeration objects = map2.keys();
        while (objects.hasMoreElements()) {
            results.add(((CacheKey)objects.nextElement()).getObject());
        }
        return results;
    }

    public Integer getNumberOfObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        return this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange).getSize();
    }

    public List getObjectsInIdentityMapSubCacheAsMap(String className) throws ClassNotFoundException {
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map2 = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        List subCache = new ArrayList(0);
        if (ClassConstants.HardCacheWeakIdentityMap_Class.isAssignableFrom(map2.getClass())) {
            subCache = ((HardCacheWeakIdentityMap)map2).getReferenceCache();
        }
        return subCache;
    }

    public Integer getNumberOfObjectsInIdentityMapSubCache(String className) throws ClassNotFoundException {
        Integer result2 = 0;
        Class classToChange = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map2 = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classToChange);
        if (map2.getClass().isAssignableFrom(ClassConstants.HardCacheWeakIdentityMap_Class)) {
            ExposedNodeLinkedList subCache = ((HardCacheWeakIdentityMap)map2).getReferenceCache();
            result2 = subCache.size();
        }
        return result2;
    }

    public int getLogLevel(String category) {
        return this.getSession().getLogLevel(category);
    }

    public void setLogLevel(int level) {
        this.getSession().setLogLevel(level);
    }

    public boolean shouldLog(int Level2, String category) {
        return this.getSession().shouldLog(Level2, category);
    }

    public int getProfileWeight() {
        if (this.getSession().isInProfile()) {
            return this.getSession().getProfiler().getProfileWeight();
        }
        return 0;
    }

    public void setProfileWeight(int weight) {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().setProfileWeight(weight);
        }
    }

    public synchronized void initializeIdentityMap(String className) throws ClassNotFoundException {
        Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().initializeIdentityMap(registeredClass);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_initialized", className);
    }

    public void printIdentityMapLocks() {
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks();
    }

    public void printIdentityMapLocks(String registeredClassName) {
        Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks(registeredClass);
    }

    public void printProfileSummary() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(performanceProfiler.buildProfileSummary().toString());
    }

    private String trimProfileString(String originalProfileString) {
        if (originalProfileString.length() > 1) {
            String trimmedString = originalProfileString.substring(0, originalProfileString.length());
            if (trimmedString.charAt(0) == '{' && trimmedString.charAt(trimmedString.length() - 1) == '}') {
                trimmedString = trimmedString.substring(1, trimmedString.length() - 1);
            }
            return trimmedString;
        }
        return originalProfileString;
    }

    public void printProfileSummaryByClass() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByClass().toString()));
    }

    public void printProfileSummaryByQuery() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByQuery().toString()));
    }

    public synchronized String getProfilingType() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return EclipseLink_Product_Name;
        }
        return "None";
    }

    public synchronized void setProfilingType(String profileType) {
        if (profileType == null || profileType.compareToIgnoreCase("None") == 0) {
            this.setUseNoProfiling();
        } else if (profileType.compareToIgnoreCase(EclipseLink_Product_Name) == 0) {
            this.setUseEclipseLinkProfiling();
        }
    }

    public void setUseEclipseLinkProfiling() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        this.getSession().setProfiler(new PerformanceProfiler());
    }

    public void setUseNoProfiling() {
        this.getSession().setProfiler(null);
    }

    public Boolean getUsesEclipseLinkProfiling() {
        return this.getSession().getProfiler() instanceof PerformanceProfiler;
    }

    public String getDeployedEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.getDeployedSessionLog().getLevel());
    }

    public String getCurrentEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.getSession().getSessionLog().getLevel());
    }

    public synchronized void setCurrentEclipseLinkLogLevel(String newLevel) {
        this.getSession().setLogLevel(this.getLogLevelForName(newLevel));
    }

    private String getNameForLogLevel(int logLevel) {
        switch (logLevel) {
            case 0: {
                return "ALL";
            }
            case 7: {
                return "SEVERE";
            }
            case 6: {
                return "WARNING";
            }
            case 5: {
                return "INFO";
            }
            case 4: {
                return "CONFIG";
            }
            case 3: {
                return "FINE";
            }
            case 2: {
                return "FINER";
            }
            case 1: {
                return "FINEST";
            }
            case 8: {
                return "OFF";
            }
        }
        return "N/A";
    }

    private int getLogLevelForName(String levelName) {
        if (levelName.equals("ALL")) {
            return 0;
        }
        if (levelName.equals("SEVERE")) {
            return 7;
        }
        if (levelName.equals("WARNING")) {
            return 6;
        }
        if (levelName.equals("INFO")) {
            return 5;
        }
        if (levelName.equals("CONFIG")) {
            return 4;
        }
        if (levelName.equals("FINE")) {
            return 3;
        }
        if (levelName.equals("FINER")) {
            return 2;
        }
        if (levelName.equals("FINEST")) {
            return 1;
        }
        return 8;
    }

    protected void updateDeploymentTimeData() {
        this.deployedSessionLog = (SessionLog)((AbstractSessionLog)this.session.getSessionLog()).clone();
        this.deployedSessionProfileWeight = this.session.getProfiler() == null ? -1 : this.session.getProfiler().getProfileWeight();
    }

    public int getDeployedSessionProfileWeight() {
        return this.deployedSessionProfileWeight;
    }

    public SessionLog getDeployedSessionLog() {
        return this.deployedSessionLog;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isJPASession() {
        return true;
    }

    public String getSessionType() {
        return Helper.getShortClassName(this.getSession().getClass());
    }

    public Object[][] getClassSummaryDetailsUsingFilter(String filter2) {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetailsUsingFilter(filter2), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }

    public Object[][] getClassSummaryDetails() {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetails(), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }

    private Vector getMappedClassNames() {
        HashMap<String, Boolean> alreadyAdded = new HashMap<String, Boolean>();
        Vector<String> mappedClassNames = new Vector<String>();
        String mappedClassName = null;
        for (ClassDescriptor nextDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (nextDescriptor.getCMPPolicy() != null && nextDescriptor.getCMPPolicy().getMappedClass() != null) {
                mappedClassName = nextDescriptor.getCMPPolicy().getMappedClass().getName();
            }
            if (mappedClassName == null) {
                mappedClassName = nextDescriptor.getJavaClassName();
            }
            if (alreadyAdded.get(mappedClassName) == null) {
                alreadyAdded.put(mappedClassName, Boolean.TRUE);
                mappedClassNames.addElement(mappedClassName);
            }
            mappedClassName = null;
        }
        return mappedClassNames;
    }

    public Vector getMappedClassNamesUsingFilter(String filter2) {
        Vector<String> outputVector = new Vector<String>();
        Vector mappedClassNames = this.getMappedClassNames();
        ArrayList<String> filters = new ArrayList<String>();
        StringTokenizer lineTokens = new StringTokenizer(filter2, ",");
        while (lineTokens.hasMoreTokens()) {
            filters.add(lineTokens.nextToken());
        }
        int i = 0;
        while (i < mappedClassNames.size()) {
            String className = (String)mappedClassNames.get(i);
            String classNameLowerCase = ((String)mappedClassNames.get(i)).toLowerCase();
            int j = 0;
            while (j < filters.size()) {
                String filterValue = Helper.rightTrimString((String)filters.get(j)).trim().toLowerCase();
                if (filterValue.indexOf(42) == 0) {
                    filterValue = filterValue.substring(1);
                }
                try {
                    if (classNameLowerCase.matches(new StringBuffer().append("^.*").append(filterValue).append(".*$").toString()) && !outputVector.contains(className)) {
                        outputVector.add(className);
                    }
                }
                catch (PatternSyntaxException exception) {
                    AbstractSessionLog.getLog().log(1, "pattern_syntax_error", exception);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(outputVector);
        return outputVector;
    }

    protected String getCacheTypeFor(Class identityMapClass) {
        if (identityMapClass == CacheIdentityMap.class) {
            return "Cache";
        }
        if (identityMapClass == FullIdentityMap.class) {
            return "Full";
        }
        if (identityMapClass == HardCacheWeakIdentityMap.class) {
            return "HardWeak";
        }
        if (identityMapClass == NoIdentityMap.class) {
            return "None";
        }
        if (identityMapClass == SoftCacheWeakIdentityMap.class) {
            return "SoftWeak";
        }
        if (identityMapClass == WeakIdentityMap.class) {
            return "Weak";
        }
        if (identityMapClass == SoftIdentityMap.class) {
            return "Soft";
        }
        return "N/A";
    }

    public String getModuleName() {
        return ((DatabaseSessionImpl)this.getSession()).getServerPlatform().getModuleName();
    }

    public String getApplicationName() {
        return ((JMXEnabledPlatform)((Object)((DatabaseSessionImpl)this.getSession()).getServerPlatform())).getApplicationName();
    }

    public Boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public Integer getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        if (!((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding()) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize();
    }

    public Boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public Long getTimeConnectionEstablished() {
        return ((DatabaseSessionImpl)this.getSession()).getConnectedTime();
    }

    public Boolean getUsesJDBCBatchWriting() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public Boolean getUsesByteArrayBinding() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public Boolean getUsesNativeSQL() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public Boolean getUsesStreamsForBinding() {
        if (!(this.getSession().getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform)) {
            return Boolean.FALSE;
        }
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public Boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding();
    }

    public boolean getShouldCacheAllStatements() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldCacheAllStatements();
    }

    public synchronized void clearStatementCache() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseAccessor)this.getSession().getAccessor()).clearStatementCache(this.getSession());
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_statement_cache_cleared");
    }

    public void printAvailableConnectionPools() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map<String, ConnectionPool> pools = ((ServerSession)this.getSession()).getConnectionPools();
            Iterator<String> poolNames = pools.keySet().iterator();
            while (poolNames.hasNext()) {
                String poolName = poolNames.next().toString();
                ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_pool_name", poolName);
            }
        } else {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_connection_pools_available");
        }
    }

    public Integer getMaxSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            return connectionPool.getMaxNumberOfConnections();
        }
        return -1;
    }

    public Integer getMinSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            return connectionPool.getMinNumberOfConnections();
        }
        return -1;
    }

    public void printClassesInSession() {
        Vector classes = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classes.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_classes_in_session");
            return;
        }
        int index = 0;
        while (index < classes.size()) {
            this.getSession().getSessionLog().log(1, (String)classes.elementAt(index));
            ++index;
        }
    }

    public void printObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classWithMap = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map2 = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classWithMap);
        if (map2 == null) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_non_existent", className);
            return;
        }
        Enumeration objects = map2.keys();
        if (!objects.hasMoreElements()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_empty", className);
        }
        while (objects.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)objects.nextElement();
            if (cacheKey == null || cacheKey.getKey() == null || cacheKey.getObject() == null) continue;
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_print_cache_key_value", cacheKey.getKey().toString(), cacheKey.getObject().toString());
        }
    }

    public void printAllIdentityMapTypes() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        int index = 0;
        while (index < classesRegistered.size()) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, ClassConstants.CLASS);
            IdentityMap map2 = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(registeredClass);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_class", registeredClassName, map2.getClass());
            ++index;
        }
    }

    public void printObjectsInIdentityMaps() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        int index = 0;
        while (index < classesRegistered.size()) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            try {
                this.printObjectsInIdentityMap(registeredClassName);
            }
            catch (ClassNotFoundException classNotFound) {
                classNotFound.printStackTrace();
                AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)classNotFound);
            }
            ++index;
        }
    }

    public Integer getNumberOfObjectsInAllIdentityMaps() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        int sum2 = 0;
        if (classesRegistered.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return 0;
        }
        int index = 0;
        while (index < classesRegistered.size()) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            try {
                sum2 += this.getNumberOfObjectsInIdentityMap(registeredClassName).intValue();
            }
            catch (ClassNotFoundException classNotFound) {
                classNotFound.printStackTrace();
                AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)classNotFound);
            }
            ++index;
        }
        return sum2;
    }

    public Integer getNumberOfPersistentClasses() {
        HashMap<String, Boolean> classesTable = new HashMap<String, Boolean>();
        for (ClassDescriptor currentDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (currentDescriptor.isAggregateDescriptor()) continue;
            classesTable.put(currentDescriptor.getJavaClassName(), Boolean.TRUE);
        }
        return classesTable.size();
    }

    public String getLogType() {
        if (this.getSession().getSessionLog().getClass() == JavaLog.class) {
            return "Java";
        }
        if (this.getSession().getSessionLog().getClass() == DefaultSessionLog.class) {
            return EclipseLink_Product_Name;
        }
        return this.getSession().getSessionLog().getClass().getSimpleName();
    }

    public String getDatabasePlatform() {
        return this.getSession().getDatasourcePlatform().getClass().getName();
    }

    public synchronized String getJdbcConnectionDetails() {
        return this.getSession().getLogin().getConnector().getConnectionDetails();
    }

    public synchronized String getConnectionPoolType() {
        if (this.getSession().getLogin().shouldUseExternalConnectionPooling()) {
            return "External";
        }
        return "N/A";
    }

    public synchronized String getDriver() {
        if (this.getSession().getLogin().getConnector() instanceof DefaultConnector) {
            return this.getSession().getLogin().getDriverClassName();
        }
        return "N/A";
    }

    public String getLogFilename() {
        if (this.session.getSessionLog() instanceof DefaultSessionLog) {
            return ((DefaultSessionLog)this.session.getSessionLog()).getWriterFilename();
        }
        return null;
    }

    public synchronized void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public synchronized void initializeIdentityMaps(String[] classNames) throws ClassNotFoundException {
        int index = 0;
        while (index < classNames.length) {
            this.initializeIdentityMap(classNames[index]);
            ++index;
        }
    }

    public synchronized void invalidateAllIdentityMaps() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
        }
        int index = 0;
        while (index < classesRegistered.size()) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, ClassConstants.CLASS);
            this.getSession().getIdentityMapAccessor().invalidateClass(registeredClass);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", registeredClassName);
            ++index;
        }
    }

    public synchronized void invalidateIdentityMaps(String[] classNamesParam, Boolean recurse) throws ClassNotFoundException {
        String[] classNames = classNamesParam;
        int index = 0;
        while (index < classNames.length) {
            this.invalidateIdentityMap(classNames[index], recurse);
            ++index;
        }
    }

    public synchronized void invalidateIdentityMap(String className) throws ClassNotFoundException {
        this.invalidateIdentityMap(className, Boolean.FALSE);
    }

    public synchronized void invalidateIdentityMap(String className, Boolean recurse) throws ClassNotFoundException {
        Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().invalidateClass(registeredClass);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", className);
    }

    private Object[][] tabularDataTo2DArray(TabularData tdata, String[] names) throws Exception {
        if (tdata == null) {
            return null;
        }
        Object[] rows = tdata.values().toArray();
        Object[][] data = new Object[rows.length][];
        int i = 0;
        while (i < rows.length) {
            CompositeData cdata = (CompositeData)rows[i];
            Object[] returnRow = new Object[names.length];
            int j = 0;
            while (j < names.length) {
                String name = names[j];
                Object value2 = cdata.get(name);
                returnRow[j] = String.valueOf(name) + " : " + String.valueOf(value2);
                ++j;
            }
            data[i] = returnRow;
            ++i;
        }
        return data;
    }

    protected void setSession(AbstractSession newSession) {
        this.session = newSession;
        this.updateDeploymentTimeData();
    }

    private CompositeType buildCompositeTypeForClassSummaryDetails() throws OpenDataException {
        return new CompositeType("Class Details", "Details of class for Class Summary", new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
    }

    public List<ClassSummaryDetailBase> getClassSummaryDetailsUsingFilterArray(String filter2) {
        ArrayList<ClassSummaryDetailBase> classSummaryDetails;
        Vector mappedClassNames;
        block5: {
            if (filter2 == null) {
                return this.getClassSummaryDetailsArray();
            }
            mappedClassNames = this.getMappedClassNamesUsingFilter(filter2);
            classSummaryDetails = new ArrayList<ClassSummaryDetailBase>();
            if (mappedClassNames.size() != 0) break block5;
            return null;
        }
        try {
            int index = 0;
            while (index < mappedClassNames.size()) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                classSummaryDetails.add((ClassSummaryDetailBase)((Object)this.buildLowlevelDetailsFor(mappedClassName)));
                ++index;
            }
            return classSummaryDetails;
        }
        catch (Exception openTypeException) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)openTypeException);
            openTypeException.printStackTrace();
            return null;
        }
    }

    public List<ClassSummaryDetailBase> getClassSummaryDetailsArray() {
        ArrayList<ClassSummaryDetailBase> classSummaryDetails;
        Vector mappedClassNames;
        block4: {
            mappedClassNames = this.getMappedClassNames();
            classSummaryDetails = new ArrayList<ClassSummaryDetailBase>();
            if (mappedClassNames.size() != 0) break block4;
            return null;
        }
        try {
            int index = 0;
            while (index < mappedClassNames.size()) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                classSummaryDetails.add((ClassSummaryDetailBase)((Object)this.buildLowlevelDetailsFor(mappedClassName)));
                ++index;
            }
            return classSummaryDetails;
        }
        catch (Exception openTypeException) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)openTypeException);
            openTypeException.printStackTrace();
            return null;
        }
    }

    private TabularType buildTabularTypeForClassSummaryDetails() throws OpenDataException {
        return new TabularType(this.getSessionName(), "Session description", this.buildCompositeTypeForClassSummaryDetails(), new String[]{"Class Name"});
    }

    private CompositeData buildDetailsFor(String mappedClassName, CompositeType detailsType) throws Exception {
        return new CompositeDataSupport(detailsType, this.buildLowlevelDetailsFor(mappedClassName));
    }

    private HashMap buildLowlevelDetailsFor(String mappedClassName) {
        Class mappedClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(mappedClassName, ClassConstants.CLASS);
        ClassDescriptor descriptor = this.getSession().getProject().getDescriptor(mappedClass);
        String cacheType = "";
        String configuredSize = "";
        String currentSize = "";
        String parentClassName = "";
        if (!descriptor.isAggregateDescriptor()) {
            IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(descriptor);
            cacheType = this.getCacheTypeFor(identityMap.getClass());
            configuredSize = String.valueOf(identityMap.getMaxSize());
            currentSize = String.valueOf(identityMap.getSize(mappedClass, true));
        }
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getParentDescriptor() != null) {
            parentClassName = descriptor.getInheritancePolicy().getParentClassName();
        }
        boolean isChildDescriptor = descriptor.isChildDescriptor();
        HashMap<String, String> details = new HashMap<String, String>(5);
        details.put("Class Name", mappedClassName);
        details.put("Cache Type", isChildDescriptor ? "" : cacheType);
        details.put("Configured Size", isChildDescriptor ? "" : configuredSize);
        details.put("Current Size", currentSize);
        details.put("Parent Class Name", parentClassName);
        return details;
    }

    private TabularData buildClassSummaryDetailsUsingFilter(String filter2) {
        TabularDataSupport rowData;
        Vector mappedClassNames;
        block5: {
            if (filter2 == null) {
                return this.buildClassSummaryDetails();
            }
            mappedClassNames = this.getMappedClassNamesUsingFilter(filter2);
            rowData = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (mappedClassNames.size() != 0) break block5;
            return null;
        }
        try {
            int index = 0;
            while (index < mappedClassNames.size()) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                String[] key = new String[]{mappedClassName};
                rowData.put(key, this.buildDetailsFor(mappedClassName, rowData.getTabularType().getRowType()));
                ++index;
            }
            return rowData;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }

    private TabularData buildClassSummaryDetails() {
        TabularDataSupport rowData;
        Vector mappedClassNames;
        block4: {
            mappedClassNames = this.getMappedClassNames();
            rowData = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (mappedClassNames.size() != 0) break block4;
            return null;
        }
        try {
            int index = 0;
            while (index < mappedClassNames.size()) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                String[] key = new String[]{mappedClassName};
                rowData.put(key, this.buildDetailsFor(mappedClassName, rowData.getTabularType().getRowType()));
                ++index;
            }
            return rowData;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "jmx_enabled_platform_mbean_runtime_exception", PLATFORM_NAME, (Object)exception);
            return null;
        }
    }
}

