/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class FieldDefinition
implements Serializable,
Cloneable {
    protected String name;
    protected Class type;
    protected String typeName;
    protected DatabaseField field;
    protected String typeDefinition;
    protected int size;
    protected int subSize;
    protected boolean shouldAllowNull;
    protected boolean isIdentity;
    protected boolean isPrimaryKey;
    protected boolean isUnique;
    protected String additional;
    protected String constraint;
    protected String foreignKeyFieldName;

    public FieldDefinition() {
        this.name = "";
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String name, Class type) {
        this.name = name;
        this.type = type;
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String name, Class type, int size2) {
        this();
        this.name = name;
        this.type = type;
        this.size = size2;
    }

    public FieldDefinition(String name, Class type, int size2, int subSize) {
        this();
        this.name = name;
        this.type = type;
        this.size = size2;
        this.subSize = subSize;
    }

    public FieldDefinition(String name, String typeName) {
        this();
        this.name = name;
        this.typeName = typeName;
    }

    public void appendDBString(Writer writer, AbstractSession session, TableDefinition table) throws ValidationException {
        try {
            writer.write(this.getName());
            writer.write(" ");
            if (this.getTypeDefinition() != null) {
                writer.write(this.getTypeDefinition());
            } else {
                FieldTypeDefinition fieldType;
                DatabasePlatform platform = session.getPlatform();
                if (this.getType() != null) {
                    fieldType = platform.getFieldTypeDefinition(this.getType());
                    if (fieldType == null) {
                        throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
                    }
                } else if (this.getTypeName() != null) {
                    Map<String, Class> fieldTypes = platform.getClassTypes();
                    Class type = fieldTypes.get(this.getTypeName());
                    if (type == null) {
                        fieldType = new FieldTypeDefinition(this.getTypeName());
                    } else {
                        fieldType = platform.getFieldTypeDefinition(type);
                        if (fieldType == null) {
                            throw ValidationException.javaTypeIsNotAValidDatabaseType(type);
                        }
                    }
                } else {
                    throw ValidationException.javaTypeIsNotAValidDatabaseType(null);
                }
                String qualifiedName = String.valueOf(table.getFullName()) + '.' + this.getName();
                boolean shouldPrintFieldIdentityClause = this.isIdentity() && platform.shouldPrintFieldIdentityClause(session, qualifiedName);
                platform.printFieldTypeSize(writer, this, fieldType, shouldPrintFieldIdentityClause);
                if (shouldPrintFieldIdentityClause) {
                    platform.printFieldIdentityClause(writer);
                }
                if (this.shouldAllowNull() && fieldType.shouldAllowNull()) {
                    platform.printFieldNullClause(writer);
                } else {
                    platform.printFieldNotNullClause(writer);
                }
                if (this.isUnique()) {
                    if (platform.supportsUniqueColumns()) {
                        platform.printFieldUnique(writer, shouldPrintFieldIdentityClause);
                    } else {
                        this.setUnique(false);
                        String constraintName = table.buildUniqueKeyConstraintName(table.getName(), table.getFields().indexOf(this), platform.getMaxUniqueKeyNameSize());
                        table.addUniqueKeyConstraint(constraintName, this.getName());
                    }
                }
                if (this.getConstraint() != null) {
                    writer.write(" " + this.getConstraint());
                }
                if (this.getAdditional() != null) {
                    writer.write(" " + this.getAdditional());
                }
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void appendTypeString(Writer writer, AbstractSession session) throws ValidationException {
        FieldTypeDefinition fieldType;
        if (this.getType() != null) {
            fieldType = session.getPlatform().getFieldTypeDefinition(this.getType());
            if (fieldType == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
            }
        } else {
            fieldType = new FieldTypeDefinition(this.getTypeName());
        }
        try {
            writer.write(this.getName());
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && (this.getSize() != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (this.getSize() == 0) {
                    writer.write(Integer.valueOf(fieldType.getDefaultSize()).toString());
                } else {
                    writer.write(Integer.valueOf(this.getSize()).toString());
                }
                if (this.getSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.valueOf(this.getSubSize()).toString());
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.valueOf(fieldType.getDefaultSubSize()).toString());
                }
                writer.write(")");
            }
            if (this.getAdditional() != null) {
                writer.write(" " + this.getAdditional());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getAdditional() {
        return this.additional;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getForeignKeyFieldName() {
        return this.foreignKeyFieldName;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseField getDatabaseField() {
        return this.field;
    }

    public int getSize() {
        return this.size;
    }

    public int getSubSize() {
        return this.subSize;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setAdditional(String string2) {
        this.additional = string2;
    }

    public void setConstraint(String string2) {
        this.constraint = string2;
    }

    public void setForeignKeyFieldName(String foreignKeyFieldName) {
        this.foreignKeyFieldName = foreignKeyFieldName;
    }

    public void setIsIdentity(boolean value2) {
        this.isIdentity = value2;
        if (value2) {
            this.setShouldAllowNull(false);
        }
    }

    public void setIsPrimaryKey(boolean value2) {
        this.isPrimaryKey = value2;
        if (value2) {
            this.setShouldAllowNull(false);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDatabaseField(DatabaseField field2) {
        this.field = field2;
    }

    public void setShouldAllowNull(boolean value2) {
        this.shouldAllowNull = value2;
    }

    public void setSize(int size2) {
        this.size = size2;
    }

    public void setSubSize(int subSize) {
        this.subSize = subSize;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypeDefinition(String typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public void setUnique(boolean value2) {
        this.isUnique = value2;
    }

    public boolean shouldAllowNull() {
        return this.shouldAllowNull;
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + this.getName() + "(" + this.getType() + "))";
    }
}

