/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.InputStreamWrapper;

public class ProgressMonitoredInputStream
extends InputStream
implements InputStreamWrapper {
    private InputStream inputStream = null;
    protected BytesProgressWatcher progressWatcher = null;

    public ProgressMonitoredInputStream(InputStream inputStream, BytesProgressWatcher progressWatcher) {
        if (inputStream == null) {
            throw new IllegalArgumentException("ProgressMonitoredInputStream cannot run with a null InputStream");
        }
        this.inputStream = inputStream;
        this.progressWatcher = progressWatcher;
    }

    public void sendNotificationUpdate(long bytesTransmitted) {
        this.progressWatcher.updateBytesTransferred(bytesTransmitted);
    }

    public void resetProgressMonitor() {
        this.progressWatcher.resetWatcher();
    }

    public int read() throws IOException {
        int read2 = this.inputStream.read();
        if (read2 != -1) {
            this.sendNotificationUpdate(1L);
        }
        return read2;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read2 = this.inputStream.read(b, off, len);
        if (read2 != -1) {
            this.sendNotificationUpdate(read2);
        }
        return read2;
    }

    public int read(byte[] b) throws IOException {
        int read2 = this.inputStream.read(b);
        if (read2 != -1) {
            this.sendNotificationUpdate(read2);
        }
        return read2;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.inputStream.close();
        }
        finally {
            this.progressWatcher.clearHistory();
        }
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

