/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jets3t.service.model.StorageOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStorageItem {
    public static final String METADATA_HEADER_CREATION_DATE = "Date";
    public static final String METADATA_HEADER_LAST_MODIFIED_DATE = "Last-Modified";
    public static final String METADATA_HEADER_DATE = "Date";
    public static final String METADATA_HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String METADATA_HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String METADATA_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String METADATA_HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String METADATA_HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String METADATA_HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String METADATA_HEADER_ETAG = "ETag";
    private String name = null;
    private StorageOwner owner = null;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    protected BaseStorageItem(String name) {
        this.name = name;
    }

    protected BaseStorageItem() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMetadataMap() {
        return Collections.unmodifiableMap(this.metadata);
    }

    protected boolean isMatchingMetadataName(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return name1.toLowerCase().equals(name2.toLowerCase());
    }

    public Object getMetadata(String name) {
        for (Map.Entry<String, Object> entry2 : this.metadata.entrySet()) {
            if (!this.isMatchingMetadataName(entry2.getKey(), name)) continue;
            return entry2.getValue();
        }
        return null;
    }

    public boolean containsMetadata(String name) {
        for (Map.Entry<String, Object> entry2 : this.metadata.entrySet()) {
            if (!this.isMatchingMetadataName(entry2.getKey(), name)) continue;
            return true;
        }
        return false;
    }

    protected void addMetadata(String name, Object value2) {
        this.removeMetadata(name);
        this.metadata.put(name, value2);
    }

    public void addMetadata(String name, String value2) {
        this.addMetadata(name, (Object)value2);
    }

    public void addMetadata(String name, Date value2) {
        this.addMetadata(name, (Object)value2);
    }

    public void addMetadata(String name, StorageOwner value2) {
        this.addMetadata(name, (Object)value2);
    }

    public void addAllMetadata(Map<String, Object> metadataToAdd) {
        for (Map.Entry<String, Object> entry2 : metadataToAdd.entrySet()) {
            this.addMetadata(entry2.getKey(), entry2.getValue());
        }
    }

    public void removeMetadata(String name) {
        String existingItemKey = null;
        for (Map.Entry<String, Object> entry2 : this.metadata.entrySet()) {
            if (!this.isMatchingMetadataName(entry2.getKey(), name)) continue;
            existingItemKey = entry2.getKey();
        }
        if (existingItemKey != null || name == null) {
            this.metadata.remove(existingItemKey);
        }
    }

    public void replaceAllMetadata(Map<String, Object> metadata) {
        this.metadata.clear();
        this.addAllMetadata(metadata);
    }

    public StorageOwner getOwner() {
        return this.owner;
    }

    public void setOwner(StorageOwner owner) {
        this.owner = owner;
    }
}

