/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.util.StringMap;

public class BufferCache {
    private HashMap _bufferMap = new HashMap();
    private StringMap _stringMap = new StringMap(true);
    private ArrayList _index = new ArrayList();

    public CachedBuffer add(String value2, int ordinal) {
        CachedBuffer buffer = new CachedBuffer(value2, ordinal);
        this._bufferMap.put(buffer, buffer);
        this._stringMap.put(value2, (Object)buffer);
        while (ordinal - this._index.size() > 0) {
            this._index.add(null);
        }
        this._index.add(ordinal, buffer);
        return buffer;
    }

    public CachedBuffer get(int ordinal) {
        if (ordinal < 0 || ordinal >= this._index.size()) {
            return null;
        }
        return (CachedBuffer)this._index.get(ordinal);
    }

    public CachedBuffer get(Buffer buffer) {
        return (CachedBuffer)this._bufferMap.get(buffer);
    }

    public CachedBuffer get(String value2) {
        return (CachedBuffer)this._stringMap.get(value2);
    }

    public Buffer lookup(Buffer buffer) {
        CachedBuffer b = this.get(buffer);
        if (b == null) {
            if (buffer instanceof Buffer.CaseInsensitve) {
                return buffer;
            }
            return new View.CaseInsensitive(buffer);
        }
        return b;
    }

    public CachedBuffer getBest(byte[] value2, int offset2, int maxLength) {
        Map.Entry entry2 = this._stringMap.getBestEntry(value2, offset2, maxLength);
        if (entry2 != null) {
            return (CachedBuffer)entry2.getValue();
        }
        return null;
    }

    public Buffer lookup(String value2) {
        CachedBuffer b = this.get(value2);
        if (b == null) {
            return new CachedBuffer(value2, -1);
        }
        return b;
    }

    public String toString(Buffer buffer) {
        return this.lookup(buffer).toString();
    }

    public int getOrdinal(Buffer buffer) {
        if (buffer instanceof CachedBuffer) {
            return ((CachedBuffer)buffer).getOrdinal();
        }
        if ((buffer = this.lookup(buffer)) != null && buffer instanceof CachedBuffer) {
            return ((CachedBuffer)buffer).getOrdinal();
        }
        return -1;
    }

    public String toString() {
        return "CACHE[bufferMap=" + this._bufferMap + ",stringMap=" + this._stringMap + ",index=" + this._index + "]";
    }

    public static class CachedBuffer
    extends ByteArrayBuffer.CaseInsensitive {
        private int _ordinal;
        private HashMap _associateMap = null;

        public CachedBuffer(String value2, int ordinal) {
            super(value2);
            this._ordinal = ordinal;
        }

        public int getOrdinal() {
            return this._ordinal;
        }

        public CachedBuffer getAssociate(Object key) {
            if (this._associateMap == null) {
                return null;
            }
            return (CachedBuffer)this._associateMap.get(key);
        }

        public void setAssociate(Object key, CachedBuffer associate) {
            if (this._associateMap == null) {
                this._associateMap = new HashMap();
            }
            this._associateMap.put(key, associate);
        }
    }
}

