/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.mortbay.io.nio.JVMBUG_THRESHHOLD", 512);
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.mortbay.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.mortbay.io.nio.MAX_SELECTS", 15000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.mortbay.io.nio.BUSY_PAUSE", 50);
    private static final int __BUSY_KEY = Integer.getInteger("org.mortbay.io.nio.BUSY_KEY", -1);
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel channel, Object att) throws IOException {
        int s2 = this._set++;
        s2 %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s2];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) throws IOException {
        int s2 = this._set++;
        SelectSet set = this._selectSet[s2 %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean delaySelectKeyUpdate) {
        this._delaySelectKeyUpdate = delaySelectKeyUpdate;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                SelectSet set = sets[i];
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn(ex);
    }

    static /* synthetic */ long access$100(SelectorManager x0) {
        return x0._lowResourcesConnections;
    }

    static /* synthetic */ long access$200(SelectorManager x0) {
        return x0._lowResourcesMaxIdleTime;
    }

    static /* synthetic */ long access$300(SelectorManager x0) {
        return x0._maxIdleTime;
    }

    static /* synthetic */ int access$400() {
        return __BUSY_PAUSE;
    }

    static /* synthetic */ int access$500() {
        return __MAX_SELECTS;
    }

    static /* synthetic */ int access$600() {
        return __JVMBUG_THRESHHOLD;
    }

    static /* synthetic */ int access$700() {
        return __BUSY_KEY;
    }

    static /* synthetic */ SelectSet[] access$800(SelectorManager x0) {
        return x0._selectSet;
    }

    private static interface ChangeTask {
        public void run();
    }

    private static class ChangeSelectableChannel {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChangeSelectableChannel(SelectableChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private volatile boolean _selecting;
        private transient int _jvmBug;
        private int _selects;
        private long _monitorStart;
        private long _monitorNext;
        private boolean _pausing;
        private SelectionKey _busyKey;
        private int _busyKeyCount;
        private long _log;
        private int _paused;
        private int _jvmFix0;
        private int _jvmFix1;
        private int _jvmFix2;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout(this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout(this);
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
            this._monitorStart = System.currentTimeMillis();
            this._monitorNext = this._monitorStart + (long)__MONITOR_PERIOD;
            this._log = this._monitorStart + 60000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SelectableChannel channel, Object att) {
            if (att == null) {
                this.addChange(channel);
            } else if (att instanceof EndPoint) {
                this.addChange(att);
            } else {
                this.addChange(new ChangeSelectableChannel(channel, att));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doSelect() throws IOException {
            key = null;
            try {
                var4_2 = this._changes;
                synchronized (this._changes) {
                    block80: {
                        block82: {
                            block86: {
                                block85: {
                                    block83: {
                                        block84: {
                                            changes = this._changes[this._change];
                                            this._change = this._change == 0 ? 1 : 0;
                                            this._selecting = true;
                                            selector = this._selector;
                                            // ** MonitorExit[var4_2] (shouldn't be in output)
                                            try {
                                                for (i = 0; i < changes.size(); ++i) {
                                                    try {
                                                        o = changes.get(i);
                                                        if (o instanceof EndPoint) {
                                                            endpoint = (SelectChannelEndPoint)o;
                                                            endpoint.doUpdateKey();
                                                            continue;
                                                        }
                                                        if (o instanceof Runnable) {
                                                            SelectorManager.this.dispatch((Runnable)o);
                                                            continue;
                                                        }
                                                        if (o instanceof ChangeSelectableChannel) {
                                                            asc = (ChangeSelectableChannel)o;
                                                            channel = asc._channel;
                                                            att = asc._attachment;
                                                            if (channel instanceof SocketChannel && ((SocketChannel)channel).isConnected()) {
                                                                key = channel.register(selector, 1, att);
                                                                endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                                                key.attach(endpoint);
                                                                endpoint.dispatch();
                                                                continue;
                                                            }
                                                            if (!channel.isOpen()) continue;
                                                            channel.register(selector, 8, att);
                                                            continue;
                                                        }
                                                        if (o instanceof SocketChannel) {
                                                            channel = (SocketChannel)o;
                                                            if (channel.isConnected()) {
                                                                key = channel.register(selector, 1, null);
                                                                endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                                                key.attach(endpoint);
                                                                endpoint.dispatch();
                                                                continue;
                                                            }
                                                            if (!channel.isOpen()) continue;
                                                            channel.register(selector, 8, null);
                                                            continue;
                                                        }
                                                        if (o instanceof ServerSocketChannel) {
                                                            channel = (ServerSocketChannel)o;
                                                            channel.register(this.getSelector(), 16);
                                                            continue;
                                                        }
                                                        if (o instanceof ChangeTask == false) throw new IllegalArgumentException(o.toString());
                                                        ((ChangeTask)o).run();
                                                        continue;
                                                    }
                                                    catch (Exception e) {
                                                        if (SelectorManager.this.isRunning()) {
                                                            Log.warn(e);
                                                            continue;
                                                        }
                                                        Log.debug(e);
                                                        continue;
                                                    }
                                                    catch (Error e) {
                                                        if (SelectorManager.this.isRunning()) {
                                                            Log.warn(e);
                                                            continue;
                                                        }
                                                        Log.debug(e);
                                                    }
                                                }
                                            }
                                            finally {
                                                changes.clear();
                                            }
                                            idle_next = 0L;
                                            retry_next = 0L;
                                            now = System.currentTimeMillis();
                                            var10_19 = this;
                                            synchronized (var10_19) {
                                                this._idleTimeout.setNow(now);
                                                this._retryTimeout.setNow(now);
                                                if (SelectorManager.access$100(SelectorManager.this) > 0L && (long)selector.keys().size() > SelectorManager.access$100(SelectorManager.this)) {
                                                    this._idleTimeout.setDuration(SelectorManager.access$200(SelectorManager.this));
                                                } else {
                                                    this._idleTimeout.setDuration(SelectorManager.access$300(SelectorManager.this));
                                                }
                                                idle_next = this._idleTimeout.getTimeToNext();
                                                retry_next = this._retryTimeout.getTimeToNext();
                                            }
                                            wait = 1000L;
                                            if (idle_next >= 0L && wait > idle_next) {
                                                wait = idle_next;
                                            }
                                            if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                                                wait = retry_next;
                                            }
                                            if (wait <= 2L) break block82;
                                            if (this._pausing) {
                                                try {
                                                    Thread.sleep(SelectorManager.access$400());
                                                }
                                                catch (InterruptedException e) {
                                                    Log.ignore(e);
                                                }
                                            }
                                            before = now;
                                            selected = selector.select(wait);
                                            now = System.currentTimeMillis();
                                            this._idleTimeout.setNow(now);
                                            this._retryTimeout.setNow(now);
                                            ++this._selects;
                                            if (now > this._monitorNext) {
                                                this._selects = (int)((long)(this._selects * SelectorManager.access$000()) / (now - this._monitorStart));
                                                v0 = this._pausing = this._selects > SelectorManager.access$500();
                                                if (this._pausing) {
                                                    ++this._paused;
                                                }
                                                this._selects = 0;
                                                this._jvmBug = 0;
                                                this._monitorStart = now;
                                                this._monitorNext = now + (long)SelectorManager.access$000();
                                            }
                                            if (now > this._log) {
                                                if (this._paused > 0) {
                                                    Log.info(this + " Busy selector - injecting delay " + this._paused + " times");
                                                }
                                                if (this._jvmFix2 > 0) {
                                                    Log.info(this + " JVM BUG(s) - injecting delay" + this._jvmFix2 + " times");
                                                }
                                                if (this._jvmFix1 > 0) {
                                                    Log.info(this + " JVM BUG(s) - recreating selector " + this._jvmFix1 + " times, canceled keys " + this._jvmFix0 + " times");
                                                } else if (Log.isDebugEnabled() && this._jvmFix0 > 0) {
                                                    Log.info(this + " JVM BUG(s) - canceled keys " + this._jvmFix0 + " times");
                                                }
                                                this._paused = 0;
                                                this._jvmFix2 = 0;
                                                this._jvmFix1 = 0;
                                                this._jvmFix0 = 0;
                                                this._log = now + 60000L;
                                            }
                                            if (selected != 0 || wait <= 10L || now - before >= wait / 2L) break block83;
                                            ++this._jvmBug;
                                            if (this._jvmBug <= SelectorManager.access$600()) break block84;
                                            try {
                                                if (this._jvmBug == SelectorManager.access$600() + 1) {
                                                    ++this._jvmFix2;
                                                }
                                                Thread.sleep(SelectorManager.access$400());
                                            }
                                            catch (InterruptedException e) {
                                                Log.ignore(e);
                                            }
                                            break block80;
                                        }
                                        if (this._jvmBug != SelectorManager.access$600()) ** GOTO lbl-1000
                                        e = this;
                                        synchronized (e) {
                                            ++this._jvmFix1;
                                            new_selector = Selector.open();
                                            iterator = this._selector.keys().iterator();
                                            while (iterator.hasNext()) {
                                                k = iterator.next();
                                                if (!k.isValid() || k.interestOps() == 0) continue;
                                                channel = k.channel();
                                                attachment = k.attachment();
                                                if (attachment == null) {
                                                    this.addChange(channel);
                                                    continue;
                                                }
                                                this.addChange(channel, attachment);
                                            }
                                            old_selector = this._selector;
                                            this._selector = new_selector;
                                            try {
                                                old_selector.close();
                                            }
                                            catch (Exception e) {
                                                Log.warn(e);
                                            }
                                            return;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            if (this._jvmBug % 32 != 31) break block80;
                                            cancelled = 0;
                                            ** break block81
                                        }
                                    }
                                    if (SelectorManager.access$700() <= 0 || selected != 1 || this._selects <= SelectorManager.access$500()) break block80;
                                    busy = selector.selectedKeys().iterator().next();
                                    if (busy != this._busyKey) break block85;
                                    if (++this._busyKeyCount > SelectorManager.access$700() && !(busy.channel() instanceof ServerSocketChannel)) {
                                        endpoint = (SelectChannelEndPoint)busy.attachment();
                                        Log.warn("Busy Key " + busy.channel() + " " + endpoint);
                                        busy.cancel();
                                        if (endpoint != null) {
                                            SelectorManager.this.dispatch(new Runnable(){

                                                public void run() {
                                                    try {
                                                        endpoint.close();
                                                    }
                                                    catch (IOException e) {
                                                        Log.ignore(e);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                    break block86;
                                }
                                this._busyKeyCount = 0;
                            }
                            this._busyKey = busy;
                            break block80;
                        }
                        selector.selectNow();
                        ++this._selects;
                    }
                    if (this._selector == null) return;
                    if (!selector.isOpen()) {
                        return;
                    }
                    iter = selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        try {
                            block88: {
                                block89: {
                                    block87: {
                                        if (!key.isValid()) {
                                            key.cancel();
                                            endpoint = (SelectChannelEndPoint)key.attachment();
                                            if (endpoint == null) continue;
                                            endpoint.doUpdateKey();
                                            continue;
                                        }
                                        att = key.attachment();
                                        if (!(att instanceof SelectChannelEndPoint)) break block87;
                                        endpoint = (SelectChannelEndPoint)att;
                                        endpoint.dispatch();
                                        break block88;
                                    }
                                    if (!key.isAcceptable()) break block89;
                                    channel = SelectorManager.this.acceptChannel(key);
                                    if (channel == null) continue;
                                    channel.configureBlocking(false);
                                    ++this._nextSet;
                                    this._nextSet %= SelectorManager.access$800(SelectorManager.this).length;
                                    if (this._nextSet == this._setID) {
                                        cKey = channel.register(SelectorManager.access$800(SelectorManager.this)[this._nextSet].getSelector(), 1);
                                        endpoint = SelectorManager.this.newEndPoint(channel, SelectorManager.access$800(SelectorManager.this)[this._nextSet], cKey);
                                        cKey.attach(endpoint);
                                        if (endpoint != null) {
                                            endpoint.dispatch();
                                        }
                                        break block88;
                                    } else {
                                        SelectorManager.access$800(SelectorManager.this)[this._nextSet].addChange(channel);
                                        SelectorManager.access$800(SelectorManager.this)[this._nextSet].wakeup();
                                    }
                                    break block88;
                                }
                                if (key.isConnectable()) {
                                    channel = (SocketChannel)key.channel();
                                    connected = false;
                                    try {
                                        connected = channel.finishConnect();
                                    }
                                    catch (Exception e) {
                                        SelectorManager.this.connectionFailed(channel, e, att);
                                    }
                                    finally {
                                        if (connected) {
                                            key.interestOps(1);
                                            endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                            key.attach(endpoint);
                                            endpoint.dispatch();
                                        } else {
                                            key.cancel();
                                        }
                                    }
                                } else {
                                    channel = (SocketChannel)key.channel();
                                    endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                    key.attach(endpoint);
                                    if (key.isReadable()) {
                                        endpoint.dispatch();
                                    }
                                }
                            }
                            key = null;
                        }
                        catch (CancelledKeyException e) {
                            Log.ignore(e);
                        }
                        catch (Exception e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn(e);
                            } else {
                                Log.ignore(e);
                            }
                            if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                            key.interestOps(0);
                            key.cancel();
                        }
                    }
                    selector.selectedKeys().clear();
                    this._idleTimeout.tick(now);
                    this._retryTimeout.tick(now);
                    return;
                }
            }
            catch (ClosedSelectorException e) {
                Log.warn(e);
                return;
            }
            catch (CancelledKeyException e) {
                Log.ignore(e);
                return;
            }
lbl-1000:
            // 1 sources

            {
                iter = selector.keys().iterator();
                while (iter.hasNext()) {
                    k = iter.next();
                    if (!k.isValid() || k.interestOps() != 0) continue;
                    k.cancel();
                    ++cancelled;
                }
                if (cancelled > 0) {
                    ++this._jvmFix0;
                }
                this._selecting = false;
                return;
            }
            finally {
                this._selecting = false;
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                selecting = this._selecting;
            }
            ArrayList<SelectionKey> keys = new ArrayList<SelectionKey>(this._selector.keys());
            Iterator<SelectionKey> iter2 = keys.iterator();
            while (iter2.hasNext()) {
                Object att;
                SelectionKey key = iter2.next();
                if (key == null || !((att = key.attachment()) instanceof EndPoint)) continue;
                EndPoint endpoint = (EndPoint)att;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                selecting = this._selecting;
                while (selecting) {
                    this.wakeup();
                    selecting = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
                this._selector = null;
            }
        }
    }
}

