/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.mortbay.util.LazyList;
import org.mortbay.util.SingletonList;
import org.mortbay.util.StringMap;

public class PathMap
extends HashMap
implements Externalizable {
    private static String __pathSpecSeparators = System.getProperty("org.mortbay.http.PathMap.separators", ":,");
    StringMap _prefixMap = new StringMap();
    StringMap _suffixMap = new StringMap();
    StringMap _exactMap = new StringMap();
    List _defaultSingletonList = null;
    Entry _prefixDefault = null;
    Entry _default = null;
    Set _entrySet;
    boolean _nodefault = false;

    public static void setPathSpecSeparators(String s2) {
        __pathSpecSeparators = s2;
    }

    public PathMap() {
        super(11);
        this._entrySet = this.entrySet();
    }

    public PathMap(boolean nodefault) {
        super(11);
        this._entrySet = this.entrySet();
        this._nodefault = nodefault;
    }

    public PathMap(int capacity) {
        super(capacity);
        this._entrySet = this.entrySet();
    }

    public PathMap(Map m3) {
        this.putAll(m3);
        this._entrySet = this.entrySet();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap map2 = new HashMap(this);
        out.writeObject(map2);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap map2 = (HashMap)in.readObject();
        this.putAll(map2);
    }

    public synchronized Object put(Object pathSpec, Object object) {
        StringTokenizer tok = new StringTokenizer(pathSpec.toString(), __pathSpecSeparators);
        Object old = null;
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            if (!spec.startsWith("/") && !spec.startsWith("*.")) {
                throw new IllegalArgumentException("PathSpec " + spec + ". must start with '/' or '*.'");
            }
            old = super.put(spec, object);
            Entry entry2 = new Entry(spec, object);
            if (!entry2.getKey().equals(spec)) continue;
            if (spec.equals("/*")) {
                this._prefixDefault = entry2;
                continue;
            }
            if (spec.endsWith("/*")) {
                String mapped = spec.substring(0, spec.length() - 2);
                entry2.setMapped(mapped);
                this._prefixMap.put(mapped, (Object)entry2);
                this._exactMap.put(mapped, (Object)entry2);
                this._exactMap.put(spec.substring(0, spec.length() - 1), (Object)entry2);
                continue;
            }
            if (spec.startsWith("*.")) {
                this._suffixMap.put(spec.substring(2), (Object)entry2);
                continue;
            }
            if (spec.equals("/")) {
                if (this._nodefault) {
                    this._exactMap.put(spec, (Object)entry2);
                    continue;
                }
                this._default = entry2;
                this._defaultSingletonList = SingletonList.newSingletonList(this._default);
                continue;
            }
            entry2.setMapped(spec);
            this._exactMap.put(spec, (Object)entry2);
        }
        return old;
    }

    public Object match(String path) {
        Entry entry2 = this.getMatch(path);
        if (entry2 != null) {
            return entry2.getValue();
        }
        return null;
    }

    public Entry getMatch(String path) {
        if (path == null) {
            return null;
        }
        int l = path.length();
        Map.Entry entry2 = this._exactMap.getEntry(path, 0, l);
        if (entry2 != null) {
            return (Entry)entry2.getValue();
        }
        int i = l;
        while ((i = path.lastIndexOf(47, i - 1)) >= 0) {
            entry2 = this._prefixMap.getEntry(path, 0, i);
            if (entry2 == null) continue;
            return (Entry)entry2.getValue();
        }
        if (this._prefixDefault != null) {
            return this._prefixDefault;
        }
        i = 0;
        while ((i = path.indexOf(46, i + 1)) > 0) {
            entry2 = this._suffixMap.getEntry(path, i + 1, l - i - 1);
            if (entry2 == null) continue;
            return (Entry)entry2.getValue();
        }
        return this._default;
    }

    public Object getLazyMatches(String path) {
        Object entries = null;
        if (path == null) {
            return LazyList.getList(entries);
        }
        int l = path.length();
        Map.Entry entry2 = this._exactMap.getEntry(path, 0, l);
        if (entry2 != null) {
            entries = LazyList.add(entries, entry2.getValue());
        }
        int i = l - 1;
        while ((i = path.lastIndexOf(47, i - 1)) >= 0) {
            entry2 = this._prefixMap.getEntry(path, 0, i);
            if (entry2 == null) continue;
            entries = LazyList.add(entries, entry2.getValue());
        }
        if (this._prefixDefault != null) {
            entries = LazyList.add(entries, this._prefixDefault);
        }
        i = 0;
        while ((i = path.indexOf(46, i + 1)) > 0) {
            entry2 = this._suffixMap.getEntry(path, i + 1, l - i - 1);
            if (entry2 == null) continue;
            entries = LazyList.add(entries, entry2.getValue());
        }
        if (this._default != null) {
            if (entries == null) {
                return this._defaultSingletonList;
            }
            entries = LazyList.add(entries, this._default);
        }
        return entries;
    }

    public List getMatches(String path) {
        return LazyList.getList(this.getLazyMatches(path));
    }

    public boolean containsMatch(String path) {
        Entry match = this.getMatch(path);
        return match != null && !match.equals(this._default);
    }

    public synchronized Object remove(Object pathSpec) {
        if (pathSpec != null) {
            String spec = (String)pathSpec;
            if (spec.equals("/*")) {
                this._prefixDefault = null;
            } else if (spec.endsWith("/*")) {
                this._prefixMap.remove(spec.substring(0, spec.length() - 2));
                this._exactMap.remove(spec.substring(0, spec.length() - 1));
                this._exactMap.remove(spec.substring(0, spec.length() - 2));
            } else if (spec.startsWith("*.")) {
                this._suffixMap.remove(spec.substring(2));
            } else if (spec.equals("/")) {
                this._default = null;
                this._defaultSingletonList = null;
            } else {
                this._exactMap.remove(spec);
            }
        }
        return super.remove(pathSpec);
    }

    public void clear() {
        this._exactMap = new StringMap();
        this._prefixMap = new StringMap();
        this._suffixMap = new StringMap();
        this._default = null;
        this._defaultSingletonList = null;
        super.clear();
    }

    public static boolean match(String pathSpec, String path) throws IllegalArgumentException {
        return PathMap.match(pathSpec, path, false);
    }

    public static boolean match(String pathSpec, String path, boolean noDefault) throws IllegalArgumentException {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (!noDefault && pathSpec.length() == 1 || pathSpec.equals(path)) {
                return true;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                return true;
            }
        } else if (c == '*') {
            return path.regionMatches(path.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
        }
        return false;
    }

    private static boolean isPathWildcardMatch(String pathSpec, String path) {
        int cpl = pathSpec.length() - 2;
        return pathSpec.endsWith("/*") && path.regionMatches(0, pathSpec, 0, cpl) && (path.length() == cpl || '/' == path.charAt(cpl));
    }

    public static String pathMatch(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return path;
            }
            if (pathSpec.equals(path)) {
                return path;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                return path.substring(0, pathSpec.length() - 2);
            }
        } else if (c == '*' && path.regionMatches(path.length() - (pathSpec.length() - 1), pathSpec, 1, pathSpec.length() - 1)) {
            return path;
        }
        return null;
    }

    public static String pathInfo(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return null;
            }
            boolean wildcard = PathMap.isPathWildcardMatch(pathSpec, path);
            if (pathSpec.equals(path) && !wildcard) {
                return null;
            }
            if (wildcard) {
                if (path.length() == pathSpec.length() - 2) {
                    return null;
                }
                return path.substring(pathSpec.length() - 2);
            }
        }
        return null;
    }

    public static String relativePath(String base, String pathSpec, String path) {
        String info = PathMap.pathInfo(pathSpec, path);
        if (info == null) {
            info = path;
        }
        if (info.startsWith("./")) {
            info = info.substring(2);
        }
        path = base.endsWith("/") ? (info.startsWith("/") ? base + info.substring(1) : base + info) : (info.startsWith("/") ? base + info : base + "/" + info);
        return path;
    }

    public static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;
        private String mapped;
        private transient String string;

        Entry(Object key, Object value2) {
            this.key = key;
            this.value = value2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            if (this.string == null) {
                this.string = this.key + "=" + this.value;
            }
            return this.string;
        }

        public String getMapped() {
            return this.mapped;
        }

        void setMapped(String mapped) {
            this.mapped = mapped;
        }
    }
}

