/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.log.Log;
import org.mortbay.util.ajax.Continuation;

public class ThrottlingFilter
implements Filter {
    private int _maximum;
    private int _current = 0;
    private long _queueTimeout;
    private long _queueSize;
    private final Object _lock = new Object();
    private final List _queue = new LinkedList();

    public void init(FilterConfig filterConfig) throws ServletException {
        this._maximum = this.getIntegerParameter(filterConfig, "maximum", 10);
        this._queueTimeout = this.getIntegerParameter(filterConfig, "block", 5000);
        this._queueSize = this.getIntegerParameter(filterConfig, "queue", 500);
        if (this._queueTimeout == -1L) {
            this._queueTimeout = Integer.MAX_VALUE;
        }
        Log.debug("Config{maximum:" + this._maximum + ", block:" + this._queueTimeout + ", queue:" + this._queueSize + "}", null, null);
    }

    private int getIntegerParameter(FilterConfig filterConfig, String name, int defaultValue) throws ServletException {
        String value2 = filterConfig.getInitParameter(name);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new ServletException("Parameter " + name + " must be a number (was " + value2 + " instead)");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain2) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain2) throws IOException, ServletException {
        Continuation continuation = this.getContinuation(request);
        boolean accepted = false;
        try {
            accepted = this.acceptRequest();
            if (!accepted) {
                if (continuation.isPending()) {
                    Log.debug("Request {} / {} was already queued, rejecting", request.getRequestURI(), continuation);
                    this.dropFromQueue(continuation);
                    continuation.reset();
                } else if (this.queueRequest(request, response, continuation)) {
                    accepted = this.acceptRequest();
                }
            }
            if (accepted) {
                chain2.doFilter(request, response);
            } else {
                this.rejectRequest(request, response);
            }
            Object var7_6 = null;
            if (accepted) {
                this.releaseRequest();
                this.popQueue();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (accepted) {
                this.releaseRequest();
                this.popQueue();
            }
            throw throwable;
        }
    }

    private void dropFromQueue(Continuation continuation) {
        this._queue.remove(continuation);
        continuation.reset();
    }

    protected void rejectRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(503, "Too many active connections to resource " + request.getRequestURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popQueue() {
        Continuation continuation;
        List list = this._queue;
        synchronized (list) {
            if (this._queue.isEmpty()) {
                return;
            }
            continuation = (Continuation)this._queue.remove(0);
        }
        Log.debug("Resuming continuation {}", continuation, null);
        continuation.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRequest() {
        Object object = this._lock;
        synchronized (object) {
            --this._current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acceptRequest() {
        Object object = this._lock;
        synchronized (object) {
            if (this._current < this._maximum) {
                ++this._current;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueRequest(HttpServletRequest request, HttpServletResponse response, Continuation continuation) throws IOException, ServletException {
        List list = this._queue;
        synchronized (list) {
            if ((long)this._queue.size() >= this._queueSize) {
                Log.debug("Queue is full, rejecting request {}", request.getRequestURI(), null);
                return false;
            }
            Log.debug("Queuing request {} / {}", request.getRequestURI(), continuation);
            this._queue.add(continuation);
        }
        continuation.suspend(this._queueTimeout);
        Log.debug("Resuming blocking continuation for request {}", request.getRequestURI(), null);
        return true;
    }

    private Continuation getContinuation(ServletRequest request) {
        return (Continuation)request.getAttribute("org.mortbay.jetty.ajax.Continuation");
    }

    public void destroy() {
        this._queue.clear();
    }
}

