/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.Utf8StringBuffer;

public class StringUtil {
    public static final String CRLF = "\r\n";
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String __ISO_8859_1;
    public static final String __UTF8 = "UTF-8";
    public static final String __UTF8Alt = "UTF8";
    public static final String __UTF16 = "UTF-16";
    private static char[] lowercases;

    public static String asciiToLowerCase(String s2) {
        char[] c = null;
        int i = s2.length();
        while (i-- > 0) {
            char c2;
            char c1 = s2.charAt(i);
            if (c1 > '\u007f' || c1 == (c2 = lowercases[c1])) continue;
            c = s2.toCharArray();
            c[i] = c2;
            break;
        }
        while (i-- > 0) {
            if (c[i] > 127) continue;
            c[i] = lowercases[c[i]];
        }
        return c == null ? s2 : new String(c);
    }

    public static boolean startsWithIgnoreCase(String s2, String w) {
        if (w == null) {
            return true;
        }
        if (s2 == null || s2.length() < w.length()) {
            return false;
        }
        for (int i = 0; i < w.length(); ++i) {
            char c2;
            char c1 = s2.charAt(i);
            if (c1 == (c2 = w.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s2, String w) {
        int wl;
        if (w == null) {
            return true;
        }
        if (s2 == null) {
            return false;
        }
        int sl = s2.length();
        if (sl < (wl = w.length())) {
            return false;
        }
        int i = wl;
        while (i-- > 0) {
            char c2;
            char c1;
            if ((c1 = s2.charAt(--sl)) == (c2 = w.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s2, String chars) {
        for (int i = 0; i < s2.length(); ++i) {
            if (chars.indexOf(s2.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(String s2, String sub, String with) {
        StringBuffer buf;
        int c = 0;
        int i = s2.indexOf(sub, c);
        if (i == -1) {
            return s2;
        }
        StringBuffer stringBuffer = buf = new StringBuffer(s2.length() + with.length());
        synchronized (stringBuffer) {
            do {
                buf.append(s2.substring(c, i));
                buf.append(with);
            } while ((i = s2.indexOf(sub, c = i + sub.length())) != -1);
            if (c < s2.length()) {
                buf.append(s2.substring(c, s2.length()));
            }
            return buf.toString();
        }
    }

    public static String unquote(String s2) {
        return QuotedStringTokenizer.unquote(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuffer buf, String s2, int offset2, int length) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            int end = offset2 + length;
            for (int i = offset2; i < end && i < s2.length(); ++i) {
                buf.append(s2.charAt(i));
            }
        }
    }

    public static void append(StringBuffer buf, byte b, int base) {
        int bi = 0xFF & b;
        int c = 48 + bi / base % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
        c = 48 + bi % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
    }

    public static void append2digits(StringBuffer buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    public static String nonNull(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    public static boolean equals(String s2, char[] buf, int offset2, int length) {
        if (s2.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (buf[offset2 + i] == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] b, int offset2, int length) {
        try {
            if (length < 32) {
                Utf8StringBuffer buffer = new Utf8StringBuffer(length);
                buffer.append(b, offset2, length);
                return buffer.toString();
            }
            return new String(b, offset2, length, __UTF8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toString(byte[] b, int offset2, int length, String charset) {
        if (charset == null || StringUtil.isUTF8(charset)) {
            return StringUtil.toUTF8String(b, offset2, length);
        }
        try {
            return new String(b, offset2, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isUTF8(String charset) {
        return charset == __UTF8 || __UTF8.equalsIgnoreCase(charset) || __UTF8Alt.equalsIgnoreCase(charset);
    }

    public static String printable(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isISOControl(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    static {
        String iso = System.getProperty("ISO_8859_1");
        if (iso == null) {
            try {
                new String(new byte[]{20}, "ISO-8859-1");
                iso = "ISO-8859-1";
            }
            catch (UnsupportedEncodingException e) {
                iso = "ISO8859_1";
            }
        }
        __ISO_8859_1 = iso;
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }
}

