/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin;

import com.ibm.gaiandb.Logger;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.GaianAuthorizationException;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.GaianAuthorizer;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.GaianResourceType;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.QueryContext;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerGaianAccessRequest;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerGaianPlugin;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerGaianResource;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerServerProperties;

public class RangerGaianAuthorizer
implements GaianAuthorizer {
    private static final Logger logger = new Logger("RangerGaianAuthorizer", 25);
    private static volatile RangerBasePlugin gaianPlugin;
    private RangerServerProperties rangerServerProperties = this.loadRangerServerProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void init() {
        logger.logDetail("==> RangerGaianPlugin.init()");
        RangerBasePlugin plugin = gaianPlugin;
        if (plugin == null) {
            Class<RangerGaianPlugin> clazz = RangerGaianPlugin.class;
            // MONITORENTER : org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerGaianPlugin.class
            plugin = gaianPlugin;
            if (plugin == null) {
                plugin = new RangerGaianPlugin();
                plugin.init();
                plugin.setResultProcessor(new RangerDefaultAuditHandler());
                gaianPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        logger.logDetail("<== RangerGaianPlugin.init()");
    }

    @Override
    public boolean isAuthorized(QueryContext queryContext) throws GaianAuthorizationException {
        GaianResourceType resourceType = this.getGaianResourceType(queryContext.getResourceType());
        String accessType = queryContext.getActionType();
        logger.logDetail("Is Auth: access type is : " + accessType + " resource type is: " + (Object)((Object)resourceType) + " [" + queryContext + "]");
        if (!accessType.equals("SELECT")) {
            throw new GaianAuthorizationException("GaianAccessType is invalid!");
        }
        if (resourceType == GaianResourceType.COLUMN) {
            return this.isColumnAccessAllowed(queryContext, resourceType, accessType);
        }
        if (resourceType == GaianResourceType.TABLE) {
            return this.isTableAccessAllowed(queryContext, resourceType, accessType);
        }
        if (resourceType == GaianResourceType.SCHEMA) {
            return this.isSchemaAccessAllowed(queryContext, resourceType, accessType);
        }
        throw new GaianAuthorizationException("GaianResourceType is invalid!");
    }

    @Override
    public void applyRowFilterAndColumnMasking(QueryContext queryContext) {
        logger.logDetail("==> applyRowFilterAndColumnMasking(" + queryContext + ")");
        boolean needToTransform = false;
        if (CollectionUtils.isNotEmpty(queryContext.getColumns())) {
            for (String column : queryContext.getColumns()) {
                boolean isColumnTransformed = this.addCellValueTransformerAndCheckIfTransformed(queryContext, column);
                logger.logDetail("addCellValueTransformerAndCheckIfTransformed(queryContext=" + queryContext + "): " + isColumnTransformed);
                needToTransform = needToTransform || isColumnTransformed;
            }
        }
    }

    @Override
    public void cleanUp() {
        logger.logDetail("==> cleanUp ");
    }

    public RangerServerProperties getRangerServerProperties() {
        return this.rangerServerProperties;
    }

    private RangerServerProperties loadRangerServerProperties() {
        RangerServerProperties serverProperties = new RangerServerProperties();
        if (RangerConfiguration.getInstance() != null) {
            String rangerAuthorization;
            String rangerURL = RangerConfiguration.getInstance().get("ranger.plugin.gaian.policy.rest.url");
            if (rangerURL != null) {
                serverProperties.setServerURL(rangerURL);
            }
            if ((rangerAuthorization = RangerConfiguration.getInstance().get("ranger.plugin.gaian.policy.rest.authorization")) != null) {
                serverProperties.setServerAuthorization(rangerAuthorization);
            }
        }
        return serverProperties;
    }

    private GaianResourceType getGaianResourceType(String resourceType) {
        switch (resourceType) {
            case "SCHEMA": {
                return GaianResourceType.SCHEMA;
            }
            case "TABLE": {
                return GaianResourceType.TABLE;
            }
            case "COLUMN": {
                return GaianResourceType.COLUMN;
            }
        }
        return GaianResourceType.NONE;
    }

    private boolean isColumnAccessAllowed(QueryContext queryContext, GaianResourceType resourceType, String accessType) {
        for (String col : queryContext.getColumns()) {
            RangerGaianResource resource = new RangerGaianResource(resourceType, queryContext.getSchema(), queryContext.getTableName(), col);
            boolean accessAllowed = this.isAccessAllowed(queryContext, accessType, resource);
            if (accessAllowed) continue;
            return false;
        }
        return true;
    }

    private boolean isTableAccessAllowed(QueryContext queryContext, GaianResourceType resourceType, String accessType) {
        RangerGaianResource resource = new RangerGaianResource(resourceType, queryContext.getSchema(), queryContext.getTableName());
        return this.isAccessAllowed(queryContext, accessType, resource);
    }

    private boolean isSchemaAccessAllowed(QueryContext queryContext, GaianResourceType resourceType, String accessType) {
        RangerGaianResource resource = new RangerGaianResource(resourceType, queryContext.getSchema());
        return this.isAccessAllowed(queryContext, accessType, resource);
    }

    private boolean isAccessAllowed(QueryContext queryContext, String accessType, RangerGaianResource resource) {
        RangerGaianAccessRequest request = new RangerGaianAccessRequest(resource, accessType, queryContext.getUser(), queryContext.getUserGroups());
        RangerAccessResult result2 = gaianPlugin.isAccessAllowed(request);
        logger.logDetail("RangerAccessResult result: " + result2);
        return result2 != null && result2.getIsAllowed();
    }

    private boolean addCellValueTransformerAndCheckIfTransformed(QueryContext queryContext, String columnName) {
        logger.logDetail("==> addCellValueTransformerAndCheckIfTransformed(queryContext=" + queryContext + ", " + columnName + ")");
        String columnTransformer = columnName;
        List<String> columnTransformers = queryContext.getColumnTransformers();
        RangerAccessResult result2 = this.getRangerDataMaskResult(queryContext, columnName);
        boolean isDataMaskEnabled = this.isDataMaskEnabled(result2);
        if (isDataMaskEnabled) {
            String transformer = this.getTransformer(result2);
            String maskType = result2.getMaskType();
            if (StringUtils.equalsIgnoreCase(maskType, "MASK_NULL")) {
                columnTransformer = "NULL";
            } else if (StringUtils.equalsIgnoreCase(maskType, "CUSTOM")) {
                columnTransformer = this.getCustomMaskType(columnName, result2);
            } else if (StringUtils.isNotEmpty(transformer)) {
                columnTransformer = transformer.replace("{col}", columnName);
            }
        }
        columnTransformers.add(columnTransformer);
        logger.logDetail("<== addCellValueTransformerAndCheckIfTransformed(queryContext=" + queryContext + ", " + columnName + "): " + isDataMaskEnabled);
        return isDataMaskEnabled;
    }

    private String getCustomMaskType(String columnName, RangerAccessResult result2) {
        String maskedValue = result2.getMaskedValue();
        if (maskedValue == null) {
            return "NULL";
        }
        return maskedValue.replace("{col}", columnName);
    }

    private String getTransformer(RangerAccessResult result2) {
        RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result2.getMaskTypeDef();
        if (maskTypeDef != null) {
            return maskTypeDef.getTransformer();
        }
        return null;
    }

    private RangerAccessResult getRangerDataMaskResult(QueryContext queryContext, String columnName) {
        GaianResourceType objectType = GaianResourceType.COLUMN;
        RangerGaianResource resource = new RangerGaianResource(objectType, queryContext.getSchema(), queryContext.getTableName(), columnName);
        String user = queryContext.getUser();
        Set<String> groups = queryContext.getUserGroups();
        RangerGaianAccessRequest request = new RangerGaianAccessRequest(resource, queryContext.getActionType(), user, groups);
        return gaianPlugin.evalDataMaskPolicies(request, new RangerDefaultAuditHandler());
    }

    private boolean isDataMaskEnabled(RangerAccessResult result2) {
        return result2 != null && result2.isMaskEnabled() && !StringUtils.equalsIgnoreCase(result2.getMaskType(), "MASK_NONE");
    }
}

