/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface AttributeAccessor {
    public void setAttribute(String var1, @Nullable Object var2);

    @Nullable
    public Object getAttribute(String var1);

    default public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(computeFunction, "Compute function must not be null");
        Object value2 = this.getAttribute(name);
        if (value2 == null) {
            value2 = computeFunction.apply(name);
            Assert.state(value2 != null, () -> String.format("Compute function must not return null for attribute named '%s'", name));
            this.setAttribute(name, value2);
        }
        return (T)value2;
    }

    @Nullable
    public Object removeAttribute(String var1);

    public boolean hasAttribute(String var1);

    public String[] attributeNames();
}

