/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[[empty]]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String EMPTY_MAP = "map[[empty]]";
    private static final String ARRAY = "array";

    @Override
    public String style(@Nullable Object value2) {
        if (value2 == null) {
            return NULL;
        }
        if (value2 instanceof String) {
            return "'" + value2 + "'";
        }
        if (value2 instanceof Class) {
            return ClassUtils.getShortName((Class)value2);
        }
        if (value2 instanceof Method) {
            Method method = (Method)value2;
            return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
        }
        if (value2 instanceof Map) {
            return this.style((Map)value2);
        }
        if (value2 instanceof Map.Entry) {
            return this.style((Map.Entry)value2);
        }
        if (value2 instanceof Collection) {
            return this.style((Collection)value2);
        }
        if (value2.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray(value2));
        }
        return String.valueOf(value2);
    }

    private <K, V> String style(Map<K, V> value2) {
        if (value2.isEmpty()) {
            return EMPTY_MAP;
        }
        StringJoiner result2 = new StringJoiner(", ", "[", "]");
        for (Map.Entry<K, V> entry2 : value2.entrySet()) {
            result2.add(this.style(entry2));
        }
        return MAP + result2;
    }

    private String style(Map.Entry<?, ?> value2) {
        return this.style(value2.getKey()) + " -> " + this.style(value2.getValue());
    }

    private String style(Collection<?> value2) {
        String collectionType = this.getCollectionTypeString(value2);
        if (value2.isEmpty()) {
            return collectionType + EMPTY;
        }
        StringJoiner result2 = new StringJoiner(", ", "[", "]");
        for (Object o : value2) {
            result2.add(this.style(o));
        }
        return collectionType + result2;
    }

    private String getCollectionTypeString(Collection<?> value2) {
        if (value2 instanceof List) {
            return LIST;
        }
        if (value2 instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    private String styleArray(Object[] array) {
        if (array.length == 0) {
            return "array<" + ClassUtils.getShortName(array.getClass().getComponentType()) + '>' + EMPTY;
        }
        StringJoiner result2 = new StringJoiner(", ", "[", "]");
        for (Object o : array) {
            result2.add(this.style(o));
        }
        return "array<" + ClassUtils.getShortName(array.getClass().getComponentType()) + '>' + result2;
    }
}

