/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpFields;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class JettyHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpFields headers;

    JettyHeadersAdapter(HttpFields headers) {
        this.headers = headers;
    }

    @Override
    public String getFirst(String key) {
        return this.headers.get(key);
    }

    @Override
    public void add(String key, @Nullable String value2) {
        this.headers.add(key, value2);
    }

    @Override
    public void addAll(String key, List<? extends String> values) {
        values.forEach((? super T value2) -> this.add(key, (String)value2));
    }

    @Override
    public void addAll(MultiValueMap<String, String> values) {
        values.forEach(this::addAll);
    }

    @Override
    public void set(String key, @Nullable String value2) {
        this.headers.put(key, value2);
    }

    @Override
    public void setAll(Map<String, String> values) {
        values.forEach(this::set);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = CollectionUtils.newLinkedHashMap(this.headers.size());
        Iterator iterator2 = this.headers.iterator();
        iterator2.forEachRemaining(field2 -> {
            if (!singleValueMap.containsKey(field2.getName())) {
                singleValueMap.put(field2.getName(), field2.getValue());
            }
        });
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.getFieldNamesCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.headers.containsKey((String)key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return value2 instanceof String && this.headers.stream().anyMatch(field2 -> field2.contains((String)value2));
    }

    @Override
    @Nullable
    public List<String> get(Object key) {
        if (this.containsKey(key)) {
            return this.headers.getValuesList((String)key);
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> put(String key, List<String> value2) {
        Object oldValues = this.get(key);
        this.headers.put(key, value2);
        return oldValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key) {
        if (key instanceof String) {
            Object oldValues = this.get(key);
            this.headers.remove((String)key);
            return oldValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map2) {
        map2.forEach(this::put);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.getFieldNamesCollection().stream().map(arg_0 -> ((HttpFields)this.headers).getValuesList(arg_0)).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return JettyHeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Iterator<String> iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!JettyHeadersAdapter.this.headers.containsKey(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            JettyHeadersAdapter.this.headers.remove(this.currentName);
        }
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(JettyHeadersAdapter.this.headers.getFieldNamesCollection().iterator());
        }

        @Override
        public int size() {
            return JettyHeadersAdapter.this.headers.getFieldNamesCollection().size();
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            return JettyHeadersAdapter.this.headers.getValuesList(this.key);
        }

        @Override
        public List<String> setValue(List<String> value2) {
            List previousValues = JettyHeadersAdapter.this.headers.getValuesList(this.key);
            JettyHeadersAdapter.this.headers.put(this.key, value2);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private Enumeration<String> names;

        private EntryIterator() {
            this.names = JettyHeadersAdapter.this.headers.getFieldNames();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasMoreElements();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.nextElement());
        }
    }
}

