/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.ArrayList;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.util.HtmlUtils;

public class EscapedErrors
implements Errors {
    private final Errors source;

    public EscapedErrors(Errors source) {
        Assert.notNull((Object)source, "Errors source must not be null");
        this.source = source;
    }

    public Errors getSource() {
        return this.source;
    }

    public String getObjectName() {
        return this.source.getObjectName();
    }

    public void setNestedPath(String nestedPath) {
        this.source.setNestedPath(nestedPath);
    }

    public String getNestedPath() {
        return this.source.getNestedPath();
    }

    public void pushNestedPath(String subPath) {
        this.source.pushNestedPath(subPath);
    }

    public void popNestedPath() throws IllegalStateException {
        this.source.popNestedPath();
    }

    public void reject(String errorCode) {
        this.source.reject(errorCode);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.source.reject(errorCode, defaultMessage);
    }

    public void reject(String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.source.reject(errorCode, errorArgs, defaultMessage);
    }

    public void rejectValue(@Nullable String field2, String errorCode) {
        this.source.rejectValue(field2, errorCode);
    }

    public void rejectValue(@Nullable String field2, String errorCode, String defaultMessage) {
        this.source.rejectValue(field2, errorCode, defaultMessage);
    }

    public void rejectValue(@Nullable String field2, String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.source.rejectValue(field2, errorCode, errorArgs, defaultMessage);
    }

    public void addAllErrors(Errors errors) {
        this.source.addAllErrors(errors);
    }

    public boolean hasErrors() {
        return this.source.hasErrors();
    }

    public int getErrorCount() {
        return this.source.getErrorCount();
    }

    public List<ObjectError> getAllErrors() {
        return this.escapeObjectErrors(this.source.getAllErrors());
    }

    public boolean hasGlobalErrors() {
        return this.source.hasGlobalErrors();
    }

    public int getGlobalErrorCount() {
        return this.source.getGlobalErrorCount();
    }

    public List<ObjectError> getGlobalErrors() {
        return this.escapeObjectErrors(this.source.getGlobalErrors());
    }

    @Nullable
    public ObjectError getGlobalError() {
        return this.escapeObjectError(this.source.getGlobalError());
    }

    public boolean hasFieldErrors() {
        return this.source.hasFieldErrors();
    }

    public int getFieldErrorCount() {
        return this.source.getFieldErrorCount();
    }

    public List<FieldError> getFieldErrors() {
        return this.source.getFieldErrors();
    }

    @Nullable
    public FieldError getFieldError() {
        return this.source.getFieldError();
    }

    public boolean hasFieldErrors(String field2) {
        return this.source.hasFieldErrors(field2);
    }

    public int getFieldErrorCount(String field2) {
        return this.source.getFieldErrorCount(field2);
    }

    public List<FieldError> getFieldErrors(String field2) {
        return this.escapeObjectErrors(this.source.getFieldErrors(field2));
    }

    @Nullable
    public FieldError getFieldError(String field2) {
        return this.escapeObjectError(this.source.getFieldError(field2));
    }

    @Nullable
    public Object getFieldValue(String field2) {
        Object value2 = this.source.getFieldValue(field2);
        return value2 instanceof String ? HtmlUtils.htmlEscape((String)value2) : value2;
    }

    @Nullable
    public Class<?> getFieldType(String field2) {
        return this.source.getFieldType(field2);
    }

    @Nullable
    private <T extends ObjectError> T escapeObjectError(@Nullable T source) {
        if (source == null) {
            return null;
        }
        String defaultMessage = source.getDefaultMessage();
        if (defaultMessage != null) {
            defaultMessage = HtmlUtils.htmlEscape(defaultMessage);
        }
        if (source instanceof FieldError) {
            FieldError fieldError = (FieldError)source;
            Object value2 = fieldError.getRejectedValue();
            if (value2 instanceof String) {
                value2 = HtmlUtils.htmlEscape((String)value2);
            }
            return (T)new FieldError(fieldError.getObjectName(), fieldError.getField(), value2, fieldError.isBindingFailure(), fieldError.getCodes(), fieldError.getArguments(), defaultMessage);
        }
        return (T)new ObjectError(source.getObjectName(), source.getCodes(), source.getArguments(), defaultMessage);
    }

    private <T extends ObjectError> List<T> escapeObjectErrors(List<T> source) {
        ArrayList<ObjectError> escaped = new ArrayList<ObjectError>(source.size());
        for (ObjectError objectError : source) {
            escaped.add(this.escapeObjectError(objectError));
        }
        return escaped;
    }
}

