/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.core.CollectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    public static final String DEFAULT_FIELD_DEFAULT_PREFIX = "!";
    @Nullable
    private String fieldMarkerPrefix = "_";
    @Nullable
    private String fieldDefaultPrefix = "!";
    private boolean bindEmptyMultipartFiles = true;

    public WebDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void setFieldMarkerPrefix(@Nullable String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    @Nullable
    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setFieldDefaultPrefix(@Nullable String fieldDefaultPrefix) {
        this.fieldDefaultPrefix = fieldDefaultPrefix;
    }

    @Nullable
    public String getFieldDefaultPrefix() {
        return this.fieldDefaultPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkFieldDefaults(mpvs);
        this.checkFieldMarkers(mpvs);
        this.adaptEmptyArrayIndices(mpvs);
        super.doBind(mpvs);
    }

    protected void checkFieldDefaults(MutablePropertyValues mpvs) {
        String fieldDefaultPrefix = this.getFieldDefaultPrefix();
        if (fieldDefaultPrefix != null) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
                if (!pv.getName().startsWith(fieldDefaultPrefix)) continue;
                String field2 = pv.getName().substring(fieldDefaultPrefix.length());
                if (this.getPropertyAccessor().isWritableProperty(field2) && !mpvs.contains(field2)) {
                    mpvs.add(field2, pv.getValue());
                }
                mpvs.removePropertyValue(pv);
            }
        }
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        String fieldMarkerPrefix = this.getFieldMarkerPrefix();
        if (fieldMarkerPrefix != null) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
                if (!pv.getName().startsWith(fieldMarkerPrefix)) continue;
                String field2 = pv.getName().substring(fieldMarkerPrefix.length());
                if (this.getPropertyAccessor().isWritableProperty(field2) && !mpvs.contains(field2)) {
                    Class<?> fieldType = this.getPropertyAccessor().getPropertyType(field2);
                    mpvs.add(field2, this.getEmptyValue(field2, fieldType));
                }
                mpvs.removePropertyValue(pv);
            }
        }
    }

    protected void adaptEmptyArrayIndices(MutablePropertyValues mpvs) {
        for (PropertyValue pv : mpvs.getPropertyValues()) {
            String name = pv.getName();
            if (!name.endsWith("[]")) continue;
            String field2 = name.substring(0, name.length() - 2);
            if (this.getPropertyAccessor().isWritableProperty(field2) && !mpvs.contains(field2)) {
                mpvs.add(field2, pv.getValue());
            }
            mpvs.removePropertyValue(pv);
        }
    }

    @Nullable
    protected Object getEmptyValue(String field2, @Nullable Class<?> fieldType) {
        return fieldType != null ? this.getEmptyValue(fieldType) : null;
    }

    @Nullable
    public Object getEmptyValue(Class<?> fieldType) {
        block6: {
            try {
                if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                    return Boolean.FALSE;
                }
                if (fieldType.isArray()) {
                    return Array.newInstance(fieldType.getComponentType(), 0);
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    return CollectionFactory.createCollection(fieldType, 0);
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    return CollectionFactory.createMap(fieldType, 0);
                }
            }
            catch (IllegalArgumentException ex) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Failed to create default value - falling back to null: " + ex.getMessage());
            }
        }
        return null;
    }

    protected void bindMultipart(Map<String, List<MultipartFile>> multipartFiles, MutablePropertyValues mpvs) {
        multipartFiles.forEach((key, values) -> {
            if (values.size() == 1) {
                MultipartFile value2 = (MultipartFile)values.get(0);
                if (this.isBindEmptyMultipartFiles() || !value2.isEmpty()) {
                    mpvs.add((String)key, value2);
                }
            } else {
                mpvs.add((String)key, values);
            }
        });
    }
}

