/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.StandardServletPartUtils;

public class WebRequestDataBinder
extends WebDataBinder {
    public WebRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(WebRequest request) {
        MutablePropertyValues mpvs = new MutablePropertyValues(request.getParameterMap());
        if (request instanceof NativeWebRequest) {
            HttpServletRequest servletRequest;
            MultipartRequest multipartRequest = ((NativeWebRequest)request).getNativeRequest(MultipartRequest.class);
            if (multipartRequest != null) {
                this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
            } else if (StringUtils.startsWithIgnoreCase(request.getHeader("Content-Type"), "multipart/") && (servletRequest = ((NativeWebRequest)request).getNativeRequest(HttpServletRequest.class)) != null) {
                StandardServletPartUtils.bindParts(servletRequest, mpvs, this.isBindEmptyMultipartFiles());
            }
        }
        this.doBind(mpvs);
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }
}

