/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class ExceptionHandlerMethodResolver {
    public static final ReflectionUtils.MethodFilter EXCEPTION_HANDLER_METHODS = method -> AnnotatedElementUtils.hasAnnotation(method, ExceptionHandler.class);
    private static final Method NO_MATCHING_EXCEPTION_HANDLER_METHOD;
    private final Map<Class<? extends Throwable>, Method> mappedMethods = new HashMap<Class<? extends Throwable>, Method>(16);
    private final Map<Class<? extends Throwable>, Method> exceptionLookupCache = new ConcurrentReferenceHashMap<Class<? extends Throwable>, Method>(16);

    public ExceptionHandlerMethodResolver(Class<?> handlerType) {
        for (Method method : MethodIntrospector.selectMethods(handlerType, EXCEPTION_HANDLER_METHODS)) {
            for (Class<? extends Throwable> exceptionType : this.detectExceptionMappings(method)) {
                this.addExceptionMapping(exceptionType, method);
            }
        }
    }

    private List<Class<? extends Throwable>> detectExceptionMappings(Method method) {
        ArrayList<Class<? extends Throwable>> result2 = new ArrayList<Class<? extends Throwable>>();
        this.detectAnnotationExceptionMappings(method, result2);
        if (result2.isEmpty()) {
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!Throwable.class.isAssignableFrom(paramType)) continue;
                result2.add(paramType);
            }
        }
        if (result2.isEmpty()) {
            throw new IllegalStateException("No exception types mapped to " + method);
        }
        return result2;
    }

    private void detectAnnotationExceptionMappings(Method method, List<Class<? extends Throwable>> result2) {
        ExceptionHandler ann = AnnotatedElementUtils.findMergedAnnotation(method, ExceptionHandler.class);
        Assert.state(ann != null, "No ExceptionHandler annotation");
        result2.addAll(Arrays.asList(ann.value()));
    }

    private void addExceptionMapping(Class<? extends Throwable> exceptionType, Method method) {
        Method oldMethod = this.mappedMethods.put(exceptionType, method);
        if (oldMethod != null && !oldMethod.equals(method)) {
            throw new IllegalStateException("Ambiguous @ExceptionHandler method mapped for [" + exceptionType + "]: {" + oldMethod + ", " + method + "}");
        }
    }

    public boolean hasExceptionMappings() {
        return !this.mappedMethods.isEmpty();
    }

    @Nullable
    public Method resolveMethod(Exception exception) {
        return this.resolveMethodByThrowable(exception);
    }

    @Nullable
    public Method resolveMethodByThrowable(Throwable exception) {
        Throwable cause;
        Method method = this.resolveMethodByExceptionType(exception.getClass());
        if (method == null && (cause = exception.getCause()) != null) {
            method = this.resolveMethodByThrowable(cause);
        }
        return method;
    }

    @Nullable
    public Method resolveMethodByExceptionType(Class<? extends Throwable> exceptionType) {
        Method method = this.exceptionLookupCache.get(exceptionType);
        if (method == null) {
            method = this.getMappedMethod(exceptionType);
            this.exceptionLookupCache.put(exceptionType, method);
        }
        return method != NO_MATCHING_EXCEPTION_HANDLER_METHOD ? method : null;
    }

    private Method getMappedMethod(Class<? extends Throwable> exceptionType) {
        ArrayList<Class<? extends Throwable>> matches2 = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> mappedException : this.mappedMethods.keySet()) {
            if (!mappedException.isAssignableFrom(exceptionType)) continue;
            matches2.add(mappedException);
        }
        if (!matches2.isEmpty()) {
            if (matches2.size() > 1) {
                matches2.sort(new ExceptionDepthComparator(exceptionType));
            }
            return this.mappedMethods.get(matches2.get(0));
        }
        return NO_MATCHING_EXCEPTION_HANDLER_METHOD;
    }

    private void noMatchingExceptionHandler() {
    }

    static {
        try {
            NO_MATCHING_EXCEPTION_HANDLER_METHOD = ExceptionHandlerMethodResolver.class.getDeclaredMethod("noMatchingExceptionHandler", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Expected method not found: " + ex);
        }
    }
}

