/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy.pure;

import java.lang.reflect.Field;
import java.nio.Buffer;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import sun.misc.Unsafe;

final class UnsafeUtil {
    public static final Unsafe UNSAFE;
    private static final Field ADDRESS_ACCESSOR;

    private UnsafeUtil() {
    }

    public static long getAddress(Buffer buffer) {
        try {
            return (Long)ADDRESS_ACCESSOR.get(buffer);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    static {
        Field field2;
        try {
            field2 = Unsafe.class.getDeclaredField("theUnsafe");
            field2.setAccessible(true);
            UNSAFE = (Unsafe)field2.get(null);
        }
        catch (Exception exception) {
            throw new SnappyError(SnappyErrorCode.UNSUPPORTED_PLATFORM, "pure-java snappy requires access to sun.misc.Unsafe");
        }
        try {
            field2 = Buffer.class.getDeclaredField("address");
            field2.setAccessible(true);
            ADDRESS_ACCESSOR = field2;
        }
        catch (Exception exception) {
            throw new SnappyError(SnappyErrorCode.UNSUPPORTED_PLATFORM, "pure-java snappy requires access to java.nio.Buffer raw address field");
        }
    }
}

