/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ActorProfileHandler<B>
extends ReferenceableHandler<B> {
    public ActorProfileHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createActorProfile(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "ActorProfile";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ActorProfile", this.serviceName, methodName, this.repositoryHelper);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public String createActorProfileFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String name, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateActorProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, profileGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "ActorProfile", this.serviceName, methodName, this.repositoryHelper);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, typeGUID, typeName, builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void linkPeerPersonProfiles(String userId, String externalSourceGUID, String externalSourceName, String profile1GUID, String profile1GUIDParameterName, String profile2GUID, String profile2GUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, profile1GUID, profile1GUIDParameterName, "Person", profile2GUID, profile2GUIDParameterName, "Person", this.supportedZones, "4a316abe-bccd-4d11-ad5a-4bfb4079b80b", "Peer", null, methodName);
    }

    public void unlinkPeerPersonProfiles(String userId, String externalSourceGUID, String externalSourceName, String profile1GUID, String profile1GUIDParameterName, String profile2GUID, String profile2GUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, profile1GUID, profile1GUIDParameterName, "Person", profile2GUID, profile2GUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", (List<String>)this.supportedZones, "4a316abe-bccd-4d11-ad5a-4bfb4079b80b", "Peer", methodName);
    }

    public void linkTeamHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamGUID, String superTeamGUIDParameterName, String subTeamGUID, String subTeamGUIDParameterName, boolean delegationEscalationAuthority, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ActorProfileBuilder builder = new ActorProfileBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, superTeamGUID, superTeamGUIDParameterName, "Team", subTeamGUID, subTeamGUIDParameterName, "Team", this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2229ca", "TeamStructure", builder.getTeamStructureProperties(delegationEscalationAuthority, methodName), methodName);
    }

    public void unlinkTeamHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamGUID, String superTeamGUIDParameterName, String subTeamGUID, String subTeamGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, superTeamGUID, superTeamGUIDParameterName, "Team", subTeamGUID, subTeamGUIDParameterName, "36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", (List<String>)this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2229ca", "TeamStructure", methodName);
    }

    public void removeActorProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", null, null, methodName);
    }

    public List<B> findActorProfiles(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", null, startFrom, pageSize, methodName);
    }

    public List<B> getActorProfileByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public B getActorProfileByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "ActorProfile", methodName);
    }

    public B getActorProfileForUser(String userId, String profileUserId, String profileUserIdParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String userGUIDParameterName = "userIdentity.getGUID";
        EntityDetail userIdentity = this.getEntityByUniqueQualifiedName(userId, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", profileUserId, profileUserIdParameterName, methodName);
        if (userIdentity != null) {
            return this.getAttachedElement(userId, userIdentity.getGUID(), "userIdentity.getGUID", "UserIdentity", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", "ActorProfile", methodName);
        }
        return null;
    }
}

