/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

class DataFieldBuilder
extends OpenMetadataAPIGenericBuilder {
    private String dataFieldName;
    private String dataFieldType;
    private String dataFieldDescription;
    private List<String> dataFieldAliases;
    private int dataFieldSortOrder;
    private String defaultValue;
    private Map<String, String> additionalProperties;

    public DataFieldBuilder(String dataFieldName, String dataFieldType, String dataFieldDescription, List<String> dataFieldAliases, int dataFieldSortOrder, String defaultValue, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, extendedProperties, null, null, repositoryHelper, serviceName, serverName);
        this.dataFieldName = dataFieldName;
        this.dataFieldType = dataFieldType;
        this.dataFieldDescription = dataFieldDescription;
        this.dataFieldAliases = dataFieldAliases;
        this.dataFieldSortOrder = dataFieldSortOrder;
        this.defaultValue = defaultValue;
        this.additionalProperties = additionalProperties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.dataFieldName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataFieldName", this.dataFieldName, methodName);
        }
        if (this.dataFieldType != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataFieldType", this.dataFieldType, methodName);
        }
        if (this.dataFieldDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataFieldDescription", this.dataFieldDescription, methodName);
        }
        if (this.dataFieldAliases != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "dataFieldAliases", this.dataFieldAliases, methodName);
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "dataFieldName", "aaa4df8f-1aca-4de8-9abd-1ef2aadba300", "DataItemSortOrder", this.dataFieldSortOrder, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "sortOrder");
        }
        if (this.defaultValue != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValue", this.defaultValue, methodName);
        }
        if (this.additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        }
        return properties;
    }
}

