/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class EndpointBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String networkAddress;
    private String protocol;
    private String encryptionMethod;

    public EndpointBuilder(String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.networkAddress = networkAddress;
        this.protocol = protocol;
        this.encryptionMethod = encryptionMethod;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.networkAddress != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "networkAddress", this.networkAddress, methodName);
        }
        if (this.protocol != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "protocol", this.protocol, methodName);
        }
        if (this.encryptionMethod != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encryptionMethod", this.encryptionMethod, methodName);
        }
        return properties;
    }
}

