/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDefinitionHandler<B>
extends ReferenceableHandler<B> {
    public GovernanceDefinitionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceDefinition(String userId, String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, List<String> businessImperatives, String jurisdiction, String implementationDescription, String namePattern, String details, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GovernanceDefinitionBuilder builder;
        String typeGUID;
        String definitionGUID;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        if ((definitionGUID = this.createBeanInRepository(userId, null, null, typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper), typeName, qualifiedName, "qualifiedName", builder = new GovernanceDefinitionBuilder(qualifiedName, title, summary, description, scope, domainIdentifier, priority, implications, outcomes, results, businessImperatives, jurisdiction, implementationDescription, namePattern, details, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName), methodName)) != null) {
            String definitionGUIDParameterName = "definitionGUID";
            this.linkElementToElement(userId, null, null, definitionGUID, "definitionGUID", "Glossary", definitionGUID, "definitionGUID", "GovernanceDefinition", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", null, methodName);
        }
        return definitionGUID;
    }

    public void updateGovernanceDefinition(String userId, String definitionGUID, String definitionGUIDParameterName, String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, List<String> businessImperatives, String jurisdiction, String implementationDescription, String namePattern, String details, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(definitionGUID, definitionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceDefinition", this.serviceName, methodName, this.repositoryHelper);
        GovernanceDefinitionBuilder builder = new GovernanceDefinitionBuilder(qualifiedName, title, summary, description, scope, domainIdentifier, priority, implications, outcomes, results, businessImperatives, jurisdiction, implementationDescription, namePattern, details, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, definitionGUID, definitionGUIDParameterName, typeGUID, typeName, builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void setupDelegationRelationship(String userId, String definitionParentGUID, String definitionParentGUIDParameterName, String definitionParentTypeName, String definitionChildGUID, String definitionChildGUIDParameterName, String definitionChildTypeName, String relationshipTypeGUID, String relationshipTypeName, String rationale, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "rationale", rationale, methodName);
        this.linkElementToElement(userId, null, null, definitionParentGUID, definitionParentGUIDParameterName, definitionParentTypeName, definitionChildGUID, definitionChildGUIDParameterName, definitionChildTypeName, relationshipTypeGUID, relationshipTypeName, properties, methodName);
    }

    public void setupPeerRelationship(String userId, String definitionParentGUID, String definitionParentGUIDParameterName, String definitionParentTypeName, String definitionChildGUID, String definitionChildGUIDParameterName, String definitionChildTypeName, String relationshipTypeGUID, String relationshipTypeName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        this.linkElementToElement(userId, null, null, definitionParentGUID, definitionParentGUIDParameterName, definitionParentTypeName, definitionChildGUID, definitionChildGUIDParameterName, definitionChildTypeName, relationshipTypeGUID, relationshipTypeName, properties, methodName);
    }

    public void clearDefinitionRelationship(String userId, String definitionParentGUID, String definitionParentGUIDParameterName, String definitionParentTypeName, String definitionChildGUID, String definitionChildGUIDParameterName, String definitionChildTypeGUID, String definitionChildTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, null, null, definitionParentGUID, definitionParentGUIDParameterName, definitionParentTypeName, definitionChildGUID, definitionChildGUIDParameterName, definitionChildTypeGUID, definitionChildTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
    }

    public void removeGovernanceDefinition(String userId, String definitionGUID, String definitionGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, definitionGUID, definitionGUIDParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDefinition", null, null, methodName);
    }

    public List<B> findGovernanceDefinitions(String userId, String typeGUID, String typeName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, typeGUID, typeName, null, startFrom, pageSize, methodName);
    }

    public List<B> getLinkedDefinitions(String userId, String definitionGUID, String definitionGUIDParameterName, String definitionTypeName, String relationshipTypeGUID, String relationshipTypeName, String targetElementType, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, definitionGUID, definitionGUIDParameterName, definitionTypeName, relationshipTypeGUID, relationshipTypeName, targetElementType, startFrom, pageSize, methodName);
    }

    public List<B> getGovernanceDefinitions(String userId, String typeGUID, String typeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, typeGUID, typeName, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public List<B> getGovernanceDefinitionsByDomain(String userId, String typeGUID, String typeName, int domainIdentifier, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getGovernanceDefinitions(userId, typeGUID, typeName, startFrom, pageSize, methodName);
        }
        List<EntityDetail> entities = this.getEntitiesByType(userId, typeGUID, typeName, this.supportedZones, null, startFrom, pageSize, methodName);
        ArrayList results = new ArrayList();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getProperties() == null || this.repositoryHelper.getIntProperty(this.serviceName, "domainIdentifier", entity.getProperties(), methodName) != domainIdentifier) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getGovernanceDefinitionsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("title");
        return this.getBeansByValue(userId, name, nameParameterName, typeGUID, typeName, specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public List<Relationship> getGoverningDefinitionLinks(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String governanceDefinitionTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "GovernanceDefinition";
        if (governanceDefinitionTypeName != null) {
            typeName = governanceDefinitionTypeName;
        }
        return this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", null, typeName, 1, startFrom, pageSize, methodName);
    }

    public List<B> getGoverningDefinitions(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String governanceDefinitionTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", governanceDefinitionTypeName, null, null, 1, startFrom, pageSize, methodName);
    }

    public B getGovernanceDefinitionByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "GovernanceDefinition", methodName);
    }
}

