/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LocationBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LocationHandler<B>
extends ReferenceableHandler<B> {
    public LocationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createLocation(String userId, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Location";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Location", this.serviceName, methodName, this.repositoryHelper);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, null, null, typeGUID, typeName, qualifiedName, "qualifiedName", locationBuilder, methodName);
    }

    public String createLocationFromTemplate(String userId, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, null, null, templateGUID, "templateGUID", "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", qualifiedName, "qualifiedName", locationBuilder, methodName);
    }

    public void updateLocation(String userId, String locationGUID, String locationGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Location";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Location", this.serviceName, methodName, this.repositoryHelper);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, locationGUID, locationGUIDParameterName, typeGUID, typeName, locationBuilder.getInstanceProperties(methodName), false, methodName);
    }

    public void addFixedLocationClassification(String userId, String locationGUID, String locationGUIDParameterName, String coordinates, String mapProjection, String postalAddress, String timeZone, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, locationGUID, locationGUIDParameterName, "Location", "bc111963-80c7-444f-9715-946c03142dd2", "FixedLocation", builder.getFixedLocationProperties(coordinates, mapProjection, postalAddress, timeZone, methodName), methodName);
    }

    public void removeFixedLocationClassification(String userId, String locationGUID, String locationGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, locationGUID, locationGUIDParameterName, "Location", "bc111963-80c7-444f-9715-946c03142dd2", "bc111963-80c7-444f-9715-946c03142dd2", methodName);
    }

    public void addSecureLocationClassification(String userId, String locationGUID, String locationGUIDParameterName, String description, String level, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, locationGUID, locationGUIDParameterName, "Location", "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", "SecureLocation", builder.getSecureLocationProperties(description, level, methodName), methodName);
    }

    public void removeSecureLocationClassification(String userId, String locationGUID, String locationGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, locationGUID, locationGUIDParameterName, "Location", "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", methodName);
    }

    public void addCyberLocationClassification(String userId, String locationGUID, String locationGUIDParameterName, String networkAddress, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, locationGUID, locationGUIDParameterName, "Location", "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", "CyberLocation", builder.getCyberLocationProperties(networkAddress, methodName), methodName);
    }

    public void removeCyberLocationClassification(String userId, String locationGUID, String locationGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, locationGUID, locationGUIDParameterName, "Location", "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", methodName);
    }

    public void setupNestedLocation(String userId, String locationParentGUID, String locationParentGUIDParameterName, String locationChildGUID, String locationChildGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, null, null, locationParentGUID, locationParentGUIDParameterName, "Location", locationChildGUID, locationChildGUIDParameterName, "Location", "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", null, methodName);
    }

    public void clearNestedLocation(String userId, String locationParentGUID, String locationParentGUIDParameterName, String locationChildGUID, String locationChildGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, null, null, locationParentGUID, locationParentGUIDParameterName, "Location", locationChildGUID, locationChildGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", "f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", methodName);
    }

    public void setupPeerLocations(String userId, String locationOneGUID, String locationOneGUIDParameterName, String locationTwoGUID, String locationTwoGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, null, null, locationOneGUID, locationOneGUIDParameterName, "Location", locationTwoGUID, locationTwoGUIDParameterName, "Location", "017d0518-fc25-4e5e-985e-491d91e61e17", "AdjacentLocation", null, methodName);
    }

    public void clearPeerLocations(String userId, String locationOneGUID, String locationOneGUIDParameterName, String locationTwoGUID, String locationTwoGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, null, null, locationOneGUID, locationOneGUIDParameterName, "Location", locationTwoGUID, locationTwoGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", "017d0518-fc25-4e5e-985e-491d91e61e17", "AdjacentLocation", methodName);
    }

    public void setupAssetLocation(String userId, String locationGUID, String locationGUIDParameterName, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, null, null, locationGUID, locationGUIDParameterName, "Location", assetGUID, assetGUIDParameterName, "Asset", "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", null, methodName);
    }

    public void clearAssetLocation(String userId, String locationGUID, String locationGUIDParameterName, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, null, null, locationGUID, locationGUIDParameterName, "Location", assetGUID, assetGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", methodName);
    }

    public void removeLocation(String userId, String locationGUID, String locationGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, locationGUID, locationGUIDParameterName, "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", null, null, methodName);
    }

    public int countKnownLocations(String userId, String elementGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, elementGUID, "Referenceable", "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", methodName);
    }

    public List<B> getLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getLocations(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startingFrom, pageSize, methodName);
    }

    public List<B> getLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", "Location", serviceSupportedZones, startingFrom, pageSize, methodName);
    }
}

