/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OperatingPlatformBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OperatingPlatformHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public OperatingPlatformHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void createOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String description, String operatingSystem, int byteOrdering, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "OperatingPlatform";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "OperatingPlatform", this.serviceName, methodName, this.repositoryHelper);
        OperatingPlatformBuilder builder = new OperatingPlatformBuilder(qualifiedName, name, description, operatingSystem, byteOrdering, additionalProperties, typeGUID, suppliedTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "bd96a997-8d78-42f6-adf7-8239bc98501c", "OperatingPlatform", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, String qualifiedName, String name, String description, String operatingSystem, int byteOrdering, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(operatingPlatformGUID, operatingPlatformGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "OperatingPlatform";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "OperatingPlatform", this.serviceName, methodName, this.repositoryHelper);
        OperatingPlatformBuilder builder = new OperatingPlatformBuilder(qualifiedName, name, description, operatingSystem, byteOrdering, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, operatingPlatformGUID, operatingPlatformGUIDParameterName, typeGUID, typeName, builder.getInstanceProperties(methodName), false, methodName);
    }

    public void setupHostOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", operatingPlatformGUID, operatingPlatformGUIDParameterName, "OperatingPlatform", "b9179df5-6e23-4581-a8b0-2919e6322b12", "HostOperatingPlatform", null, methodName);
    }

    public void clearNestedOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, "Host", operatingPlatformGUID, operatingPlatformGUIDParameterName, "bd96a997-8d78-42f6-adf7-8239bc98501c", "OperatingPlatform", "b9179df5-6e23-4581-a8b0-2919e6322b12", "HostOperatingPlatform", methodName);
    }

    public void removeOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, operatingPlatformGUID, operatingPlatformGUIDParameterName, "bd96a997-8d78-42f6-adf7-8239bc98501c", "OperatingPlatform", null, null, methodName);
    }

    public B getOperatingPlatform(String userId, String qualifiedName, String qualifiedNameParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanByUniqueName(userId, qualifiedName, qualifiedNameParameter, "qualifiedName", "bd96a997-8d78-42f6-adf7-8239bc98501c", "OperatingPlatform", methodName);
    }

    public List<B> getOperatingPlatforms(String userId, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, "bd96a997-8d78-42f6-adf7-8239bc98501c", "OperatingPlatform", this.supportedZones, null, startingFrom, maximumResults, methodName);
    }
}

