/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonRoleHandler<B>
extends ReferenceableHandler<B> {
    public PersonRoleHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createPersonRole(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String description, String scope, int headCount, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "PersonRole";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "PersonRole", this.serviceName, methodName, this.repositoryHelper);
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, name, description, scope, headCount, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", roleBuilder, methodName);
    }

    public String createPersonRoleFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String name, String description, int headCount, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, name, description, headCount, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", qualifiedName, "qualifiedName", roleBuilder, methodName);
    }

    public String appointPersonToRole(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String roleGUID, String roleGUIDParameterName, boolean isPublic, Date startDate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "Person", roleGUID, roleGUIDParameterName, "PersonRole", this.supportedZones, "4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", builder.getAppointmentProperties(isPublic, startDate, methodName), methodName);
    }

    public void relievePersonFromRole(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String roleGUID, String roleGUIDParameterName, String appointmentGUID, String appointmentGUIDParameterName, Date endDate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, "Person", roleGUID, roleGUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", (List<String>)this.supportedZones, "4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", methodName);
    }

    public void addTeamLeader(String userId, String externalSourceGUID, String externalSourceName, String teamLeaderRoleGUID, String teamLeaderRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String position, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, teamLeaderRoleGUID, teamLeaderRoleGUIDParameterName, "TeamLeader", teamGUID, teamGUIDParameterName, "Team", this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamLeadership", builder.getTeamLeadershipProperties(position, methodName), methodName);
    }

    public void removeTeamLeader(String userId, String externalSourceGUID, String externalSourceName, String teamLeaderRoleGUID, String teamLeaderRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, teamLeaderRoleGUID, teamLeaderRoleGUIDParameterName, "TeamLeader", teamGUID, teamGUIDParameterName, "36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", (List<String>)this.supportedZones, "5ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamLeadership", methodName);
    }

    public void addTeamMember(String userId, String externalSourceGUID, String externalSourceName, String teamMemberRoleGUID, String teamMemberRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String position, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, teamMemberRoleGUID, teamMemberRoleGUIDParameterName, "TeamMember", teamGUID, teamGUIDParameterName, "Team", this.supportedZones, "1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", builder.getTeamMembershipProperties(position, methodName), methodName);
    }

    public void removeTeamMember(String userId, String externalSourceGUID, String externalSourceName, String teamMemberRoleGUID, String teamMemberRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, teamMemberRoleGUID, teamMemberRoleGUIDParameterName, "TeamMember", teamGUID, teamGUIDParameterName, "36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", (List<String>)this.supportedZones, "1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", methodName);
    }

    public void updatePersonRole(String userId, String externalSourceGUID, String externalSourceName, String roleGUID, String roleGUIDParameterName, String qualifiedName, String name, String description, String scope, int headCount, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(roleGUID, roleGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "PersonRole", this.serviceName, methodName, this.repositoryHelper);
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, name, description, scope, headCount, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, roleGUID, roleGUIDParameterName, typeGUID, typeName, roleBuilder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void removePersonRole(String userId, String roleGUID, String roleGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, roleGUID, roleGUIDParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", null, null, methodName);
    }

    public List<B> findPersonRoles(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", null, startFrom, pageSize, methodName);
    }

    public List<B> getPersonRolesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public List<B> getPersonRolesForRoleId(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return this.getBeansByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public List<B> getPersonRolesForTitle(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("name");
        return this.getBeansByValue(userId, name, nameParameterName, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }

    public List<B> getPersonRolesForDomainId(String userId, int domainIdentifier, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getBeansByType(userId, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", this.supportedZones, null, startFrom, pageSize, methodName);
        }
        return this.getBeansByIntValue(userId, domainIdentifier, "ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", "domainIdentifier", null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
    }
}

