/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler<B>
extends SchemaElementHandler<B> {
    private OpenMetadataAPIGenericConverter<B> schemaTypeConverter;

    public SchemaTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaTypeConverter = converter;
    }

    public String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder.getTypeGUID(), schemaTypeBuilder.getTypeName(), schemaTypeBuilder.getQualifiedName(), "qualifiedName", schemaTypeBuilder, methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", schemaTypeBuilder.getTypeName(), schemaTypeBuilder, methodName);
        return schemaTypeGUID;
    }

    public String createSchemaTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String existingSchemaTypeGUID, String existingSchemaTypeGUIDParameterName, SchemaTypeBuilder builder) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaType";
        this.updateSchemaType(userId, externalSourceGUID, externalSourceName, existingSchemaTypeGUID, existingSchemaTypeGUIDParameterName, builder, false, "updateSchemaType");
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String existingSchemaTypeGUID, String existingSchemaTypeGUIDParameterName, SchemaTypeBuilder builder, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, existingSchemaTypeGUID, existingSchemaTypeGUIDParameterName, this.getSchemaTypeTypeGUID(builder), this.getSchemaTypeTypeName(builder), builder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    private String getSchemaTypeTypeGUID(SchemaTypeBuilder builder) {
        if (builder.getTypeGUID() != null) {
            return builder.getTypeGUID();
        }
        return "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
    }

    private String getSchemaTypeTypeName(SchemaTypeBuilder builder) {
        if (builder.getTypeName() != null) {
            return builder.getTypeName();
        }
        return "SchemaType";
    }

    public void removeSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaType";
        String guidParameterName = "schemaTypeGUID";
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", null, null, "removeSchemaType");
    }

    public B getSchemaTypeForAsset(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, assetGUID, assetGUIDParameterName, "Asset", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
    }

    public B getSchemaTypeForPort(String userId, String portGUID, String portGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, portGUID, portGUIDParameterName, "Port", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", methodName);
    }

    public B getSchemaTypeForParent(String userId, String parentGUID, String parentGUIDParameterName, String parentTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getAttachedEntity(userId, parentGUID, parentGUIDParameterName, parentTypeName, relationshipTypeGUID, relationshipTypeName, "SchemaType", methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, methodName);
    }

    public B getSchemaType(String userId, String schemaTypeGUID, String guidParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getEntityFromRepository(userId, schemaTypeGUID, guidParameterName, "SchemaType", methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, methodName);
    }

    public List<B> findSchemaTypes(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        List<EntityDetail> entities = this.findEntities(userId, searchString, "searchString", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", null, null, null, startFrom, pageSize, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, methodName);
    }

    public List<B> getSchemaTypeByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, "name", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", specificMatchPropertyNames, true, null, null, false, this.supportedZones, null, startFrom, pageSize, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, methodName);
    }

    private List<B> getSchemaTypesFromEntities(String userId, List<EntityDetail> schemaTypeEntities, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<B> results = new ArrayList<B>();
        if (schemaTypeEntities != null) {
            for (EntityDetail entity : schemaTypeEntities) {
                if (entity == null) continue;
                results.add(this.getSchemaTypeFromEntity(userId, entity, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private B getSchemaTypeFromEntity(String userId, EntityDetail schemaTypeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaTypeEntity != null && schemaTypeEntity.getType() != null) {
            return this.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaTypeEntity, schemaTypeEntity.getType().getTypeDefName(), schemaTypeEntity.getProperties(), schemaTypeEntity.getClassifications(), methodName);
        }
        return null;
    }

    public B getSchemaTypeFromInstance(String userId, InstanceHeader schemaRootHeader, String schemaRootTypeName, InstanceProperties instanceProperties, List<Classification> entityClassifications, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> schemaTypeOptionsEntities;
        EntityDetail externalSchemaTypeEntity;
        String schemaGUIDParameterName = "schemaRootGUID";
        int attributeCount = 0;
        String validValuesSetGUID = null;
        String externalSchemaTypeGUID = null;
        Object externalSchemaType = null;
        Object mapToSchemaType = null;
        Object mapFromSchemaType = null;
        ArrayList<B> schemaTypeOptions = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "ExternalSchemaType") && (externalSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaAttribute", "9a5d78c2-1716-4783-bfc6-c300a9e2d092", "LinkedExternalSchemaType", "SchemaType", methodName)) != null) {
            externalSchemaType = this.getSchemaTypeFromEntity(userId, externalSchemaTypeEntity, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "ComplexSchemaType")) {
            attributeCount = this.countSchemaAttributes(userId, schemaRootHeader.getGUID(), "schemaRootGUID", methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "EnumSchemaType")) {
            EntityDetail validValuesSetEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "ValidValuesSet", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", "ValidValuesSet", methodName);
            if (validValuesSetEntity != null) {
                validValuesSetGUID = validValuesSetEntity.getGUID();
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "MapSchemaType")) {
            EntityDetail mapToSchemaTypeEntity;
            EntityDetail mapFromSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaAttribute", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", "SchemaType", methodName);
            if (mapFromSchemaTypeEntity != null) {
                mapFromSchemaType = this.getSchemaTypeFromEntity(userId, mapFromSchemaTypeEntity, methodName);
            }
            if ((mapToSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaAttribute", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", "SchemaType", methodName)) != null) {
                mapToSchemaType = this.getSchemaTypeFromEntity(userId, mapToSchemaTypeEntity, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, "SchemaTypeChoice") && (schemaTypeOptionsEntities = this.getAttachedEntities(userId, schemaRootHeader.getGUID(), "schemaRootGUID", "SchemaAttribute", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", "SchemaType", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName)) != null && !schemaTypeOptionsEntities.isEmpty()) {
            schemaTypeOptions = new ArrayList<B>();
            for (EntityDetail schemaTypeOptionEntity : schemaTypeOptionsEntities) {
                if (schemaTypeOptionEntity == null) continue;
                schemaTypeOptions.add(this.getSchemaTypeFromEntity(userId, schemaTypeOptionEntity, methodName));
            }
        }
        return this.schemaTypeConverter.getNewSchemaTypeBean(this.beanClass, schemaRootHeader, schemaRootTypeName, instanceProperties, entityClassifications, attributeCount, validValuesSetGUID, externalSchemaTypeGUID, externalSchemaType, mapFromSchemaType, mapToSchemaType, schemaTypeOptions, methodName);
    }
}

