/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SearchKeywordBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SearchKeywordHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public SearchKeywordHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createKeyword(String userId, String externalSourceGUID, String externalSourceName, String keywordName, String keywordDescription, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "keywordName";
        this.invalidParameterHandler.validateName(keywordName, "keywordName", methodName);
        SearchKeywordBuilder builder = new SearchKeywordBuilder(keywordName, keywordDescription, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", null, null, builder, methodName);
    }

    public void updateKeywordDescription(String userId, String externalSourceGUID, String externalSourceName, String keywordGUID, String keywordGUIDParameterName, String keywordDescription, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", keywordDescription, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, keywordGUID, keywordGUIDParameterName, "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", serviceSupportedZones, properties, true, methodName);
    }

    public void deleteKeyword(String userId, String externalSourceGUID, String externalSourceName, String keywordGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String keywordGUIDParameterName = "keywordGUID";
        B keyword = this.getKeyword(userId, keywordGUID, "keywordGUID", null, methodName);
        if (keyword != null) {
            if (this.repositoryHandler.countAttachedRelationshipsByType(userId, keywordGUID, "SearchKeyword", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "SearchKeywordLink", methodName) == 0) {
                this.repositoryHandler.removeEntity(userId, externalSourceGUID, externalSourceName, keywordGUID, "keywordGUID", "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", null, null, methodName);
            } else {
                this.invalidParameterHandler.throwCannotDeleteElementInUse(keywordGUID, "SearchKeyword", this.serviceName, methodName);
            }
        }
    }

    public int countKeywords(String userId, String elementGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.countAttachments(userId, elementGUID, "Referenceable", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "SearchKeywordLink", methodName);
    }

    public List<B> getAttachedKeywords(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, startingGUID, startingGUIDParameterName, startingTypeName, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "SearchKeywordLink", "SearchKeyword", serviceSupportedZones, startingFrom, pageSize, methodName);
    }

    public List<B> getRelatedKeywords(String userId, String startingKeywordGUID, String startingKeywordGUIDParameterName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, startingKeywordGUID, startingKeywordGUIDParameterName, "SearchKeyword", "f9ffa8a8-80f5-4e6d-9c05-a3a5e0277d62", "RelatedKeyword", "SearchKeyword", serviceSupportedZones, startingFrom, pageSize, methodName);
    }

    public B getKeyword(String userId, String guid, String guidParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "SearchKeyword", serviceSupportedZones, methodName);
    }

    public List<B> getKeywordsByName(String userId, String keyword, String keywordParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("keyword");
        return this.getBeansByValue(userId, keyword, keywordParameterName, "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", propertyNames, true, null, null, false, serviceSupportedZones, null, startFrom, pageSize, methodName);
    }

    public List<B> findKeywords(String userId, String searchString, String searchStringParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", null, false, serviceSupportedZones, null, startFrom, pageSize, methodName);
    }

    public void addKeywordToElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String keywordGUID, String keywordGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, keywordGUID, keywordGUIDParameterName, "SearchKeyword", serviceSupportedZones, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "SearchKeywordLink", null, methodName);
    }

    public void removeKeywordFromElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String keywordGUID, String keywordGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, keywordGUID, keywordGUIDParameterName, "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", serviceSupportedZones, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "SearchKeywordLink", methodName);
    }

    public void linkRelatedKeywords(String userId, String externalSourceGUID, String externalSourceName, String keywordOneGUID, String keywordOneGUIDParameterName, String keywordTwoGUID, String keywordTwoGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, keywordOneGUID, keywordOneGUIDParameterName, "SearchKeyword", keywordTwoGUID, keywordTwoGUIDParameterName, "SearchKeyword", serviceSupportedZones, "f9ffa8a8-80f5-4e6d-9c05-a3a5e0277d62", "RelatedKeyword", null, methodName);
    }

    public void unlinkRelatedKeywords(String userId, String externalSourceGUID, String externalSourceName, String keywordOneGUID, String keywordOneGUIDParameterName, String keywordTwoGUID, String keywordTwoGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, keywordOneGUID, keywordOneGUIDParameterName, "SearchKeyword", keywordTwoGUID, keywordTwoGUIDParameterName, "0134c9ae-0fe6-4224-bb3b-e18b78a90b1e", "SearchKeyword", serviceSupportedZones, "f9ffa8a8-80f5-4e6d-9c05-a3a5e0277d62", "RelatedKeyword", methodName);
    }
}

