/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetHandler<B>
extends ReferenceableHandler<B> {
    private ConnectionHandler<OpenMetadataAPIDummyBean> connectionHandler;

    public AssetHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<String> getTypesOfAssetList() {
        return this.repositoryHelper.getSubTypesOf(this.serviceName, "Asset");
    }

    public Map<String, String> getTypesOfAssetDescriptions() {
        List assetTypeList = this.repositoryHelper.getSubTypesOf(this.serviceName, "Asset");
        HashMap<String, String> assetDescriptions = new HashMap<String, String>();
        if (assetTypeList != null) {
            for (String assetTypeName : assetTypeList) {
                TypeDef assetTypeDef;
                if (assetTypeName == null || (assetTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, assetTypeName)) == null) continue;
                assetDescriptions.put(assetTypeName, assetTypeDef.getDescription());
            }
        }
        if (assetDescriptions.isEmpty()) {
            return null;
        }
        return assetDescriptions;
    }

    private void attachConnectionToAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String connectionGUID, String connectionGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = null;
        if (assetSummary != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, "Asset", connectionGUID, connectionGUIDParameterName, "Connection", this.supportedZones, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", properties, methodName);
    }

    public void attachSchemaTypeToAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.removeAssociatedSchemaType(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, "Asset", schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, methodName);
    }

    public void removeAssociatedSchemaType(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkAllElements(userId, false, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, "Asset", this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
    }

    public String detachSchemaTypeFromAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.unlinkConnectedElement(userId, false, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, "Asset", this.supportedZones, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", "SchemaType", methodName);
    }

    public void saveSemanticAssignments(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, List<String> glossaryTermGUIDs, String glossaryTermGUIDsParameter, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (glossaryTermGUIDs != null) {
            for (String glossaryTermGUID : glossaryTermGUIDs) {
                if (glossaryTermGUID == null) continue;
                this.saveSemanticAssignment(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, glossaryTermGUID, glossaryTermGUIDsParameter, methodName);
            }
        }
    }

    public String addAssetFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String expectedTypeGUID, String expectedTypeName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetBuilder builder = new AssetBuilder(qualifiedName, displayName, description, null, expectedTypeGUID, expectedTypeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, expectedTypeGUID, expectedTypeName, qualifiedName, qualifiedNameParameterName, builder, methodName);
    }

    public String createAssetInRepository(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, List<String> zoneMembership, String owner, int ownerType, String originOrganizationCapabilityGUID, String originBusinessCapabilityGUID, Map<String, String> otherOriginValues, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetBuilder builder = new AssetBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (zoneMembership != null) {
            builder.setAssetZones(userId, zoneMembership, methodName);
        }
        builder.setAssetOwnership(userId, owner, ownerType, methodName);
        builder.setAssetOrigin(userId, originOrganizationCapabilityGUID, originBusinessCapabilityGUID, otherOriginValues, methodName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, qualifiedName, "qualifiedName", builder, methodName);
    }

    public void updateAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AssetBuilder builder = new AssetBuilder(qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, typeGUID, typeName, this.supportedZones, builder.getInstanceProperties(methodName), false, methodName);
    }

    public void updateAssetWithConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, String assetSummary, Connection connection, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAsset(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, qualifiedName, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, methodName);
        Relationship assetConnectionRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, assetGUID, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
        if (connection == null) {
            this.unlinkConnectedElement(userId, false, null, null, assetGUID, assetGUIDParameterName, typeName, this.supportedZones, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Collection", methodName);
        } else {
            String connectionGUID = this.connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, assetGUIDParameterName, typeName, connection, assetSummary, methodName);
            if (assetConnectionRelationship == null) {
                InstanceProperties relationshipProperties = null;
                if (assetSummary != null) {
                    relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
                }
                this.repositoryHandler.createRelationship(userId, "e777d660-8dbe-453e-8b83-903771f054c0", null, null, connectionGUID, assetGUID, relationshipProperties, methodName);
            } else {
                this.repositoryHandler.updateUniqueRelationshipByType(userId, null, null, connectionGUID, "Connection", assetGUID, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
            }
        }
    }

    public void classifyAssetAsReferenceData(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.setClassificationInRepository(userId, assetGUID, assetGUIDParameterName, "Asset", "55e5ae33-39c6-4834-9d05-ef0ae4e0163b", "ReferenceData", null, methodName);
    }

    public void declassifyAssetAsReferenceData(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, assetGUID, assetGUIDParameterName, "Asset", "55e5ae33-39c6-4834-9d05-ef0ae4e0163b", "ReferenceData", methodName);
    }

    public void addAssetOrigin(String userId, String assetGUID, String assetGUIDParameterName, String organizationGUID, String organizationGUIDParameterName, String businessCapabilityGUID, String businessCapabilityGUIDParameterName, Map<String, String> otherOriginValues, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (organizationGUID != null) {
            this.validateAnchorEntity(userId, organizationGUID, organizationGUIDParameterName, "Organization", false, this.supportedZones, methodName);
        }
        if (businessCapabilityGUID != null) {
            this.validateAnchorEntity(userId, businessCapabilityGUID, businessCapabilityGUIDParameterName, "BusinessCapability", false, this.supportedZones, methodName);
        }
        AssetBuilder builder = new AssetBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, assetGUID, assetGUIDParameterName, "Asset", "e530c566-03d2-470a-be69-6f52bfbd5fb7", "AssetOrigin", builder.getOriginProperties(organizationGUID, businessCapabilityGUID, otherOriginValues, methodName), methodName);
    }

    public void removeAssetOrigin(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, assetGUID, assetGUIDParameterName, "Asset", "e530c566-03d2-470a-be69-6f52bfbd5fb7", "AssetOrigin", methodName);
    }

    public void publishAsset(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAssetZones(userId, assetGUID, assetGUIDParameterName, this.publishZones, methodName);
    }

    public void withdrawAsset(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAssetZones(userId, assetGUID, assetGUIDParameterName, this.defaultZones, methodName);
    }

    public void updateAssetZones(String userId, String assetGUID, String assetGUIDParameterName, List<String> assetZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        AssetBuilder builder = new AssetBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, assetGUID, assetGUIDParameterName, "Asset", "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", builder.getZoneMembershipProperties(assetZones, methodName), methodName);
    }

    public void updateAssetOwner(String userId, String assetGUID, String assetGUIDParameterName, String ownerId, int ownerType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AssetBuilder builder = new AssetBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, assetGUID, assetGUIDParameterName, "Asset", "d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", builder.getOwnerProperties(userId, ownerId, ownerType, methodName), methodName);
    }

    public String getAssetForConnection(String userId, String connectionGUID, String connectionGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUID(userId, connectionGUID, connectionGUIDParameterName, "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Asset", 0, serviceSupportedZones, methodName);
    }

    public String getAssetForConnectionName(String userId, String connectionName, String connectionNameParameter, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<String> connectionGUIDs = this.getBeanGUIDsByValue(userId, connectionName, connectionNameParameter, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", specificMatchPropertyNames, true, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (connectionGUIDs != null) {
            for (String connectionGUID : connectionGUIDs) {
                if (connectionGUID == null) continue;
                return this.getAssetForConnection(userId, connectionGUID, connectionNameParameter, this.supportedZones, methodName);
            }
        }
        return null;
    }

    public B getAssetWithConnection(String userId, String assetGUID, String assetGUIDParameterName, String assetTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail assetEntity = this.getEntityFromRepository(userId, assetGUID, assetGUIDParameterName, assetTypeName, methodName);
        if (assetEntity != null) {
            return this.getAssetWithConnectionBean(userId, assetEntity, methodName);
        }
        return null;
    }

    public B getAssetByNameWithConnection(String userId, String name, String nameParameterName, String assetTypeGUID, String assetTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        List<EntityDetail> results = this.getEntitiesByValue(userId, name, nameParameterName, assetTypeGUID, assetTypeName, specificMatchPropertyNames, true, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (results != null && results.size() == 1) {
            return this.getAssetWithConnectionBean(userId, results.get(0), methodName);
        }
        this.errorHandler.handleAmbiguousEntityName(name, nameParameterName, assetTypeName, results, methodName);
        return null;
    }

    public List<B> getAllAssetsWithConnection(String userId, String assetTypeGUID, String assetTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.getEntitiesByType(userId, assetTypeGUID, assetTypeName, this.supportedZones, startFrom, pageSize, methodName);
        if (entities != null && !entities.isEmpty()) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getAssetWithConnectionBean(userId, entity, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private B getAssetWithConnectionBean(String userId, EntityDetail assetEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (assetEntity != null) {
            EntityProxy end1;
            EntityDetail connectionEntity = null;
            Relationship relationshipToConnection = this.repositoryHandler.getUniqueRelationshipByType(userId, assetEntity.getGUID(), assetEntity.getType().getTypeDefName(), "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
            if (relationshipToConnection != null && (end1 = relationshipToConnection.getEntityOneProxy()) != null) {
                String connectionGUIDParameterName = "";
                connectionEntity = this.getEntityFromRepository(userId, end1.getGUID(), "", "Connection", methodName);
            }
            ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            if (connectionEntity != null && connectionEntity.getType() != null) {
                supplementaryEntities.add(connectionEntity);
                supplementaryRelationships.add(relationshipToConnection);
                List<Relationship> connectionRelationships = this.getEmbeddedConnectionRelationships(userId, (EntitySummary)connectionEntity, methodName);
                if (connectionRelationships != null) {
                    supplementaryRelationships.addAll(connectionRelationships);
                    for (Relationship relationship : connectionRelationships) {
                        if (relationship == null || relationship.getType() == null) continue;
                        EntityProxy entityProxy = null;
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionConnectorType") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection")) {
                            entityProxy = relationship.getEntityTwoProxy();
                        } else if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionEndpoint")) {
                            entityProxy = relationship.getEntityOneProxy();
                        }
                        if (entityProxy == null || entityProxy.getGUID() == null || entityProxy.getType() == null) continue;
                        String entityGUIDParameterName = "embeddedRelationship proxy";
                        EntityDetail supplementaryEntity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "embeddedRelationship proxy", entityProxy.getType().getTypeDefName(), methodName);
                        if (supplementaryEntity == null) continue;
                        supplementaryEntities.add(supplementaryEntity);
                    }
                }
            }
            if (supplementaryEntities.isEmpty()) {
                supplementaryEntities = null;
            }
            if (supplementaryRelationships.isEmpty()) {
                supplementaryEntities = null;
            }
            return this.converter.getNewComplexBean(this.beanClass, assetEntity, supplementaryEntities, supplementaryRelationships, methodName);
        }
        return null;
    }

    private List<Relationship> getEmbeddedConnectionRelationships(String userId, EntitySummary connectionEntity, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
        if (connectionEntity != null && connectionEntity.getType() != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, connectionEntity.getGUID(), connectionEntity.getType().getTypeDefName(), null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            while (iterator.moreToReceive()) {
                List<Relationship> embeddedConnectionRelationships;
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionEndpoint") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectorType") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionToAsset")) {
                    supplementaryRelationships.add(relationship);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection")) continue;
                supplementaryRelationships.add(relationship);
                EntityProxy embeddedConnectionEnd = relationship.getEntityTwoProxy();
                if (embeddedConnectionEnd == null || embeddedConnectionEnd.getGUID() == null || (embeddedConnectionRelationships = this.getEmbeddedConnectionRelationships(userId, (EntitySummary)embeddedConnectionEnd, methodName)) == null) continue;
                supplementaryRelationships.addAll(embeddedConnectionRelationships);
            }
        }
        if (supplementaryRelationships.isEmpty()) {
            return null;
        }
        return supplementaryRelationships;
    }

    public List<String> assetGUIDsScan(String userId, String subTypeGUID, String subTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.assetGUIDZoneScan(userId, null, subTypeGUID, subTypeName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<String> assetGUIDsScan(String userId, String subTypeGUID, String subTypeName, List<String> suppliedSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.assetGUIDZoneScan(userId, null, subTypeGUID, subTypeName, suppliedSupportedZones, startFrom, pageSize, methodName);
    }

    public List<B> assetScan(String userId, String subTypeGUID, String subTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.assetZoneScan(userId, null, subTypeGUID, subTypeName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> assetScan(String userId, String subTypeGUID, String subTypeName, List<String> suppliedSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.assetZoneScan(userId, null, subTypeGUID, subTypeName, suppliedSupportedZones, startFrom, pageSize, methodName);
    }

    public List<B> assetZoneScan(String userId, String zoneName, String subTypeGUID, String subTypeName, List<String> suppliedSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (subTypeGUID != null) {
            resultTypeGUID = subTypeGUID;
        }
        if (subTypeName != null) {
            resultTypeName = subTypeName;
        }
        ArrayList results = new ArrayList();
        if (zoneName == null || suppliedSupportedZones == null || suppliedSupportedZones.contains(zoneName)) {
            RepositoryEntitiesIterator iterator = new RepositoryEntitiesIterator(this.repositoryHandler, userId, resultTypeGUID, resultTypeName, startFrom, queryPageSize, methodName);
            while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
                List assetZones;
                EntityDetail entity = iterator.getNext();
                if (entity == null || (assetZones = this.repositoryHelper.getStringArrayProperty(this.serviceName, "zoneMembership", entity.getProperties(), methodName)) == null || !assetZones.contains(zoneName)) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<String> assetGUIDZoneScan(String userId, String zoneName, String subTypeGUID, String subTypeName, List<String> suppliedSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (subTypeGUID != null) {
            resultTypeGUID = subTypeGUID;
        }
        if (subTypeName != null) {
            resultTypeName = subTypeName;
        }
        ArrayList<String> results = new ArrayList<String>();
        if (zoneName == null || suppliedSupportedZones == null || suppliedSupportedZones.contains(zoneName)) {
            RepositoryEntitiesIterator iterator = new RepositoryEntitiesIterator(this.repositoryHandler, userId, resultTypeGUID, resultTypeName, startFrom, queryPageSize, methodName);
            while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
                List assetZones;
                EntityDetail entity = iterator.getNext();
                if (entity == null || (assetZones = this.repositoryHelper.getStringArrayProperty(this.serviceName, "zoneMembership", entity.getProperties(), methodName)) == null || !assetZones.contains(zoneName)) continue;
                results.add(entity.getGUID());
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> findAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findAssetsByName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, serviceSupportedZones, startFrom, pageSize, methodName);
    }

    public List<String> getAssetGUIDsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetGUIDsByName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<String> getAssetGUIDsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeanGUIDsByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, serviceSupportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetsByName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, serviceSupportedZones, startFrom, pageSize, methodName);
    }

    List<B> getAssetsByMetadataCollectionId(String userId, String typeGUID, String typeName, String metadataCollectionId, String metadataCollectionIdParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("name");
        specificMatchPropertyNames.add("description");
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeansByValue(userId, metadataCollectionId, metadataCollectionIdParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<String> getAssetGUIDsByEndpoint(String userId, String networkAddress, String networkAddressParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        int maxPageSize = this.invalidParameterHandler.getMaxPagingSize();
        int startNextQueryFrom = 0;
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        ArrayList<String> relationshipPath = new ArrayList<String>();
        relationshipPath.add("887a7132-d6bc-4b92-a483-e80b60c86fb2");
        relationshipPath.add("e777d660-8dbe-453e-8b83-903771f054c0");
        ArrayList<String> assetGUIDs = new ArrayList<String>();
        ArrayList<String> resultGUIDs = new ArrayList<String>();
        boolean moreResultsAvailable = true;
        while (moreResultsAvailable && (queryPageSize == 0 || resultGUIDs.size() < queryPageSize)) {
            List<String> endpointGUIDs = this.getBeanGUIDsByValue(userId, networkAddress, networkAddressParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", specificMatchPropertyNames, true, this.supportedZones, startNextQueryFrom, maxPageSize, methodName);
            if (endpointGUIDs == null) {
                moreResultsAvailable = false;
                continue;
            }
            for (String endpointGUID : endpointGUIDs) {
                if (endpointGUID == null) continue;
                boolean moreResultsFromEndpoint = true;
                int endpointStartFrom = 0;
                while (moreResultsFromEndpoint && (queryPageSize == 0 || resultGUIDs.size() < queryPageSize)) {
                    List<String> endpointAssetGUIDs = this.getRelatedEntityGUIDs(userId, endpointGUID, networkAddressParameterName, "Endpoint", relationshipPath, "Asset", this.supportedZones, endpointStartFrom, maxPageSize, methodName);
                    if (endpointAssetGUIDs == null || endpointAssetGUIDs.isEmpty()) {
                        moreResultsFromEndpoint = false;
                        continue;
                    }
                    for (String endpointAssetGUID : endpointAssetGUIDs) {
                        if (endpointAssetGUID == null || assetGUIDs.contains(endpointAssetGUID)) continue;
                        assetGUIDs.add(endpointAssetGUID);
                        if (assetGUIDs.size() <= startFrom) continue;
                        resultGUIDs.add(endpointAssetGUID);
                    }
                    endpointStartFrom += endpointAssetGUIDs.size();
                }
            }
        }
        if (resultGUIDs.isEmpty()) {
            return null;
        }
        return resultGUIDs;
    }

    public List<B> getAssetsByEndpoint(String userId, String networkAddress, String networkAddressParameterName, String suppliedTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<String> assetGUIDs;
        String assetTypeName = "Asset";
        if (suppliedTypeName != null) {
            assetTypeName = suppliedTypeName;
        }
        if ((assetGUIDs = this.getAssetGUIDsByEndpoint(userId, networkAddress, networkAddressParameterName, startFrom, pageSize, methodName)) == null || assetGUIDs.isEmpty()) {
            return null;
        }
        ArrayList assets = new ArrayList();
        for (String assetGUID : assetGUIDs) {
            if (assetGUID == null) continue;
            Object bean = this.getBeanFromRepository(userId, assetGUID, networkAddressParameterName, assetTypeName, this.supportedZones, methodName);
            assets.add(bean);
        }
        if (assets.isEmpty()) {
            return null;
        }
        return assets;
    }

    public List<String> findAssetGUIDs(String userId, String searchString, String searchStringParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findAssetGUIDs(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", searchString, searchStringParameter, startFrom, pageSize, methodName);
    }

    public List<String> findAssetGUIDs(String userId, String typeGUID, String typeName, String searchString, String searchStringParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanGUIDsByValue(userId, searchString, searchStringParameter, resultTypeGUID, resultTypeName, null, false, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findAssets(String userId, String searchString, String searchStringParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findAssets(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", searchString, searchStringParameter, startFrom, pageSize, methodName);
    }

    public List<B> findAssets(String userId, String typeGUID, String typeName, String searchString, String searchStringParameter, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String resultTypeName = "Asset";
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.findBeans(userId, searchString, searchStringParameter, resultTypeGUID, resultTypeName, startFrom, pageSize, methodName);
    }

    public List<String> getAssetGUIDsByTag(String userId, String tagGUID, String tagGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUIDs(userId, tagGUID, tagGUIDParameterName, "InformalTag", "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", "Asset", this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getAssetsByTag(String userId, String tagGUID, String tagGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, tagGUID, tagGUIDParameterName, "InformalTag", "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", "Asset", this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<String> getAssetGUIDsByKeyword(String userId, String keywordGUID, String keywordGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUIDs(userId, keywordGUID, keywordGUIDParameterName, "SearchKeyword", "f9ffa8a8-80f5-4e6d-9c05-a3a5e0277d62", "RelatedKeyword", "Asset", this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getAssetsByKeyword(String userId, String keywordGUID, String keywordGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, keywordGUID, keywordGUIDParameterName, "SearchKeyword", "f9ffa8a8-80f5-4e6d-9c05-a3a5e0277d62", "RelatedKeyword", "Referenceable", this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getAssetsByGlossaryTerm(String userId, String termGUID, String termGUIDParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, termGUID, termGUIDParameterName, "Glossary", "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", "Asset", this.supportedZones, startFrom, pageSize, methodName);
    }
}

