/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DiscoveryAnalysisReportBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryAnalysisReportHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public DiscoveryAnalysisReportHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createDiscoveryAnalysisReport(String userId, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, int discoveryRequestStatus, String assetGUID, String discoveryEngineGUID, String discoveryServiceGUID, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUID;
        String nameParameterName = "qualifiedName";
        String assetGUIDParameterName = "assetGUID";
        String discoveryEngineGUIDParameterName = "discoveryEngineGUID";
        String discoveryServiceGUIDParameterName = "discoveryServiceGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", methodName);
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "Asset", methodName, "assetGUID");
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "OpenDiscoveryEngine", methodName, "discoveryEngineGUID");
        DiscoveryAnalysisReportBuilder builder = new DiscoveryAnalysisReportBuilder(qualifiedName, displayName, description, creationDate, analysisParameters, discoveryRequestStatus, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        if (assetGUID != null) {
            builder.setAnchors(userId, assetGUID, methodName);
        }
        if ((reportGUID = this.repositoryHandler.createEntity(userId, "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", null, null, builder.getInstanceProperties(methodName), methodName)) != null) {
            this.repositoryHandler.createRelationship(userId, "7eded424-f176-4258-9ae6-138a46b2845f", null, null, assetGUID, reportGUID, null, methodName);
            this.repositoryHandler.createRelationship(userId, "2c318c3a-5dc2-42cd-a933-0087d852f67f", null, null, discoveryEngineGUID, reportGUID, null, methodName);
            this.repositoryHandler.createRelationship(userId, "1744d72b-903d-4273-9229-de20372a17e2", null, null, discoveryServiceGUID, reportGUID, null, methodName);
        }
        return reportGUID;
    }

    public void updateDiscoveryAnalysisReport(String userId, String discoveryReportGUID, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, int discoveryRequestStatus, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        DiscoveryAnalysisReportBuilder builder = new DiscoveryAnalysisReportBuilder(qualifiedName, displayName, description, creationDate, analysisParameters, discoveryRequestStatus, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, discoveryReportGUID, "discoveryReportGUID", "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", builder.getInstanceProperties(methodName), true, methodName);
    }

    public B getDiscoveryAnalysisReport(String userId, String discoveryReportGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        return this.getBeanFromRepository(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", methodName);
    }

    public List<B> getDiscoveryAnalysisReports(String userId, String assetGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        return this.getAttachedElements(userId, assetGUID, "assetGUID", "Asset", "7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", "OpenDiscoveryAnalysisReport", startingFrom, maximumResults, methodName);
    }
}

