/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryEntitiesIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryIteratorForEntities;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositorySelectedEntitiesIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.properties.Asset;
import org.odpi.openmetadata.metadatasecurity.properties.AssetAuditHeader;
import org.odpi.openmetadata.metadatasecurity.properties.ConfidenceGovernanceClassification;
import org.odpi.openmetadata.metadatasecurity.properties.ConfidentialityGovernanceClassification;
import org.odpi.openmetadata.metadatasecurity.properties.Connection;
import org.odpi.openmetadata.metadatasecurity.properties.CriticalityGovernanceClassification;
import org.odpi.openmetadata.metadatasecurity.properties.GovernanceClassificationStatus;
import org.odpi.openmetadata.metadatasecurity.properties.ReferenceableStatus;
import org.odpi.openmetadata.metadatasecurity.properties.RetentionGovernanceClassification;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataAPIGenericHandler<B> {
    protected OpenMetadataAPIGenericConverter<B> converter;
    protected Class<B> beanClass;
    protected String serviceName;
    protected String serverName;
    protected OMRSRepositoryHelper repositoryHelper;
    protected RepositoryHandler repositoryHandler;
    protected InvalidParameterHandler invalidParameterHandler;
    protected String localServerUserId;
    protected OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    protected List<String> supportedZones;
    protected List<String> publishZones;
    protected List<String> defaultZones;
    protected RepositoryErrorHandler errorHandler;
    private static final Logger log = LoggerFactory.getLogger(OpenMetadataAPIGenericHandler.class);
    protected AuditLog auditLog;

    public OpenMetadataAPIGenericHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.converter = converter;
        this.beanClass = beanClass;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.localServerUserId = localServerUserId;
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
        this.publishZones = publishZones;
        this.auditLog = auditLog;
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName);
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    private List<String> getSupportedZones(String userId, List<String> suppliedSupportedZones, String serviceName) throws InvalidParameterException, PropertyServerException {
        return this.securityVerifier.setSupportedZonesForUser(suppliedSupportedZones, serviceName, userId);
    }

    public OMRSRepositoryHelper getRepositoryHelper() {
        return this.repositoryHelper;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    void setClassificationInRepository(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, classificationProperties, methodName);
    }

    void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, beanGUID, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, this.supportedZones, methodName);
        if (beanEntity != null) {
            int latestChangeActionOrdinal;
            Classification existingClassification = null;
            List existingClassifications = beanEntity.getClassifications();
            if (existingClassifications != null) {
                for (Classification classification : existingClassifications) {
                    if (classification == null || !classificationTypeName.equals(classification.getName())) continue;
                    existingClassification = classification;
                }
            }
            if (existingClassification == null) {
                latestChangeActionOrdinal = 0;
                this.repositoryHandler.classifyEntity(userId, externalSourceGUID, externalSourceName, beanGUID, classificationTypeGUID, classificationTypeName, ClassificationOrigin.ASSIGNED, null, classificationProperties, methodName);
            } else {
                latestChangeActionOrdinal = 1;
                this.repositoryHandler.reclassifyEntity(userId, externalSourceGUID, externalSourceName, beanGUID, classificationTypeGUID, classificationTypeName, existingClassification, classificationProperties, methodName);
            }
            if (anchorEntity != null) {
                int latestChangeTargetOrdinal;
                String actionDescriptionTemplate = "Adding %s classification to %s %s";
                String actionDescription = String.format("Adding %s classification to %s %s", classificationTypeName, beanGUIDTypeName, beanGUID);
                String attachmentGUID = null;
                String attachmentTypeName = null;
                if (beanGUID.equals(anchorEntity.getGUID())) {
                    latestChangeTargetOrdinal = 2;
                } else {
                    latestChangeTargetOrdinal = 7;
                    attachmentGUID = beanGUID;
                    attachmentTypeName = beanGUIDTypeName;
                }
                this.addLatestChangeToAnchor(anchorEntity, latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationTypeName, attachmentGUID, attachmentTypeName, null, userId, actionDescription, methodName);
            }
        }
    }

    void removeClassificationFromRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.validateAnchorEntity(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, true, this.supportedZones, methodName);
        if (entity != null) {
            Classification existingClassification = null;
            List existingClassifications = entity.getClassifications();
            if (existingClassifications != null) {
                for (Classification classification : existingClassifications) {
                    if (classification == null || !classificationTypeName.equals(classification.getName())) continue;
                    existingClassification = classification;
                }
            }
            if (existingClassification != null) {
                this.repositoryHandler.declassifyEntity(userId, externalSourceGUID, externalSourceName, beanGUID, classificationTypeGUID, classificationTypeName, existingClassification, methodName);
            }
        }
    }

    private Asset getAssetBeanFromEntity(EntityDetail entity, String methodName) {
        if (entity != null && entity.getType() != null) {
            Asset assetBean = new Asset();
            String typeId = entity.getType().getTypeDefGUID();
            String typeName = entity.getType().getTypeDefName();
            InstanceStatus instanceStatus = entity.getStatus();
            String assetGUID = entity.getGUID();
            InstanceProperties entityProperties = entity.getProperties();
            InstanceProperties securityTagProperties = null;
            InstanceProperties confidentialityProperties = null;
            InstanceProperties confidenceProperties = null;
            InstanceProperties criticalityProperties = null;
            InstanceProperties retentionProperties = null;
            InstanceProperties ownershipProperties = null;
            InstanceProperties zoneProperties = null;
            InstanceProperties originProperties = null;
            if (entity.getClassifications() != null) {
                for (Classification classification : entity.getClassifications()) {
                    if (classification == null) continue;
                    if ("SecurityTags".equals(classification.getName())) {
                        securityTagProperties = classification.getProperties();
                        continue;
                    }
                    if ("Confidentiality".equals(classification.getName())) {
                        confidentialityProperties = classification.getProperties();
                        continue;
                    }
                    if ("Confidence".equals(classification.getName())) {
                        confidenceProperties = classification.getProperties();
                        continue;
                    }
                    if ("Criticality".equals(classification.getName())) {
                        criticalityProperties = classification.getProperties();
                        continue;
                    }
                    if ("Retention".equals(classification.getName())) {
                        retentionProperties = classification.getProperties();
                        continue;
                    }
                    if ("AssetOwnership".equals(classification.getName())) {
                        ownershipProperties = classification.getProperties();
                        continue;
                    }
                    if ("AssetZoneMembership".equals(classification.getName())) {
                        zoneProperties = classification.getProperties();
                        continue;
                    }
                    if (!"AssetOrigin".equals(classification.getName())) continue;
                    originProperties = classification.getProperties();
                }
            }
            this.setupAssetBeanWithEntityProperties(assetBean, typeId, typeName, instanceStatus, assetGUID, entityProperties, securityTagProperties, confidentialityProperties, confidenceProperties, criticalityProperties, retentionProperties, ownershipProperties, zoneProperties, originProperties, methodName);
            return assetBean;
        }
        return null;
    }

    private ReferenceableStatus getReferenceableStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            for (ReferenceableStatus referenceableStatus : ReferenceableStatus.values()) {
                if (referenceableStatus.getOMRSOrdinal() != instanceStatus.getOrdinal()) continue;
                return referenceableStatus;
            }
        }
        return ReferenceableStatus.UNKNOWN;
    }

    private void setupAssetBeanWithEntityProperties(Asset assetBean, String typeId, String typeName, InstanceStatus instanceStatus, String assetGUID, InstanceProperties entityProperties, InstanceProperties securityTagProperties, InstanceProperties confidentialityProperties, InstanceProperties confidenceProperties, InstanceProperties criticalityProperties, InstanceProperties retentionProperties, InstanceProperties ownershipProperties, InstanceProperties zoneProperties, InstanceProperties originProperties, String methodName) {
        ConfidentialityGovernanceClassification classification;
        assetBean.setTypeGUID(typeId);
        assetBean.setTypeName(typeName);
        assetBean.setStatus(this.getReferenceableStatus(instanceStatus));
        assetBean.setGUID(assetGUID);
        InstanceProperties properties = new InstanceProperties(entityProperties);
        assetBean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", properties, methodName));
        assetBean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", properties, methodName));
        assetBean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", properties, methodName));
        assetBean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", properties, methodName));
        assetBean.setOwner(this.repositoryHelper.removeStringProperty(this.serviceName, "owner", properties, methodName));
        assetBean.setOwnerType(this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "ownerType", properties, methodName));
        assetBean.setZoneMembership(this.repositoryHelper.removeStringArrayProperty(this.serviceName, "zoneMembership", properties, methodName));
        assetBean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(properties));
        if (securityTagProperties != null) {
            assetBean.setSecurityLabels(this.repositoryHelper.getStringArrayProperty(this.serviceName, "securityLabels", securityTagProperties, methodName));
            assetBean.setSecurityProperties(this.repositoryHelper.getMapFromProperty(this.serviceName, "securityProperties", securityTagProperties, methodName));
        }
        if (confidentialityProperties != null) {
            classification = new ConfidentialityGovernanceClassification();
            classification.setStatus(this.getGovernanceClassificationStatus(confidentialityProperties, methodName));
            classification.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", confidentialityProperties, methodName));
            classification.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", confidentialityProperties, methodName));
            classification.setSource(this.repositoryHelper.getStringProperty(this.serviceName, "source", confidentialityProperties, methodName));
            classification.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", confidentialityProperties, methodName));
            classification.setConfidentialityLevel(this.repositoryHelper.getIntProperty(this.serviceName, "level", confidentialityProperties, methodName));
        }
        if (confidenceProperties != null) {
            classification = new ConfidenceGovernanceClassification();
            classification.setStatus(this.getGovernanceClassificationStatus(confidenceProperties, methodName));
            classification.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", confidenceProperties, methodName));
            classification.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", confidenceProperties, methodName));
            classification.setSource(this.repositoryHelper.getStringProperty(this.serviceName, "source", confidenceProperties, methodName));
            classification.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", confidenceProperties, methodName));
            classification.setConfidenceLevel(this.repositoryHelper.getIntProperty(this.serviceName, "level", confidenceProperties, methodName));
        }
        if (criticalityProperties != null) {
            classification = new CriticalityGovernanceClassification();
            classification.setStatus(this.getGovernanceClassificationStatus(criticalityProperties, methodName));
            classification.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", criticalityProperties, methodName));
            classification.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", criticalityProperties, methodName));
            classification.setSource(this.repositoryHelper.getStringProperty(this.serviceName, "source", criticalityProperties, methodName));
            classification.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", criticalityProperties, methodName));
            classification.setCriticalityLevel(this.repositoryHelper.getIntProperty(this.serviceName, "level", criticalityProperties, methodName));
        }
        if (retentionProperties != null) {
            classification = new RetentionGovernanceClassification();
            classification.setStatus(this.getGovernanceClassificationStatus(confidenceProperties, methodName));
            classification.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", retentionProperties, methodName));
            classification.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", retentionProperties, methodName));
            classification.setSource(this.repositoryHelper.getStringProperty(this.serviceName, "source", retentionProperties, methodName));
            classification.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", retentionProperties, methodName));
            classification.setRetentionBasis(this.repositoryHelper.getIntProperty(this.serviceName, "basis", retentionProperties, methodName));
            classification.setAssociatedGUID(this.repositoryHelper.getStringProperty(this.serviceName, "associatedGUID", retentionProperties, methodName));
            classification.setArchiveAfter(this.repositoryHelper.getDateProperty(this.serviceName, "archiveAfter", retentionProperties, methodName));
            classification.setDeleteAfter(this.repositoryHelper.getDateProperty(this.serviceName, "deleteAfter", retentionProperties, methodName));
        }
        if (ownershipProperties != null) {
            assetBean.setOwner(this.repositoryHelper.getStringProperty(this.serviceName, "owner", ownershipProperties, methodName));
            assetBean.setOwnerType(this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "ownerType", ownershipProperties, methodName));
        }
        if (zoneProperties != null) {
            assetBean.setZoneMembership(this.repositoryHelper.getStringArrayProperty(this.serviceName, "zoneMembership", zoneProperties, methodName));
        }
        if (originProperties != null) {
            Map propertyMap;
            HashMap<String, String> origins = new HashMap<String, String>();
            String propertyValue = this.repositoryHelper.getStringProperty(this.serviceName, "organization", originProperties, methodName);
            if (propertyValue != null) {
                origins.put("organization", propertyValue);
            }
            if ((propertyValue = this.repositoryHelper.getStringProperty(this.serviceName, "businessCapability", originProperties, methodName)) != null) {
                origins.put("businessCapability", propertyValue);
            }
            if ((propertyMap = this.repositoryHelper.getStringMapFromProperty(this.serviceName, "otherOriginValues", originProperties, methodName)) != null) {
                for (String propertyName : propertyMap.keySet()) {
                    if (propertyName == null) continue;
                    origins.put(propertyName, (String)propertyMap.get(propertyName));
                }
            }
            if (!origins.isEmpty()) {
                assetBean.setOrigin(origins);
            }
        }
    }

    private GovernanceClassificationStatus getGovernanceClassificationStatus(InstanceProperties governanceClassificationProperties, String methodName) {
        int enumOrdinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "status", governanceClassificationProperties, methodName);
        if (enumOrdinal >= 0) {
            GovernanceClassificationStatus[] enums;
            for (GovernanceClassificationStatus status : enums = GovernanceClassificationStatus.values()) {
                if (status.getOpenTypeOrdinal() != enumOrdinal) continue;
                return status;
            }
        }
        return null;
    }

    private void validateUserForAssetRead(String userId, String assetGUID, String assetGUIDParameterName, EntityDetail assetEntity, List<String> suppliedSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, assetGUIDParameterName, suppliedSupportedZones, this.getSupportedZones(userId, suppliedSupportedZones, this.serviceName), this.serviceName, methodName);
        Asset assetBean = this.getAssetBeanFromEntity(assetEntity, methodName);
        this.securityVerifier.validateUserForAssetRead(userId, assetBean);
    }

    private void validateUserForAssetUpdate(String userId, EntityDetail originalAssetEntity, InstanceProperties updatedAssetProperties, InstanceStatus newInstanceStatus, String methodName) throws UserNotAuthorizedException {
        Asset originalAsset = this.getAssetBeanFromEntity(originalAssetEntity, methodName);
        AssetAuditHeader assetAuditHeader = new AssetAuditHeader();
        assetAuditHeader.setCreatedBy(originalAssetEntity.getCreatedBy());
        assetAuditHeader.setCreateTime(originalAssetEntity.getCreateTime());
        assetAuditHeader.setMaintainedBy(originalAssetEntity.getMaintainedBy());
        assetAuditHeader.setUpdatedBy(originalAssetEntity.getUpdatedBy());
        assetAuditHeader.setUpdateTime(originalAssetEntity.getUpdateTime());
        assetAuditHeader.setVersion(assetAuditHeader.getVersion());
        EntityDetail updatedAssetEntity = new EntityDetail(originalAssetEntity);
        updatedAssetEntity.setProperties(updatedAssetProperties);
        updatedAssetEntity.setStatus(newInstanceStatus);
        Asset updatedAsset = this.getAssetBeanFromEntity(updatedAssetEntity, methodName);
        this.securityVerifier.validateUserForAssetDetailUpdate(userId, originalAsset, assetAuditHeader, updatedAsset);
    }

    private void validateUserForAssetAttachment(String userId, String assetGUID, String assetGUIDParameterName, EntityDetail assetEntity, boolean isFeedback, boolean isUpdate, List<String> suppliedSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, assetGUIDParameterName, suppliedSupportedZones, this.getSupportedZones(userId, suppliedSupportedZones, this.serviceName), this.serviceName, methodName);
        Asset asset = this.getAssetBeanFromEntity(assetEntity, methodName);
        if (isUpdate) {
            if (isFeedback) {
                this.securityVerifier.validateUserForAssetFeedback(userId, asset);
            } else {
                this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            }
        } else {
            this.securityVerifier.validateUserForAssetRead(userId, asset);
        }
    }

    Connection getConnectionFromEntity(EntityDetail entity, String methodName) {
        if (entity != null && entity.getType() != null) {
            Connection connectionBean = new Connection();
            connectionBean.setTypeGUID(entity.getType().getTypeDefGUID());
            connectionBean.setTypeName(entity.getType().getTypeDefName());
            connectionBean.setGUID(entity.getGUID());
            InstanceProperties properties = new InstanceProperties(entity.getProperties());
            connectionBean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", properties, methodName));
            connectionBean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", properties, methodName));
            connectionBean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", properties, methodName));
            connectionBean.setUserId(this.repositoryHelper.removeStringProperty(this.serviceName, "userId", properties, methodName));
            connectionBean.setClearPassword(this.repositoryHelper.removeStringProperty(this.serviceName, "clearPassword", properties, methodName));
            connectionBean.setEncryptedPassword(this.repositoryHelper.removeStringProperty(this.serviceName, "encryptedPassword", properties, methodName));
            connectionBean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", properties, methodName));
            connectionBean.setConfigurationProperties(this.repositoryHelper.removeMapFromProperty(this.serviceName, "configurationProperties", properties, methodName));
            connectionBean.setSecuredProperties(this.repositoryHelper.removeMapFromProperty(this.serviceName, "securedProperties", properties, methodName));
            connectionBean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(properties));
            return connectionBean;
        }
        return null;
    }

    private void validateUserForConnection(String userId, EntityDetail entity, String methodName) throws UserNotAuthorizedException {
        Connection connectionBean = this.getConnectionFromEntity(entity, methodName);
        this.securityVerifier.validateUserForConnection(userId, connectionBean);
    }

    private boolean visibleToUserThroughRelationship(String userId, Relationship relationship, String methodName) {
        if (relationship == null) {
            return false;
        }
        String relationshipTypeName = null;
        if (relationship.getType() != null) {
            relationshipTypeName = relationship.getType().getTypeDefName();
        }
        if (relationshipTypeName == null) {
            return false;
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedLike") || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedTag") || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedRating") || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "AttachedComment")) {
            if (userId.equals(relationship.getCreatedBy())) {
                return true;
            }
            return this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", relationship.getProperties(), methodName);
        }
        return true;
    }

    String getAnchorGUIDFromAnchorsClassification(EntityDetail connectToEntity, String methodName) {
        String anchorGUID = null;
        try {
            Classification anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)connectToEntity, "Anchors", methodName);
            if (anchorsClassification != null && anchorsClassification.getProperties() != null) {
                anchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, "anchorGUID", anchorsClassification.getProperties(), methodName);
            }
        }
        catch (ClassificationErrorException classificationErrorException) {
            // empty catch block
        }
        return anchorGUID;
    }

    private void maintainAnchorGUIDInClassification(String targetGUID, EntitySummary targetEntity, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Classification anchorsClassification;
        InstanceProperties anchorsProperties = null;
        String currentAnchorGUID = null;
        try {
            anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, targetEntity, "Anchors", methodName);
            if (anchorsClassification != null && (anchorsProperties = anchorsClassification.getProperties()) != null) {
                currentAnchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, "anchorGUID", anchorsClassification.getProperties(), methodName);
            }
        }
        catch (ClassificationErrorException noAnchorsClassification) {
            anchorsClassification = null;
        }
        if (currentAnchorGUID == null && anchorGUID != null || currentAnchorGUID != null && !currentAnchorGUID.equals(anchorGUID)) {
            try {
                anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, "anchorGUID", anchorGUID, methodName);
                if (anchorsClassification == null) {
                    if (anchorGUID != null) {
                        this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, targetGUID, "aa44f302-2e43-4669-a1e7-edaae414fc6e", "Anchors", ClassificationOrigin.ASSIGNED, null, anchorsProperties, methodName);
                    }
                } else if (anchorGUID != null) {
                    this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, targetGUID, "aa44f302-2e43-4669-a1e7-edaae414fc6e", "Anchors", (InstanceAuditHeader)anchorsClassification, anchorsProperties, methodName);
                } else {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, "aa44f302-2e43-4669-a1e7-edaae414fc6e", "Anchors", (InstanceAuditHeader)anchorsClassification, methodName);
                }
            }
            catch (Exception error) {
                String typeName = "<null>";
                String typeGUID = "<null>";
                if (targetEntity.getType() != null) {
                    typeName = targetEntity.getType().getTypeDefName();
                    typeGUID = targetEntity.getType().getTypeDefGUID();
                }
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_SET_ANCHORS.getMessageDefinition(this.serviceName, targetGUID, typeName, typeGUID, methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.localServerUserId, targetGUID, targetEntity.getType().getTypeDefName(), null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null || relationship.getEntityOneProxy() == null || relationship.getEntityTwoProxy() == null) continue;
                String entityOneGUID = relationship.getEntityOneProxy().getGUID();
                String entityTwoGUID = relationship.getEntityTwoProxy().getGUID();
                switch (relationship.getType().getTypeDefGUID()) {
                    case "e777d660-8dbe-453e-8b83-903771f054c0": 
                    case "815b004d-73c6-4728-9dd9-536f4fe803cd": 
                    case "0d90501b-bf29-4621-a207-0c8c953bdac9": 
                    case "28ab0381-c662-4b6d-b787-5d77208de126": 
                    case "e2509715-a606-415d-a995-61d00503dad4": 
                    case "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344": 
                    case "86b176a2-015c-44a6-8106-54d5d69ba661": 
                    case "2d955049-e59b-45dd-8e62-cde1add59f9e": 
                    case "0ffb9d87-7074-45da-a9b0-ae0859611133": 
                    case "eb4f1f98-c649-4560-8a46-da17c02764a9": 
                    case "03737169-ceb5-45f0-84f0-21c5929945af": 
                    case "e8fb46d1-5f75-481b-aa66-f43ad44e2cc6": 
                    case "4ab3b466-31bd-48ea-8aa2-75623476f2e2": 
                    case "e8001de2-1bb1-442b-a66f-9addc3641eae": 
                    case "8b9856b3-451e-45fc-afc7-fddefd81a73a": 
                    case "6189d444-2da4-4cd7-9332-e48a1c340b44": 
                    case "4a316abe-eeee-4d11-ad5a-4bfb4079b80b": {
                        if (!entityOneGUID.equals(targetGUID)) break;
                        this.maintainAnchorGUIDInClassification(entityTwoGUID, (EntitySummary)relationship.getEntityTwoProxy(), anchorGUID, methodName);
                        break;
                    }
                    case "5cabb76a-e25b-4bb5-8b93-768bbac005af": 
                    case "111e6d2e-94e9-43ed-b4ed-f0d220668cbf": 
                    case "4f798c0c-6769-4a2d-b489-d2714d89e0a4": {
                        if (!entityOneGUID.equals(targetGUID)) break;
                        String proxyTwoGUIDParameterName = "proxyTwoGUID";
                        EntityDetail proxyTwoAnchor = this.validateAnchorEntity(this.localServerUserId, entityTwoGUID, "proxyTwoGUID", relationship.getEntityTwoProxy().getType().getTypeDefName(), true, null, methodName);
                        if (proxyTwoAnchor == null) break;
                        this.maintainAnchorGUIDInClassification(entityTwoGUID, (EntitySummary)relationship.getEntityTwoProxy(), anchorGUID, methodName);
                    }
                }
            }
        }
    }

    private String getAnchorGUIDForSchemaType(String userId, String schemaTypeGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return proxy.getGUID();
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "e8fb46d1-5f75-481b-aa66-f43ad44e2cc6", "APIHeader", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "4ab3b466-31bd-48ea-8aa2-75623476f2e2", "APIRequest", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "e8001de2-1bb1-442b-a66f-9addc3641eae", "APIResponse", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        return schemaTypeGUID;
    }

    private String getAnchorGUIDForSchemaAttribute(String userId, String attributeGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), methodName);
        }
        return null;
    }

    private String getAnchorGUIDForConnection(String userId, String connectionGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return proxy.getGUID();
        }
        return null;
    }

    private String getAnchorGUIDForLike(String userId, String likeGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, likeGUID, "Like", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return proxy.getGUID();
        }
        return null;
    }

    private String getAnchorGUIDForRating(String userId, String ratingGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, ratingGUID, "Rating", "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344", "AttachedRating", methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return proxy.getGUID();
        }
        return null;
    }

    private String getAnchorGUIDForOpenDiscoveryAnalysisReport(String userId, String ratingGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, ratingGUID, "OpenDiscoveryAnalysisReport", "7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return proxy.getGUID();
        }
        return null;
    }

    private String getAnchorGUIDForAnnotation(String userId, String annotationGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, annotationGUID, "Annotation", null, null, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null || annotationGUID.equals(proxy.getGUID())) continue;
                if (this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), "OpenDiscoveryAnalysisReport")) {
                    return this.getAnchorGUIDForOpenDiscoveryAnalysisReport(userId, proxy.getGUID(), methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), "DataField")) {
                    String parentAnchorGUID = this.getAnchorGUIDForDataField(userId, proxy.getGUID(), methodName);
                    if (parentAnchorGUID == null) continue;
                    return parentAnchorGUID;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), "Annotation")) continue;
                return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), methodName);
            }
        }
        return null;
    }

    private String getAnchorGUIDForAnnotationReview(String userId, String annotationReviewGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, annotationReviewGUID, "AnnotationReview", "5d3c2fb7-fa04-4d77-83cb-fd9216a07769", "AnnotationReview", methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), methodName);
        }
        return null;
    }

    private String getAnchorGUIDForDataField(String userId, String dataFieldGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, dataFieldGUID, "DataField", "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), methodName);
        }
        return null;
    }

    private String getAnchorGUIDForComment(String userId, String commentGUID, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, commentGUID, "Comment", "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                String parentAnchorGUID;
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                if (!commentGUID.equals(proxy.getGUID()) && this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), "Comment") && (parentAnchorGUID = this.getAnchorGUIDForComment(userId, proxy.getGUID(), methodName)) != null) {
                    return parentAnchorGUID;
                }
                return proxy.getGUID();
            }
        }
        return null;
    }

    private String deriveAnchorGUID(String targetGUID, String targetTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String anchorGUID = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "SchemaType")) {
            anchorGUID = this.getAnchorGUIDForSchemaType(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "SchemaAttribute")) {
            anchorGUID = this.getAnchorGUIDForSchemaAttribute(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Connection")) {
            anchorGUID = this.getAnchorGUIDForConnection(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Comment")) {
            anchorGUID = this.getAnchorGUIDForComment(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Rating")) {
            anchorGUID = this.getAnchorGUIDForRating(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Like")) {
            anchorGUID = this.getAnchorGUIDForLike(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "OpenDiscoveryAnalysisReport")) {
            anchorGUID = this.getAnchorGUIDForOpenDiscoveryAnalysisReport(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "Annotation")) {
            anchorGUID = this.getAnchorGUIDForAnnotation(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "AnnotationReview")) {
            anchorGUID = this.getAnchorGUIDForAnnotationReview(this.localServerUserId, targetGUID, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "DataField")) {
            anchorGUID = this.getAnchorGUIDForDataField(this.localServerUserId, targetGUID, methodName);
        }
        return anchorGUID;
    }

    private void reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, String originalAnchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail targetElement;
        String newAnchorGUID = this.deriveAnchorGUID(targetGUID, targetTypeName, methodName);
        if ((newAnchorGUID == null && originalAnchorGUID != null || newAnchorGUID != null && !newAnchorGUID.equals(originalAnchorGUID)) && (targetElement = this.repositoryHandler.getEntityByGUID(this.localServerUserId, targetGUID, targetGUIDParameterName, targetTypeName, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(targetGUID, (EntitySummary)targetElement, newAnchorGUID, methodName);
        }
    }

    public EntityDetail validateAnchorEntity(String userId, String connectToGUID, String connectToGUIDParameterName, String connectToType, boolean isUpdate, List<String> suppliedSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectToGUID, connectToGUIDParameterName, methodName);
        EntityDetail connectToEntity = this.repositoryHandler.getEntityByGUID(userId, connectToGUID, connectToGUIDParameterName, connectToType, methodName);
        return this.validateAnchorEntity(userId, connectToGUID, connectToType, connectToEntity, connectToGUIDParameterName, isUpdate, suppliedSupportedZones, methodName);
    }

    public EntityDetail validateAnchorEntity(String userId, String connectToGUID, String connectToType, EntityDetail connectToEntity, String connectToGUIDParameterName, boolean isUpdate, List<String> suppliedSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceType anchorEntityType;
        String anchorGUID;
        this.invalidParameterHandler.validateObject((Object)connectToEntity, connectToGUIDParameterName, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "InformalTag")) {
            if (!this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", connectToEntity.getProperties(), methodName) && !userId.equals(connectToEntity.getCreatedBy())) {
                this.invalidParameterHandler.throwUnknownElement(userId, connectToGUID, connectToType, this.serviceName, this.serverName, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Connection")) {
            this.validateUserForConnection(userId, connectToEntity, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Asset")) {
            this.validateUserForAssetRead(userId, connectToGUID, connectToGUIDParameterName, connectToEntity, suppliedSupportedZones, methodName);
            return connectToEntity;
        }
        EntityDetail anchorEntity = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Referenceable")) {
            anchorEntity = connectToEntity;
        }
        if ((anchorGUID = this.getAnchorGUIDFromAnchorsClassification(connectToEntity, methodName)) == null && (anchorGUID = this.deriveAnchorGUID(connectToGUID, connectToEntity.getType().getTypeDefName(), methodName)) != null) {
            this.maintainAnchorGUIDInClassification(connectToGUID, (EntitySummary)connectToEntity, anchorGUID, methodName);
        }
        if (anchorGUID != null) {
            String anchorGUIDParameterName = "anchorGUID";
            anchorEntity = this.repositoryHandler.getEntityByGUID(userId, anchorGUID, "anchorGUID", "Referenceable", methodName);
        }
        if (anchorEntity != null && (anchorEntityType = anchorEntity.getType()) != null && "Asset".equals(anchorEntityType.getTypeDefName())) {
            boolean isFeedbackEntity = false;
            if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "InformalTag") || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Comment") || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Rating") || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, "Like")) {
                isFeedbackEntity = true;
            }
            this.validateUserForAssetAttachment(userId, connectToGUID, connectToGUIDParameterName, anchorEntity, isFeedbackEntity, isUpdate, suppliedSupportedZones, methodName);
        }
        return anchorEntity;
    }

    private void validateNewEntityRequest(String userId, String entityTypeGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, OpenMetadataAPIGenericBuilder newObjectBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (uniqueParameterValue != null) {
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.add(uniqueParameterName);
            List<B> existingBeans = this.getBeansByValue(userId, uniqueParameterValue, uniqueParameterName, entityTypeGUID, entityTypeName, propertyNames, true, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            if (existingBeans != null && !existingBeans.isEmpty()) {
                this.invalidParameterHandler.throwUniqueNameInUse(uniqueParameterValue, uniqueParameterName, entityTypeName, this.serviceName, methodName);
            }
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "Asset")) {
            Asset assetBeanForMetadataSecurity = new Asset();
            this.setupAssetBeanWithEntityProperties(assetBeanForMetadataSecurity, entityTypeGUID, entityTypeName, newObjectBuilder.getInstanceStatus(), null, newObjectBuilder.getInstanceProperties(methodName), newObjectBuilder.getEntityClassificationProperties("SecurityTags", methodName), newObjectBuilder.getEntityClassificationProperties("Confidentiality", methodName), newObjectBuilder.getEntityClassificationProperties("Confidence", methodName), newObjectBuilder.getEntityClassificationProperties("Criticality", methodName), newObjectBuilder.getEntityClassificationProperties("Retention", methodName), newObjectBuilder.getEntityClassificationProperties("AssetOwnership", methodName), newObjectBuilder.getEntityClassificationProperties("AssetZoneMembership", methodName), newObjectBuilder.getEntityClassificationProperties("AssetOrigin", methodName), methodName);
            assetBeanForMetadataSecurity.setZoneMembership(this.securityVerifier.setAssetZonesToDefault(this.defaultZones, assetBeanForMetadataSecurity));
            this.securityVerifier.validateUserForAssetCreate(userId, assetBeanForMetadataSecurity);
        }
    }

    private InstanceProperties getLatestChangeClassificationProperties(int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, String methodName) throws TypeErrorException {
        InstanceProperties properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "changeTarget", "a0b7d7a0-4af5-4539-9b81-cbef52d8cc5d", "LatestChangeTarget", latestChangeTargetOrdinal, methodName);
        properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "changeAction", "032d844b-868f-4c4a-bc5d-81f0f9704c4d", "LatestChangeAction", latestChangeActionOrdinal, methodName);
        if (classificationName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "classificationName", classificationName, methodName);
        }
        if (attachmentGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "attachmentGUID", attachmentGUID, methodName);
        }
        if (attachmentTypeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "attachmentType", attachmentTypeName, methodName);
        }
        if (attachmentTypeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "relationshipType", relationshipTypeName, methodName);
        }
        if (userId != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "user", userId, methodName);
        }
        if (actionDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", actionDescription, methodName);
        }
        return properties;
    }

    private void addLatestChangeToAnchor(EntityDetail anchorEntity, int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "anchorEntity.getGUID()";
        InstanceProperties newProperties = null;
        try {
            this.invalidParameterHandler.validateObject((Object)anchorEntity, "anchorEntity.getGUID()", methodName);
            newProperties = this.getLatestChangeClassificationProperties(latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationName, attachmentGUID, attachmentTypeName, relationshipTypeName, userId, actionDescription, methodName);
            Classification classification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)anchorEntity, "LatestChange", methodName);
            if (classification != null) {
                this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, anchorEntity.getGUID(), "adce83ac-10f1-4279-8a35-346976e94466", "LatestChange", (InstanceAuditHeader)classification, newProperties, methodName);
            }
        }
        catch (ClassificationErrorException newClassificationNeeded) {
            this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, anchorEntity.getGUID(), "adce83ac-10f1-4279-8a35-346976e94466", "LatestChange", ClassificationOrigin.ASSIGNED, null, newProperties, methodName);
        }
        catch (InvalidParameterException | TypeErrorException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
    }

    public int countAttachments(String userId, String elementGUID, String elementTypeName, String attachmentTypeGUID, String attachmentTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        int count = 0;
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, elementGUID, elementTypeName, attachmentTypeGUID, attachmentTypeName, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
            ++count;
        }
        return count;
    }

    public EntityDetail getAttachedEntity(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntity(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, this.supportedZones, methodName);
    }

    public EntityDetail getAttachedEntity(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, startingElementGUID, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (entity != null) {
            this.validateAnchorEntity(userId, startingElementGUID, startingElementTypeName, entity, startingElementGUIDParameterName, false, serviceSupportedZones, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, entity.getType().getTypeDefName(), resultingElementTypeName)) {
                return entity;
            }
        }
        return null;
    }

    public List<EntityDetail> getAttachedEntities(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntities(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, null, null, this.supportedZones, startingFrom, pageSize, methodName);
    }

    public List<EntityDetail> getAttachedEntities(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, false, serviceSupportedZones, methodName);
        List<Relationship> visibleRelationships = this.getAttachmentLinks(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, startingFrom, pageSize, methodName);
        if (visibleRelationships != null) {
            ArrayList<EntityDetail> visibleEntities = new ArrayList<EntityDetail>();
            for (Relationship relationship : visibleRelationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = this.repositoryHandler.getOtherEnd(startingElementGUID, startingElementTypeName, relationship, methodName)) == null || entityProxy.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, entityProxy.getType().getTypeDefName(), resultingElementTypeName)) continue;
                try {
                    String guidParameterName = "entityProxy.getGUID()";
                    visibleEntities.add(this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxy.getGUID()", resultingElementTypeName, requiredClassificationName, omittedClassificationName, this.supportedZones, methodName));
                }
                catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                    log.debug("Skipping inaccessible entity", inaccessibleEntity);
                }
            }
            if (!visibleEntities.isEmpty()) {
                return visibleEntities;
            }
        }
        return null;
    }

    public Relationship getUniqueAttachmentLink(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        if (relationships.size() == 1) {
            return relationships.get(0);
        }
        this.errorHandler.handleAmbiguousRelationships(startingGUID, startingTypeName, attachmentRelationshipTypeName, relationships, methodName);
        return null;
    }

    public List<Relationship> getAllAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, null, null, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, null, attachmentEntityTypeName, startingFrom, pageSize, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, startingGUID, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, startingFrom, queryPageSize, methodName);
        ArrayList<Relationship> visibleRelationships = new ArrayList<Relationship>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || visibleRelationships.size() < queryPageSize)) {
            Relationship relationship = iterator.getNext();
            if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
            if (attachmentEntityTypeName != null) {
                EntityProxy otherEnd = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, methodName);
                if (otherEnd == null || otherEnd.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, otherEnd.getType().getTypeDefName(), attachmentEntityTypeName) || attachmentEntityGUID != null && !attachmentEntityGUID.equals(otherEnd.getGUID())) continue;
                visibleRelationships.add(relationship);
                continue;
            }
            visibleRelationships.add(relationship);
        }
        if (!visibleRelationships.isEmpty()) {
            return visibleRelationships;
        }
        return null;
    }

    public String createBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityTypeGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, OpenMetadataAPIGenericBuilder propertyBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.validateNewEntityRequest(userId, entityTypeGUID, entityTypeName, uniqueParameterValue, uniqueParameterName, propertyBuilder, methodName);
        return this.repositoryHandler.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(userId, methodName), propertyBuilder.getInstanceStatus(), methodName);
    }

    public String createBeanFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String entityTypeGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, OpenMetadataAPIGenericBuilder propertyBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String newEntityParameterName = "newEntityGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        EntityDetail templateEntity = this.repositoryHandler.getEntityByGUID(userId, templateGUID, templateGUIDParameterName, entityTypeName, methodName);
        if (templateEntity != null) {
            EntityDetail templateAnchorEntity = this.validateAnchorEntity(userId, templateGUID, entityTypeName, templateEntity, templateGUIDParameterName, false, this.supportedZones, methodName);
            this.validateNewEntityRequest(userId, entityTypeGUID, entityTypeName, uniqueParameterValue, uniqueParameterName, propertyBuilder, methodName);
            String newEntityGUID = this.repositoryHandler.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(userId, methodName), propertyBuilder.getInstanceStatus(), methodName);
            this.repositoryHandler.createRelationship(this.localServerUserId, "87b7371e-e311-460f-8849-08646d0d6ad3", externalSourceGUID, externalSourceName, newEntityGUID, templateGUID, null, methodName);
            this.addAttachmentsFromTemplate(userId, externalSourceGUID, externalSourceName, newEntityGUID, "newEntityGUID", templateGUID, templateAnchorEntity.getGUID(), entityTypeName, uniqueParameterValue, methodName);
            return newEntityGUID;
        }
        return null;
    }

    private void addAttachmentsFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String templateGUID, String templateAnchorGUID, String expectedTypeName, String qualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nextTemplateEntityGUIDParameterName = "nextTemplateEntity.getGUID";
        String nextQualifiedNameParameterName = "nextQualifiedName";
        String nextBeanEntityGUIDParameterName = "nextBeanEntityGUID";
        HashMap<String, Integer> qualifiedNameUsageCount = new HashMap<String, Integer>();
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, templateGUID, expectedTypeName, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        while (iterator.moreToReceive()) {
            String nextBeanEntityGUID;
            EntityDetail nextTemplateEntity;
            Relationship relationship = iterator.getNext();
            EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, expectedTypeName, relationship, methodName);
            if (entityProxy == null || entityProxy.getType() == null || (nextTemplateEntity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "nextTemplateEntity.getGUID", expectedTypeName, methodName)) == null || nextTemplateEntity.getType() == null) continue;
            String nextTemplateEntityTypeGUID = nextTemplateEntity.getType().getTypeDefGUID();
            String nextTemplateEntityTypeName = nextTemplateEntity.getType().getTypeDefName();
            EntityDetail nextTemplateEntityAnchor = this.validateAnchorEntity(userId, nextTemplateEntity.getGUID(), expectedTypeName, nextTemplateEntity, "nextTemplateEntity.getGUID", false, this.supportedZones, methodName);
            if (nextTemplateEntityAnchor == null || !templateAnchorGUID.equals(nextTemplateEntityAnchor.getGUID())) {
                nextBeanEntityGUID = nextTemplateEntity.getGUID();
            } else {
                OpenMetadataAPIGenericBuilder builder;
                String nextQualifiedName = null;
                if (this.repositoryHelper.isTypeOf(this.serviceName, nextTemplateEntityTypeName, "Referenceable")) {
                    nextQualifiedName = qualifiedName + "::" + nextTemplateEntityTypeName;
                    int nextQualifiedNameCount = (Integer)qualifiedNameUsageCount.get(nextQualifiedName);
                    qualifiedNameUsageCount.put(nextQualifiedName, nextQualifiedNameCount + 1);
                    if (nextQualifiedNameCount > 0) {
                        nextQualifiedName = nextQualifiedName + "_" + nextQualifiedNameCount;
                    }
                    builder = new ReferenceableBuilder(nextQualifiedName, null, nextTemplateEntityTypeGUID, nextTemplateEntityTypeName, null, nextTemplateEntity.getStatus(), this.repositoryHelper, this.serviceName, this.serverName);
                } else {
                    builder = new OpenMetadataAPIGenericBuilder(nextTemplateEntityTypeGUID, nextTemplateEntityTypeName, null, nextTemplateEntity.getStatus(), null, this.repositoryHelper, this.serviceName, this.serverName);
                }
                builder.setTemplateProperties(nextTemplateEntity.getProperties());
                builder.setTemplateClassifications(userId, externalSourceGUID, externalSourceName, nextTemplateEntity.getClassifications(), methodName);
                nextBeanEntityGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, nextTemplateEntity.getGUID(), "nextTemplateEntity.getGUID", nextTemplateEntity.getType().getTypeDefGUID(), nextTemplateEntityTypeName, nextQualifiedName, "nextQualifiedName", builder, methodName);
            }
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, expectedTypeName, nextBeanEntityGUID, "nextBeanEntityGUID", nextTemplateEntityTypeName, this.supportedZones, relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getProperties(), methodName);
        }
    }

    public void updateBeanPropertyInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String propertyName, String propertyValue, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyParameterName = "propertyValue";
        String propertyNameParameterName = "propertyName";
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        this.invalidParameterHandler.validateObject((Object)propertyValue, "propertyValue", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, propertyName, propertyValue, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, this.supportedZones, properties, true, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, InstanceProperties properties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, this.supportedZones, properties, isMergeUpdate, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, List<String> serviceSupportedZones, InstanceProperties updateProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail originalEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            InstanceProperties newProperties;
            EntityDetail anchorEntity = this.validateAnchorEntity(userId, entityGUID, entityTypeName, originalEntity, entityGUIDParameterName, true, serviceSupportedZones, methodName);
            if (isMergeUpdate) {
                newProperties = originalEntity.getProperties();
                if (newProperties == null) {
                    newProperties = updateProperties;
                } else if (updateProperties != null) {
                    Map propertyMap = updateProperties.getInstanceProperties();
                    for (String propertyName : propertyMap.keySet()) {
                        if (propertyName == null) continue;
                        newProperties.setProperty(propertyName, (InstancePropertyValue)propertyMap.get(propertyName));
                    }
                }
            } else {
                newProperties = updateProperties;
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), "Asset")) {
                this.validateUserForAssetUpdate(userId, originalEntity, newProperties, originalEntity.getStatus(), methodName);
            }
            this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, entityGUID, originalEntity, entityTypeGUID, entityTypeName, newProperties, methodName);
            if (anchorEntity != null) {
                String actionDescriptionTemplate = "Updating updateProperties in %s %s";
                String actionDescription = String.format("Updating updateProperties in %s %s", entityTypeName, entityGUID);
                int latestChangeTargetOrdinal = 6;
                String attachmentGUID = entityGUID;
                String attachmentTypeName = entityTypeName;
                if (entityGUID.equals(anchorEntity.getGUID())) {
                    latestChangeTargetOrdinal = 1;
                    attachmentGUID = null;
                    attachmentTypeName = null;
                }
                this.addLatestChangeToAnchor(anchorEntity, latestChangeTargetOrdinal, 1, null, attachmentGUID, attachmentTypeName, null, userId, actionDescription, methodName);
            }
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
    }

    public void updateBeanStatusInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, List<String> serviceSupportedZones, InstanceStatus newStatus, String newStatusParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)newStatus, newStatusParameterName, methodName);
        EntityDetail originalEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateAnchorEntity(userId, entityGUID, entityTypeName, originalEntity, entityGUIDParameterName, true, serviceSupportedZones, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), "Asset")) {
                this.validateUserForAssetUpdate(userId, originalEntity, originalEntity.getProperties(), newStatus, methodName);
            }
            this.repositoryHandler.updateEntityStatus(userId, externalSourceGUID, externalSourceName, entityGUID, entityTypeGUID, entityTypeName, newStatus, methodName);
            if (anchorEntity != null) {
                String actionDescriptionTemplate = "Updating newStatus in %s %s";
                String actionDescription = String.format("Updating newStatus in %s %s", entityTypeName, entityGUID);
                int latestChangeTargetOrdinal = 5;
                String attachmentGUID = entityGUID;
                String attachmentTypeName = entityTypeName;
                if (entityGUID.equals(anchorEntity.getGUID())) {
                    latestChangeTargetOrdinal = 0;
                    attachmentGUID = null;
                    attachmentTypeName = null;
                }
                this.addLatestChangeToAnchor(anchorEntity, latestChangeTargetOrdinal, 1, null, attachmentGUID, attachmentTypeName, null, userId, actionDescription, methodName);
            }
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
    }

    private void deleteAnchoredEntity(EntityDetail anchorEntity, EntityProxy potentialAnchoredEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchorEntity != null) {
            EntityDetail entity;
            String anchorGUID;
            String guidParameterName = "potentialAnchoredEntity";
            if (potentialAnchoredEntity != null && potentialAnchoredEntity.getType() != null && (anchorGUID = this.getAnchorGUIDFromAnchorsClassification(entity = this.repositoryHandler.getEntityByGUID(this.localServerUserId, potentialAnchoredEntity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefName(), methodName), methodName)) != null && anchorGUID.equals(anchorEntity.getGUID())) {
                String externalSourceGUID = null;
                String externalSourceName = null;
                if (entity.getInstanceProvenanceType() != InstanceProvenanceType.LOCAL_COHORT) {
                    externalSourceGUID = entity.getMetadataCollectionId();
                    externalSourceName = entity.getMetadataCollectionName();
                }
                this.deleteBeanInRepository(this.localServerUserId, externalSourceGUID, externalSourceName, entity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefGUID(), potentialAnchoredEntity.getType().getTypeDefName(), null, null, anchorEntity, methodName);
            }
        }
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, this.supportedZones, methodName);
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, entityGUID, entityGUIDParameterName, entityTypeName, false, serviceSupportedZones, methodName);
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, anchorEntity, methodName);
    }

    private void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, EntityDetail anchorEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, entityGUID, entityTypeName, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            this.deleteAnchoredEntity(anchorEntity, this.repositoryHandler.getOtherEnd(entityGUID, entityTypeName, relationship, methodName), methodName);
        }
        this.repositoryHandler.removeEntity(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, methodName);
        if (anchorEntity != null && !entityGUID.equals(anchorEntity.getGUID())) {
            String actionDescriptionTemplate = "Deleting %s %s";
            String actionDescription = String.format("Deleting %s %s", entityTypeName, entityGUID);
            int latestChangeTarget = 4;
            this.addLatestChangeToAnchor(anchorEntity, latestChangeTarget, 2, null, entityGUID, entityTypeName, null, userId, actionDescription, methodName);
        }
    }

    List<String> getRelatedEntityGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> relationshipPath, String relatedEntityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getRelatedEntityGUIDs(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationshipPath, relatedEntityTypeName, this.supportedZones, startingFrom, pageSize, methodName);
    }

    List<String> getRelatedEntityGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> relationshipPath, String relatedEntityTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<String> getAttachedElementGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUIDs(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, this.supportedZones, startingFrom, pageSize, methodName);
    }

    public List<String> getAttachedElementGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingTypeName, false, serviceSupportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, startingFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Relationship relationship : relationships) {
            EntityProxy entityProxy;
            if (relationship == null || (entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, methodName)) == null) continue;
            try {
                this.validateAnchorEntity(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, false, serviceSupportedZones, methodName);
                results.add(entityProxy.getGUID());
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException nonAccessibleEntity) {
                log.debug("Skipping entity", nonAccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public String getAttachedElementGUID(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int selectionEnd, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, selectionEnd, this.supportedZones, methodName);
    }

    public String getAttachedElementGUID(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int selectionEnd, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingTypeName, false, serviceSupportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        String result = null;
        for (Relationship relationship : relationships) {
            if (relationship == null) continue;
            EntityProxy entityProxy = null;
            if (selectionEnd == 0) {
                entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, methodName);
            } else if (selectionEnd == 1) {
                entityProxy = relationship.getEntityOneProxy();
            } else if (selectionEnd == 2) {
                entityProxy = relationship.getEntityTwoProxy();
            }
            if (entityProxy == null) continue;
            try {
                this.validateAnchorEntity(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, false, serviceSupportedZones, methodName);
                if (result == null) {
                    result = entityProxy.getGUID();
                    continue;
                }
                this.errorHandler.handleAmbiguousRelationships(startingGUID, startingTypeName, attachmentRelationshipTypeName, relationships, methodName);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException nonAccessibleEntity) {
                log.debug("Skipping entity", nonAccessibleEntity);
            }
        }
        return result;
    }

    public B getAttachedElement(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElement(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, this.supportedZones, methodName);
    }

    public B getAttachedElement(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, startingElementGUID, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (entity != null) {
            this.validateAnchorEntity(userId, startingElementGUID, startingElementTypeName, entity, startingElementGUIDParameterName, false, serviceSupportedZones, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, entity.getType().getTypeDefName(), resultingElementTypeName)) {
                return this.converter.getNewBean(this.beanClass, entity, methodName);
            }
        }
        return null;
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, null, null, 0, this.supportedZones, startingFrom, pageSize, methodName);
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, null, null, 0, serviceSupportedZones, startingFrom, pageSize, methodName);
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, this.supportedZones, startingFrom, pageSize, methodName);
    }

    public List<B> getAttachedElements(String userId, String anchorGUID, String anchorGUIDParameterName, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingTypeName, false, serviceSupportedZones, methodName);
        this.invalidParameterHandler.validateAnchorGUID(anchorGUID, anchorGUIDParameterName, anchorEntity, startingGUID, startingTypeName, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, startingFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<B> results = new ArrayList<B>();
        for (Relationship relationship : relationships) {
            if (relationship == null) continue;
            try {
                B bean = this.getAttachedElement(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationship, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, serviceSupportedZones, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                log.debug("Skipping inaccessible entity", inaccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getAnchorsForAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingTypeName, false, serviceSupportedZones, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, startingFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<B> results = new ArrayList<B>();
        for (Relationship relationship : relationships) {
            if (relationship == null) continue;
            try {
                B bean = this.getAttachedElement(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationship, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, serviceSupportedZones, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                log.debug("Skipping inaccessible entity", inaccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private B getAttachedElement(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, Relationship relationship, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        if (relationship != null) {
            EntityProxy entityProxy = null;
            if (selectionEnd == 0) {
                entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, methodName);
            } else if (selectionEnd == 1) {
                entityProxy = relationship.getEntityOneProxy();
            } else if (selectionEnd == 2) {
                entityProxy = relationship.getEntityTwoProxy();
            }
            if (entityProxy != null) {
                EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, methodName);
                this.validateAnchorEntity(userId, entityProxy.getGUID(), attachmentEntityTypeName, entity, "relationship.end.guid", false, serviceSupportedZones, methodName);
                boolean beanValid = true;
                if (requiredClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, requiredClassificationName, methodName) == null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException error) {
                        beanValid = false;
                    }
                }
                if (omittedClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, omittedClassificationName, methodName) != null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException classificationErrorException) {
                        // empty catch block
                    }
                }
                if (beanValid) {
                    return this.converter.getNewBean(this.beanClass, entity, relationship, methodName);
                }
            }
        }
        return null;
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityFromRepository(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, null, null, this.supportedZones, methodName);
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityFromRepository(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, requiredClassificationName, omittedClassificationName, this.supportedZones, methodName);
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(requestedEntityGUID, requestedEntityGUIDParameterName, methodName);
        EntityDetail retrievedEntity = this.repositoryHandler.getEntityByGUID(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, methodName);
        this.validateAnchorEntity(userId, requestedEntityGUID, requestedEntityTypeName, retrievedEntity, requestedEntityGUIDParameterName, false, serviceSupportedZones, methodName);
        boolean beanValid = true;
        if (requiredClassificationName != null) {
            try {
                if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, requiredClassificationName, methodName) == null) {
                    beanValid = false;
                }
            }
            catch (ClassificationErrorException error) {
                beanValid = false;
            }
        }
        if (omittedClassificationName != null) {
            try {
                if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, omittedClassificationName, methodName) != null) {
                    beanValid = false;
                }
            }
            catch (ClassificationErrorException classificationErrorException) {
                // empty catch block
            }
        }
        if (!beanValid) {
            return null;
        }
        return retrievedEntity;
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String resultTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, resultTypeName, this.supportedZones, methodName);
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String entityTypeName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, entityTypeName, null, null, serviceSupportedZones, methodName);
        if (entity != null) {
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    String getBeanStringPropertyFromRepository(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String propertyName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanStringPropertyFromRepository(userId, entityGUID, entityGUIDParameterName, entityTypeName, propertyName, this.supportedZones, methodName);
    }

    String getBeanStringPropertyFromRepository(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String propertyName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyNameParameter = "propertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        String property = null;
        EntityDetail entityDetail = this.getEntityFromRepository(userId, entityGUID, entityGUIDParameterName, entityTypeName, null, null, serviceSupportedZones, methodName);
        if (entityDetail != null) {
            property = this.repositoryHelper.getStringProperty(this.serviceName, propertyName, entityDetail.getProperties(), methodName);
        }
        return property;
    }

    private InstanceProperties getSearchInstanceProperties(String searchValue, List<String> specificMatchPropertyNames, String methodName) {
        InstanceProperties properties = new InstanceProperties();
        for (String propertyName : specificMatchPropertyNames) {
            if (propertyName == null) continue;
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, propertyName, searchValue, methodName);
        }
        return properties;
    }

    private RepositoryIteratorForEntities getEntitySearchIterator(String userId, String searchString, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, int startFrom, int queryPageSize, String methodName) {
        RepositoryEntitiesIterator iterator;
        if (searchString != null) {
            String searchValue = searchString;
            if (exactValueMatch) {
                searchValue = this.repositoryHelper.getExactMatchRegex(searchString);
            }
            iterator = specificMatchPropertyNames == null || specificMatchPropertyNames.isEmpty() ? new RepositorySelectedEntitiesIterator(this.repositoryHandler, userId, resultTypeGUID, searchValue, startFrom, queryPageSize, methodName) : new RepositorySelectedEntitiesIterator(this.repositoryHandler, userId, resultTypeGUID, this.getSearchInstanceProperties(searchValue, specificMatchPropertyNames, methodName), MatchCriteria.ANY, startFrom, queryPageSize, methodName);
        } else {
            iterator = new RepositoryEntitiesIterator(this.repositoryHandler, userId, resultTypeGUID, resultTypeName, startFrom, queryPageSize, methodName);
        }
        return iterator;
    }

    public String getBeanGUIDByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(namePropertyName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, name, resultTypeGUID, resultTypeName, propertyNames, true, 0, queryPageSize, methodName);
        String guid = null;
        ArrayList<String> duplicateEntities = new ArrayList<String>();
        String entityParameterName = "Entity from search of value " + name;
        while (iterator.moreToReceive() && (queryPageSize == 0 || duplicateEntities.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            duplicateEntities.add(entity.getGUID());
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                if (guid != null) continue;
                guid = entity.getGUID();
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (guid == null) {
            return null;
        }
        if (duplicateEntities.size() == 1) {
            return guid;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(resultTypeName, name, ((Object)duplicateEntities).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public B getBeanByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanByUniqueName(userId, name, nameParameterName, namePropertyName, resultTypeGUID, resultTypeName, this.supportedZones, methodName);
    }

    public B getBeanByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(namePropertyName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, name, resultTypeGUID, resultTypeName, propertyNames, true, 0, queryPageSize, methodName);
        B bean = null;
        ArrayList<String> duplicateEntities = new ArrayList<String>();
        String entityParameterName = "Entity from search of value " + name;
        while (iterator.moreToReceive() && (queryPageSize == 0 || duplicateEntities.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            duplicateEntities.add(entity.getGUID());
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                if (bean != null) continue;
                bean = this.converter.getNewBean(this.beanClass, entity, methodName);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (bean == null) {
            return null;
        }
        if (duplicateEntities.size() == 1) {
            return bean;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(resultTypeName, name, ((Object)duplicateEntities).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public B getBeanByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return this.converter.getNewBean(this.beanClass, results.get(0), methodName);
        }
        this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
        return null;
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, null, null, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, serviceSupportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, null, null, serviceSupportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(value, valueParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, value, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, startFrom, queryPageSize, methodName);
        ArrayList<B> results = new ArrayList<B>();
        String entityParameterName = "Entity from search of value " + value;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            try {
                B bean;
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                boolean beanValid = true;
                if (requiredClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, requiredClassificationName, methodName) == null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException error) {
                        beanValid = false;
                    }
                }
                if (omittedClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, omittedClassificationName, methodName) != null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException error) {
                        // empty catch block
                    }
                }
                if (!beanValid || (bean = this.converter.getNewBean(this.beanClass, entity, methodName)) == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> getEntitiesByType(String userId, String resultTypeGUID, String resultTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, null, resultTypeGUID, resultTypeName, null, false, startFrom, queryPageSize, methodName);
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        String entityParameterName = "Entity of type" + resultTypeName;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                results.add(entity);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> findEntities(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        return this.getEntitiesByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(value, valueParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, value, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, startFrom, queryPageSize, methodName);
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        String entityParameterName = "Entity from search of value " + value;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            boolean beanValid;
            EntityDetail entity;
            block11: {
                entity = iterator.getNext();
                if (entity == null) continue;
                beanValid = true;
                try {
                    this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                    if (requiredClassificationName != null) {
                        try {
                            if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, requiredClassificationName, methodName) == null) {
                                beanValid = false;
                            }
                        }
                        catch (ClassificationErrorException error) {
                            beanValid = false;
                        }
                    }
                    if (omittedClassificationName == null) break block11;
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, omittedClassificationName, methodName) != null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException error) {
                        beanValid = true;
                    }
                }
                catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException invisibleEntity) {
                    beanValid = false;
                }
            }
            if (!beanValid) continue;
            results.add(entity);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public EntityDetail getEntityByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (results != null && results.size() == 1) {
            return results.get(0);
        }
        this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
        return null;
    }

    public String getEntityGUIDByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (results != null && results.size() == 1) {
            EntityDetail entity = results.get(0);
            if (entity != null) {
                return entity.getGUID();
            }
        } else {
            this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
        }
        return null;
    }

    public List<String> findBeanGUIDs(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDsByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<String> getBeanGUIDsByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(value, valueParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, value, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, startFrom, queryPageSize, methodName);
        ArrayList<String> results = new ArrayList<String>();
        String entityParameterName = "Entity from search of value " + value;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                results.add(entity.getGUID());
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getBeansByCreator(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(searchString, searchStringParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, searchString, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, startFrom, queryPageSize, methodName);
        ArrayList<B> results = new ArrayList<B>();
        String entityParameterName = "Entity from createdBy search of " + searchString;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null || !userId.equals(entity.getCreatedBy())) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                B bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getBeansByType(String userId, String resultTypeGUID, String resultTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByType(userId, resultTypeGUID, resultTypeName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getBeansByType(String userId, String resultTypeGUID, String resultTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByType(userId, resultTypeGUID, resultTypeName, serviceSupportedZones, startFrom, pageSize, methodName);
        if (entities != null && !entities.isEmpty()) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.converter.getNewBean(this.beanClass, entity, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<String> getBeanGUIDsByType(String userId, String resultTypeGUID, String resultTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDsByType(userId, resultTypeGUID, resultTypeName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<String> getBeanGUIDsByType(String userId, String resultTypeGUID, String resultTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        RepositoryIteratorForEntities iterator = this.getEntitySearchIterator(userId, null, resultTypeGUID, resultTypeName, null, false, startFrom, queryPageSize, methodName);
        ArrayList<String> results = new ArrayList<String>();
        String entityParameterName = "Entity of type" + resultTypeName;
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail entity = iterator.getNext();
            if (entity == null) continue;
            try {
                this.validateAnchorEntity(userId, entity.getGUID(), resultTypeName, entity, entityParameterName, false, serviceSupportedZones, methodName);
                results.add(entity.getGUID());
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getBeansByClassification(String userId, String resultTypeGUID, String resultClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, resultTypeGUID, resultClassificationName, startFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<B> softwareServerCapabilities = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                softwareServerCapabilities.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!softwareServerCapabilities.isEmpty()) {
                return softwareServerCapabilities;
            }
        }
        return null;
    }

    public List<String> getBeanGUIDsByClassification(String userId, String resultTypeGUID, String resultClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, resultTypeGUID, resultClassificationName, startFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<String> softwareServerCapabilityGUIDs = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                softwareServerCapabilityGUIDs.add(entity.getGUID());
            }
            if (!softwareServerCapabilityGUIDs.isEmpty()) {
                return softwareServerCapabilityGUIDs;
            }
        }
        return null;
    }

    public void linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties relationshipProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, this.supportedZones, relationshipTypeGUID, relationshipTypeName, relationshipProperties, methodName);
    }

    public void linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachingGUID, attachingGUIDParameterName, methodName);
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, false, suppliedSupportedZones, methodName);
        EntityDetail attachingElementAnchorEntity = this.validateAnchorEntity(userId, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, false, suppliedSupportedZones, methodName);
        this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingGUID, attachingGUID, relationshipProperties, methodName);
        if (startingElementAnchorEntity != null || attachingElementAnchorEntity != null) {
            int latestChangeTarget;
            String actionDescriptionTemplate = "Linking %s %s to %s %s";
            String actionDescription = String.format("Linking %s %s to %s %s", startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID);
            if (startingElementAnchorEntity != null) {
                latestChangeTarget = 8;
                if (startingGUID.equals(startingElementAnchorEntity.getGUID())) {
                    latestChangeTarget = 3;
                }
                this.addLatestChangeToAnchor(startingElementAnchorEntity, latestChangeTarget, 0, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, methodName);
            } else {
                this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, null, methodName);
            }
            if (attachingElementAnchorEntity != null && !attachingElementAnchorEntity.getGUID().equals(startingElementAnchorEntity.getGUID())) {
                latestChangeTarget = 8;
                if (attachingGUID.equals(attachingElementAnchorEntity.getGUID())) {
                    latestChangeTarget = 3;
                }
                this.addLatestChangeToAnchor(attachingElementAnchorEntity, latestChangeTarget, 0, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, methodName);
            } else {
                this.reEvaluateAnchorGUID(attachingGUID, attachingGUIDParameterName, attachingElementTypeName, null, methodName);
            }
        }
    }

    public void relinkElementToNewElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean startAtEnd1, String newAttachingGUID, String newAttachingGUIDParameterName, String newAttachingElementTypeName, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, startAtEnd1, newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, this.supportedZones, attachmentTypeGUID, attachmentTypeName, relationshipProperties, methodName);
    }

    public void relinkElementToNewElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean startAtEnd1, String newAttachingGUID, String newAttachingGUIDParameterName, String newAttachingElementTypeName, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(newAttachingGUID, newAttachingGUIDParameterName, methodName);
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, false, suppliedSupportedZones, methodName);
        EntityDetail attachingElementAnchorEntity = this.validateAnchorEntity(userId, newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, false, suppliedSupportedZones, methodName);
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, startingGUID, startingElementTypeName, startAtEnd1, attachmentTypeGUID, attachmentTypeName, methodName);
        String oldAttachingGUID = "<null>";
        String oldAttachingElementTypeName = "<null";
        if (relationship != null) {
            EntityProxy proxy = startAtEnd1 ? relationship.getEntityOneProxy() : relationship.getEntityTwoProxy();
            if (proxy != null) {
                oldAttachingGUID = proxy.getGUID();
                if (proxy.getType() != null) {
                    oldAttachingElementTypeName = proxy.getType().getTypeDefName();
                }
            }
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
        this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingGUID, newAttachingGUID, relationshipProperties, methodName);
        if (startingElementAnchorEntity != null || attachingElementAnchorEntity != null) {
            int latestChangeTarget;
            String actionDescriptionTemplate = "Relinking %s %s from %s %s to %s %s";
            String actionDescription = String.format("Relinking %s %s from %s %s to %s %s", startingElementTypeName, startingGUID, oldAttachingElementTypeName, oldAttachingGUID, newAttachingElementTypeName, newAttachingGUID);
            if (startingElementAnchorEntity != null) {
                latestChangeTarget = 8;
                if (startingGUID.equals(startingElementAnchorEntity.getGUID())) {
                    latestChangeTarget = 3;
                }
                this.addLatestChangeToAnchor(startingElementAnchorEntity, latestChangeTarget, 0, null, newAttachingGUID, newAttachingElementTypeName, attachmentTypeName, userId, actionDescription, methodName);
                this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementAnchorEntity.getGUID(), methodName);
            }
            if (attachingElementAnchorEntity != null) {
                latestChangeTarget = 8;
                if (newAttachingGUID.equals(attachingElementAnchorEntity.getGUID())) {
                    latestChangeTarget = 3;
                }
                this.addLatestChangeToAnchor(attachingElementAnchorEntity, latestChangeTarget, 0, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, methodName);
                this.reEvaluateAnchorGUID(newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, attachingElementAnchorEntity.getGUID(), methodName);
            }
        }
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeGUID, String attachingElementTypeName, String attachmentTypeGUID, String attachmentTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeGUID, attachingElementTypeName, this.supportedZones, attachmentTypeGUID, attachmentTypeName, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachedGUID, attachedGUIDParameterName, methodName);
        EntityDetail startingElementAnchorEntity = this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, false, suppliedSupportedZones, methodName);
        EntityDetail attachingElementAnchorEntity = this.validateAnchorEntity(userId, attachedGUID, attachedGUIDParameterName, attachedElementTypeName, false, suppliedSupportedZones, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, startingGUID, startingElementTypeName, attachedGUID, attachmentTypeGUID, attachmentTypeName, methodName);
        if (relationship != null) {
            if (!onlyCreatorPermitted || userId.equals(relationship.getCreatedBy())) {
                if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
                    this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
                }
            } else {
                throw new UserNotAuthorizedException(GenericHandlersErrorCode.ONLY_CREATOR_CAN_DELETE.getMessageDefinition(methodName, startingElementTypeName, startingGUID, attachedElementTypeName, attachedGUID, userId), this.getClass().getName(), methodName, userId);
            }
            if (attachingElementAnchorEntity != null && attachingElementAnchorEntity.getGUID().equals(startingElementAnchorEntity.getGUID())) {
                this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, null, null, attachingElementAnchorEntity, methodName);
                attachingElementAnchorEntity = null;
            }
            if (startingElementAnchorEntity != null || attachingElementAnchorEntity != null) {
                int latestChangeTarget;
                String actionDescriptionTemplate = "Unlinking %s %s to %s %s";
                String actionDescription = String.format("Unlinking %s %s to %s %s", startingElementTypeName, startingGUID, attachedElementTypeName, attachedGUID);
                if (startingElementAnchorEntity != null) {
                    latestChangeTarget = 8;
                    if (startingGUID.equals(startingElementAnchorEntity.getGUID())) {
                        latestChangeTarget = 3;
                    }
                    this.addLatestChangeToAnchor(startingElementAnchorEntity, latestChangeTarget, 2, null, attachedGUID, attachedElementTypeName, attachmentTypeName, userId, actionDescription, methodName);
                    this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementAnchorEntity.getGUID(), methodName);
                }
                if (attachingElementAnchorEntity != null) {
                    latestChangeTarget = 8;
                    if (attachedGUID.equals(attachingElementAnchorEntity.getGUID())) {
                        latestChangeTarget = 3;
                    }
                    this.addLatestChangeToAnchor(attachingElementAnchorEntity, latestChangeTarget, 2, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, methodName);
                    this.reEvaluateAnchorGUID(attachedGUID, attachedGUIDParameterName, attachedElementTypeName, attachingElementAnchorEntity.getGUID(), methodName);
                }
            }
        }
    }

    public void unlinkAllElements(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String entityProxyParameterName = "entityProxy.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, true, suppliedSupportedZones, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, startingGUID, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingElementTypeName, relationship, methodName);
            if (entityProxy == null || entityProxy.getType() == null) continue;
            this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, entityProxy.getGUID(), "entityProxy.getGUID()", entityProxy.getType().getTypeDefGUID(), entityProxy.getType().getTypeDefName(), suppliedSupportedZones, attachmentTypeGUID, attachmentTypeName, methodName);
        }
    }

    public String unlinkConnectedElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, String detachedElementTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String entityProxyParameterName = "entityProxy.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.validateAnchorEntity(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, true, suppliedSupportedZones, methodName);
        List<Relationship> links = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, detachedElementTypeName, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (links == null) {
            return null;
        }
        if (links.size() > 1) {
            this.errorHandler.handleAmbiguousRelationships(startingGUID, startingElementTypeName, attachmentTypeName, links, methodName);
        }
        EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingElementTypeName, links.get(0), methodName);
        String detachedElementGUID = null;
        if (entityProxy != null && entityProxy.getType() != null) {
            detachedElementGUID = entityProxy.getGUID();
            this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, entityProxy.getGUID(), "entityProxy.getGUID()", entityProxy.getType().getTypeDefGUID(), entityProxy.getType().getTypeDefName(), suppliedSupportedZones, attachmentTypeGUID, attachmentTypeName, methodName);
        }
        return detachedElementGUID;
    }

    public void verifyExternalSourceIdentity(String userId, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "externalSourceGUID";
        if (externalSourceGUID == null && externalSourceName == null) {
            return;
        }
        try {
            EntityDetail integrator = this.getEntityFromRepository(userId, externalSourceGUID, "externalSourceGUID", "SoftwareServerCapability", null, null, this.supportedZones, methodName);
            if (integrator == null) {
                throw new InvalidParameterException(GenericHandlersErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(this.serviceName, methodName, externalSourceGUID, externalSourceName, null), this.getClass().getName(), methodName, externalSourceGUID);
            }
            String qualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", integrator.getProperties(), methodName);
            if (!externalSourceName.equals(qualifiedName)) {
                throw new InvalidParameterException(GenericHandlersErrorCode.BAD_INTEGRATOR_NAME.getMessageDefinition(this.serviceName, methodName, externalSourceName, qualifiedName, externalSourceGUID), this.getClass().getName(), methodName, externalSourceGUID);
            }
        }
        catch (InvalidParameterException error) {
            throw new InvalidParameterException(GenericHandlersErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(this.serviceName, methodName, externalSourceGUID, externalSourceName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, externalSourceGUID);
        }
    }
}

