/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ReferenceableBuilder
extends OpenMetadataAPIGenericBuilder {
    protected String qualifiedName = null;
    private Map<String, String> additionalProperties = null;

    protected ReferenceableBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
    }

    protected ReferenceableBuilder(String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, repositoryHelper, serviceName, serverName);
    }

    protected ReferenceableBuilder(String qualifiedName, String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeId, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, extendedProperties, null, null, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeId, typeName, extendedProperties, instanceStatus, null, repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    public void setTemplate(String userId, String name, String description, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "Template", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getTemplateProperties(name, description, additionalProperties, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "Template");
        }
    }

    private InstanceProperties getTemplateProperties(String name, String description, Map<String, String> additionalProperties, String methodName) {
        InstanceProperties properties = null;
        if (name != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", name, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        }
        if (additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", additionalProperties, methodName);
        }
        return properties;
    }

    public void setSecurityTags(String userId, List<String> securityLabels, Map<String, Object> securityProperties, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "SecurityTags", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getSecurityTagProperties(securityLabels, securityProperties, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "SecurityTags");
        }
    }

    InstanceProperties getSecurityTagProperties(List<String> securityLabels, Map<String, Object> securityProperties, String methodName) {
        InstanceProperties properties = null;
        if (securityLabels != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, "securityLabels", securityLabels, methodName);
        }
        if (securityProperties != null) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "securityProperties", securityProperties, methodName);
        }
        return properties;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "qualifiedName", this.qualifiedName, methodName);
        }
        if (this.additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        }
        return properties;
    }
}

