/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;

public class SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>
extends SchemaElementHandler<SCHEMA_ATTRIBUTE> {
    private OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> schemaAttributeConverter;
    private Class<SCHEMA_TYPE> schemaTypeBeanClass;
    private SchemaTypeHandler<SCHEMA_TYPE> schemaTypeHandler;

    public SchemaAttributeHandler(OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> schemaAttributeConverter, Class<SCHEMA_ATTRIBUTE> schemaAttributeBeanClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(schemaAttributeConverter, schemaAttributeBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaAttributeConverter = schemaAttributeConverter;
        this.schemaTypeBeanClass = schemaTypeBeanClass;
        this.schemaTypeHandler = new SchemaTypeHandler<SCHEMA_TYPE>(schemaTypeConverter, schemaTypeBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentAttributeGUID, String parentAttributeGUIDParameterName, String parentAttributeTypeName, String parentAttributeRelationshipTypeGUID, String parentAttributeRelationshipTypeName, String qualifiedName, String qualifiedNameParameterName, SchemaAttributeBuilder schemaAttributeBuilder, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentAttributeGUID, parentAttributeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String schemaAttributeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeBuilder.getTypeGUID(), schemaAttributeBuilder.getTypeName(), qualifiedName, "qualifiedName", schemaAttributeBuilder, methodName);
        if (schemaAttributeGUID != null) {
            String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
            this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, "schemaAttributeGUID", schemaAttributeBuilder.getTypeName(), schemaAttributeBuilder.getSchemaTypeBuilder(), methodName);
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentAttributeGUID, parentAttributeGUIDParameterName, parentAttributeTypeName, schemaAttributeGUID, "schemaAttributeGUID", schemaAttributeBuilder.getTypeName(), parentAttributeRelationshipTypeGUID, parentAttributeRelationshipTypeName, null, methodName);
            return schemaAttributeGUID;
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesForComplexSchemaType(String userId, String schemaTypeGUID, String guidParameterName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaAttributesForComplexSchemaType(userId, schemaTypeGUID, guidParameterName, requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesForComplexSchemaType(String userId, String schemaTypeGUID, String schemaTypeGUIDParameterName, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUIDParameterName = "schemaAttributeEntity.getGUID()";
        List<EntityDetail> entities = this.getAttachedEntities(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", "SchemaAttribute", requiredClassificationName, omittedClassificationName, serviceSupportedZones, startFrom, pageSize, methodName);
        ArrayList<SCHEMA_ATTRIBUTE> results = new ArrayList<SCHEMA_ATTRIBUTE>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                results.add(this.getSchemaAttributeFromEntity(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity.getGUID()", schemaAttributeEntity, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private List<Relationship> getSchemaAttributeRelationships(String userId, EntityDetail schemaAttributeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUIDParameterName = "schemaAttributeEntity";
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        List<Relationship> relationships = this.getAttachmentLinks(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity", "SchemaAttribute", null, null, "SchemaAttribute", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getType() == null) continue;
                String typeName = relationship.getType().getTypeDefName();
                if ("ForeignKey".equals(typeName)) {
                    results.add(relationship);
                    continue;
                }
                if (!"GraphEdgeLink".equals(typeName)) continue;
                results.add(relationship);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private SCHEMA_ATTRIBUTE getSchemaAttributeFromEntity(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, EntityDetail schemaAttributeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributeEntity != null && schemaAttributeEntity.getType() != null) {
            Object schemaType = null;
            try {
                Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)schemaAttributeEntity, "TypeEmbeddedAttribute", methodName);
                if (typeClassification != null && typeClassification.getProperties() != null) {
                    String schemaTypeName = this.repositoryHelper.getStringProperty(this.serviceName, "typeName", typeClassification.getProperties(), methodName);
                    schemaType = this.schemaTypeHandler.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaAttributeEntity, schemaTypeName, typeClassification.getProperties(), schemaAttributeEntity.getClassifications(), methodName);
                }
            }
            catch (ClassificationErrorException typeClassification) {
                // empty catch block
            }
            if (schemaType == null) {
                schemaType = this.schemaTypeHandler.getSchemaTypeForParent(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
            }
            List<Relationship> attributeRelationships = this.getSchemaAttributeRelationships(userId, schemaAttributeEntity, methodName);
            return this.schemaAttributeConverter.getNewSchemaAttributeBean(this.beanClass, schemaAttributeEntity, this.schemaTypeBeanClass, schemaType, attributeRelationships, methodName);
        }
        return null;
    }

    private List<SCHEMA_ATTRIBUTE> getSchemaAttributesFromEntities(String userId, List<EntityDetail> schemaAttributeEntities, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "schemaAttributeEntities";
        if (schemaAttributeEntities != null) {
            ArrayList<SCHEMA_ATTRIBUTE> schemaAttributes = new ArrayList<SCHEMA_ATTRIBUTE>();
            for (EntityDetail entity : schemaAttributeEntities) {
                if (entity == null) continue;
                schemaAttributes.add(this.getSchemaAttributeFromEntity(userId, entity.getGUID(), "schemaAttributeEntities", entity, methodName));
            }
            if (!schemaAttributes.isEmpty()) {
                return schemaAttributes;
            }
        }
        return null;
    }

    public SCHEMA_ATTRIBUTE getSchemaAttribute(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String expectedTypeName, String requiredClassificationName, String omittedClassificationName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeParameterName = "expectedTypeName";
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(expectedTypeName, "expectedTypeName", methodName);
        EntityDetail schemaAttributeEntity = this.getEntityFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, expectedTypeName, requiredClassificationName, omittedClassificationName, methodName);
        return this.getSchemaAttributeFromEntity(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, schemaAttributeEntity, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesByName(String userId, String typeGUID, String typeName, String name, String requiredClassificationName, String omittedClassificationName, int elementStart, int maxElements, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaAttributesByName(userId, typeGUID, typeName, name, requiredClassificationName, omittedClassificationName, this.supportedZones, elementStart, maxElements, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesByName(String userId, String typeGUID, String typeName, String name, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        List<EntityDetail> schemaAttributeEntities = this.getEntitiesByValue(userId, name, "name", typeGUID, typeName, specificMatchPropertyNames, true, requiredClassificationName, omittedClassificationName, serviceSupportedZones, startFrom, pageSize, methodName);
        return this.getSchemaAttributesFromEntities(userId, schemaAttributeEntities, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> findSchemaAttributes(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> schemaAttributeEntities = this.findEntities(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, requiredClassificationName, omittedClassificationName, startFrom, pageSize, methodName);
        return this.getSchemaAttributesFromEntities(userId, schemaAttributeEntities, methodName);
    }
}

