/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationBuilder
extends OpenMetadataAPIGenericBuilder {
    private String annotationType;
    private String summary;
    private int confidenceLevel;
    private String expression;
    private String explanation;
    private String analysisStep;
    private String jsonProperties;
    private Map<String, String> additionalProperties;
    private String schemaName = null;
    private String schemaTypeName = null;
    private List<String> duplicateAnchorGUIDs = null;
    private List<String> matchingPropertyNames = null;
    private List<String> matchingClassificationNames = null;
    private List<String> matchingAttachmentGUIDs = null;
    private List<String> matchingRelationshipGUIDs = null;

    AnnotationBuilder(String annotationType, String summary, int confidenceLevel, String expression, String explanation, String analysisStep, String jsonProperties, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, List<Classification> existingClassifications, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, extendedProperties, InstanceStatus.ACTIVE, existingClassifications, repositoryHelper, serviceName, serverName);
        this.annotationType = annotationType;
        this.summary = summary;
        this.confidenceLevel = confidenceLevel;
        this.expression = expression;
        this.explanation = explanation;
        this.analysisStep = analysisStep;
        this.jsonProperties = jsonProperties;
        this.additionalProperties = additionalProperties;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    void setSchemaAnalysisSubTypeProperties(String schemaName, String schemaTypeName) {
        this.schemaName = schemaName;
        this.schemaTypeName = schemaTypeName;
    }

    void setSuspectDuplicateSubTypeProperties(List<String> duplicateAnchorGUIDs, List<String> matchingPropertyNames, List<String> matchingClassificationNames, List<String> matchingAttachmentGUIDs, List<String> matchingRelationshipGUIDs) {
        this.duplicateAnchorGUIDs = duplicateAnchorGUIDs;
        this.matchingPropertyNames = matchingPropertyNames;
        this.matchingClassificationNames = matchingClassificationNames;
        this.matchingAttachmentGUIDs = matchingAttachmentGUIDs;
        this.matchingRelationshipGUIDs = matchingRelationshipGUIDs;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = new InstanceProperties();
        if (this.annotationType != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "annotationType", this.annotationType, methodName);
        }
        if (this.summary != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "summary", this.summary, methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "level", this.confidenceLevel, methodName);
        if (this.expression != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "expression", this.expression, methodName);
        }
        if (this.explanation != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "explanation", this.explanation, methodName);
        }
        if (this.analysisStep != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "discoveryRequestStep", this.analysisStep, methodName);
        }
        if (this.jsonProperties != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "jsonProperties", this.jsonProperties, methodName);
        }
        if (this.additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "ClassificationAnnotation")) {
            return this.addClassificationAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataClassAnnotation")) {
            return this.addDataClassAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataProfileAnnotation")) {
            return this.addDataProfileAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataProfileLogAnnotation")) {
            return this.addDataProfileLogAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataSourcePhysicalStatusAnnotation")) {
            return this.addDataSourcePhysicalStatusAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DataSourceMeasurementAnnotation")) {
            return this.addDataSourceMeasurementAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DivergentValueAnnotation")) {
            return this.addDivergentValueAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DivergentClassificationAnnotation")) {
            return this.addDivergentClassificationAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DivergentRelationshipAnnotation")) {
            return this.addDivergentRelationshipAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DivergentAttachmentAnnotation")) {
            return this.addDivergentAttachmentValueAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DivergentAttachmentClassificationAnnotation")) {
            return this.addDivergentAttachmentClassificationAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "DivergentAttachmentRelationshipAnnotation")) {
            return this.addDivergentAttachmentRelationshipAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "QualityAnnotation")) {
            return this.addQualityAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "RelationshipAdviceAnnotation")) {
            return this.addRelationshipAdviceAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "RequestForActionAnnotation")) {
            return this.addRequestForActionAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SchemaAnalysisAnnotation")) {
            return this.addSchemaAnalysisAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SemanticAnnotation")) {
            return this.addSemanticAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SuspectDuplicateAnnotation")) {
            return this.addSuspectDuplicateAnnotationInstanceProperties(properties, methodName);
        }
        return properties;
    }

    private InstanceProperties addClassificationAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDataClassAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDataProfileAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDataProfileLogAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDataSourcePhysicalStatusAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDataSourceMeasurementAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDivergentValueAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDivergentClassificationAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDivergentRelationshipAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDivergentAttachmentValueAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDivergentAttachmentClassificationAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addDivergentAttachmentRelationshipAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addQualityAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addRelationshipAdviceAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addRequestForActionAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addSchemaAnalysisAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        if (this.schemaName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "schemaName", this.schemaName, methodName);
        }
        if (this.schemaTypeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "schemaType", this.schemaTypeName, methodName);
        }
        return properties;
    }

    private InstanceProperties addSemanticAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        return properties;
    }

    private InstanceProperties addSuspectDuplicateAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        if (this.duplicateAnchorGUIDs != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "duplicateAnchorGUIDs", this.duplicateAnchorGUIDs, methodName);
        }
        if (this.matchingPropertyNames != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingPropertyNames", this.matchingPropertyNames, methodName);
        }
        if (this.matchingClassificationNames != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingClassificationNames", this.matchingClassificationNames, methodName);
        }
        if (this.matchingAttachmentGUIDs != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingAttachmentGUIDS", this.matchingAttachmentGUIDs, methodName);
        }
        if (this.matchingRelationshipGUIDs != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "matchingRelationshipGUIDs", this.matchingRelationshipGUIDs, methodName);
        }
        return properties;
    }
}

