/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationReviewBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SuspectDuplicateAnnotation;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationHandler<B>
extends ReferenceableHandler<B> {
    public AnnotationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<String> getTypesOfAnnotation() {
        return this.repositoryHelper.getSubTypesOf(this.serviceName, "Annotation");
    }

    public Map<String, String> getTypesOfAnnotationDescriptions() {
        List annotationTypeList = this.repositoryHelper.getSubTypesOf(this.serviceName, "Annotation");
        HashMap<String, String> annotationDescriptions = new HashMap<String, String>();
        if (annotationTypeList != null) {
            for (String annotationTypeName : annotationTypeList) {
                TypeDef annotationTypeDef;
                if (annotationTypeName == null || (annotationTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, annotationTypeName)) == null) continue;
                annotationDescriptions.put(annotationTypeName, annotationTypeDef.getDescription());
            }
        }
        if (annotationDescriptions.isEmpty()) {
            return null;
        }
        return annotationDescriptions;
    }

    private AnnotationBuilder getAnnotationBuilder(String typeGUID, String typeName, Annotation annotation, String methodName) throws InvalidParameterException {
        String parameterName = "annotation";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        AnnotationBuilder builder = new AnnotationBuilder(annotation.getAnnotationType(), annotation.getSummary(), annotation.getConfidenceLevel(), annotation.getExpression(), annotation.getExplanation(), annotation.getAnalysisStep(), annotation.getJsonProperties(), annotation.getAdditionalProperties(), typeGUID, typeName, annotation.getExtendedProperties(), null, this.repositoryHelper, this.serviceName, this.serverName);
        if (annotation instanceof SchemaAnalysisAnnotation) {
            SchemaAnalysisAnnotation schemaAnalysisAnnotation = (SchemaAnalysisAnnotation)annotation;
            builder.setSchemaAnalysisSubTypeProperties(schemaAnalysisAnnotation.getSchemaName(), schemaAnalysisAnnotation.getSchemaName());
        } else if (annotation instanceof SuspectDuplicateAnnotation) {
            SuspectDuplicateAnnotation suspectDuplicateAnnotation = (SuspectDuplicateAnnotation)annotation;
            builder.setSuspectDuplicateSubTypeProperties(suspectDuplicateAnnotation.getDuplicateAnchorGUIDs(), suspectDuplicateAnnotation.getMatchingPropertyNames(), suspectDuplicateAnnotation.getMatchingClassificationNames(), suspectDuplicateAnnotation.getMatchingAttachmentGUIDs(), suspectDuplicateAnnotation.getMatchingRelationshipGUIDs());
        }
        return builder;
    }

    private String getAnnotationTypeGUID(String typeName, String methodName) throws InvalidParameterException {
        return this.invalidParameterHandler.validateTypeName(typeName, "Annotation", this.serviceName, methodName, this.repositoryHelper);
    }

    private String getAnnotationTypeName(Annotation annotation) {
        if (annotation != null) {
            if (annotation.getTypeName() != null) {
                return annotation.getTypeName();
            }
            if (annotation instanceof SuspectDuplicateAnnotation) {
                return "SuspectDuplicateAnnotation";
            }
        }
        return "Annotation";
    }

    private String addNewAnnotation(String userId, String assetGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = this.getAnnotationTypeName(annotation);
        String typeGUID = this.getAnnotationTypeGUID(typeName, methodName);
        AnnotationBuilder builder = this.getAnnotationBuilder(typeGUID, typeName, annotation, methodName);
        if (assetGUID != null) {
            builder.setAnchors(userId, assetGUID, methodName);
        }
        return this.createBeanInRepository(userId, null, null, typeGUID, typeName, null, null, builder, methodName);
    }

    public String addAnnotationToDiscoveryReport(String userId, String discoveryReportGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUID;
        String annotationParameterName = "annotation";
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        String assetGUID = null;
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", false, this.supportedZones, methodName);
        if (anchorEntity != null) {
            assetGUID = anchorEntity.getGUID();
        }
        if ((annotationGUID = this.addNewAnnotation(userId, assetGUID, annotation, methodName)) != null) {
            this.linkElementToElement(userId, null, null, annotationGUID, "annotation", "Annotation", discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", "51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", null, methodName);
        }
        return annotationGUID;
    }

    public String addAnnotationToAnnotation(String userId, String parentAnnotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUID;
        String parentAnnotationGUIDParameterName = "parentAnnotationGUID";
        String annotationParameterName = "annotation";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        String assetGUID = null;
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, parentAnnotationGUID, "parentAnnotationGUID", "Annotation", false, this.supportedZones, methodName);
        if (anchorEntity != null) {
            assetGUID = anchorEntity.getGUID();
        }
        if ((annotationGUID = this.addNewAnnotation(userId, assetGUID, annotation, methodName)) != null) {
            this.linkElementToElement(userId, null, null, parentAnnotationGUID, "parentAnnotationGUID", "Annotation", annotationGUID, "annotation", "Annotation", "605aaa6d-682e-405c-964b-ca6aaa94be1b", "Annotation", null, methodName);
        }
        return annotationGUID;
    }

    public void updateAnnotation(String userId, String annotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationParameterName = "annotation";
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        String typeName = this.getAnnotationTypeName(annotation);
        String typeGUID = this.getAnnotationTypeGUID(typeName, methodName);
        AnnotationBuilder builder = this.getAnnotationBuilder(typeGUID, typeName, annotation, methodName);
        this.updateBeanInRepository(userId, null, null, annotationGUID, "annotationGUID", "6cea5b53-558c-48f1-8191-11d48db29fb4", "Annotation", builder.getInstanceProperties(methodName), false, methodName);
    }

    public void addAnnotationReview(String userId, String annotationGUID, String annotationGUIDParameterName, int annotationStatus, Date reviewDate, String steward, String comment, String annotationReviewTypeGUID, String annotationReviewTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationReviewGUID;
        String annotationReviewGUIDParameterName = "annotationReviewGUID";
        String typeGUID = "b893d6fc-642a-454b-beaf-809ee4dd876a";
        String typeName = "AnnotationReview";
        if (annotationReviewTypeGUID != null) {
            typeGUID = annotationReviewTypeGUID;
        }
        if (annotationReviewTypeName != null) {
            typeName = annotationReviewTypeName;
        }
        AnnotationReviewBuilder builder = new AnnotationReviewBuilder(annotationStatus, reviewDate, steward, comment, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail anchorEntity = this.validateAnchorEntity(userId, annotationGUID, annotationGUIDParameterName, "Annotation", false, this.supportedZones, methodName);
        if (anchorEntity != null && anchorEntity.getGUID() != null) {
            builder.setAnchors(userId, anchorEntity.getGUID(), methodName);
        }
        if ((annotationReviewGUID = this.createBeanInRepository(userId, null, null, typeGUID, typeName, null, null, builder, methodName)) != null) {
            this.linkElementToElement(userId, null, null, annotationGUID, annotationGUIDParameterName, "Annotation", annotationReviewGUID, "annotationReviewGUID", "AnnotationReview", "5d3c2fb7-fa04-4d77-83cb-fd9216a07769", "AnnotationReviewLink", builder.getReviewLinkInstanceProperties(methodName), methodName);
        }
    }

    public void deleteAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.deleteBeanInRepository(userId, null, null, annotationGUID, "annotationGUID", "6cea5b53-558c-48f1-8191-11d48db29fb4", "Annotation", null, null, methodName);
    }

    public B getAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, annotationGUID, "annotationGUID", "Annotation", methodName);
        return this.converter.getNewBean(this.beanClass, entity, methodName);
    }

    private B getAnnotationBean(String userId, EntityDetail annotationEntity, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotation.getGUID";
        if (annotationEntity != null) {
            ArrayList<EntityDetail> supplementaryEntities = null;
            EntityDetail annotationReviewEntity = this.getAttachedEntity(userId, annotationEntity.getGUID(), "annotation.getGUID", "Annotation", "5d3c2fb7-fa04-4d77-83cb-fd9216a07769", "AnnotationReviewLink", "AnnotationReview", methodName);
            if (annotationReviewEntity != null) {
                supplementaryEntities = new ArrayList<EntityDetail>();
                supplementaryEntities.add(annotationReviewEntity);
            }
            List<Relationship> annotationRelationships = this.getAllAttachmentLinks(userId, annotationEntity.getGUID(), null, "Annotation", methodName);
            return this.converter.getNewComplexBean(this.beanClass, annotationEntity, supplementaryEntities, annotationRelationships, methodName);
        }
        return null;
    }

    private List<B> getLinkedAnnotations(String userId, String rootGUID, String rootGUIDParameterName, String rootGUIDTypeName, String relationshipTypeGUID, String relationshipTypeName, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> annotationEntities = this.getAttachedEntities(userId, rootGUID, rootGUIDParameterName, rootGUIDTypeName, relationshipTypeGUID, relationshipTypeName, "Annotation", startingFrom, maximumResults, methodName);
        if (annotationEntities != null && !annotationEntities.isEmpty()) {
            ArrayList<B> returnBeans = new ArrayList<B>();
            for (EntityDetail annotationEntity : annotationEntities) {
                B annotationBean;
                if (annotationEntity == null || (annotationBean = this.getAnnotationBean(userId, annotationEntity, methodName)) == null) continue;
                returnBeans.add(annotationBean);
            }
            return returnBeans;
        }
        return null;
    }

    private List<B> getLinkedAnnotations(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, int requestedAnnotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, startingElementGUID, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, startingFrom, queryPageSize, methodName);
        ArrayList<B> results = new ArrayList<B>();
        while (iterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            B annotationBean;
            EntityProxy entityProxy;
            int annotationStatusOrdinal;
            Relationship relationship = iterator.getNext();
            if (relationship == null || relationship.getProperties() == null || requestedAnnotationStatus != (annotationStatusOrdinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, "annotationStatus", relationship.getProperties(), methodName)) || (entityProxy = this.repositoryHandler.getOtherEnd(startingElementGUID, startingElementTypeName, relationship, methodName)) == null) continue;
            String entityProxyGUIDParameterName = "entityProxy.getGUID";
            EntityDetail annotationEntity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "entityProxy.getGUID", "Annotation", methodName);
            if (annotationEntity == null || annotationEntity.getGUID() == null || (annotationBean = this.getAnnotation(userId, entityProxy.getGUID(), methodName)) == null) continue;
            results.add(annotationBean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        return this.getLinkedAnnotations(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", "51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", startingFrom, maximumResults, methodName);
    }

    public List<B> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, int annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        return this.getLinkedAnnotations(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", "51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", annotationStatus, startingFrom, maximumResults, methodName);
    }

    public List<B> getExtendedAnnotations(String userId, String annotationGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameter = "annotationGUID";
        return this.getLinkedAnnotations(userId, annotationGUID, "annotationGUID", "Annotation", "605aaa6d-682e-405c-964b-ca6aaa94be1b", "Annotation", startingFrom, maximumResults, methodName);
    }

    public List<B> getExtendedAnnotations(String userId, String annotationGUID, int annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameter = "annotationGUID";
        return this.getLinkedAnnotations(userId, annotationGUID, "annotationGUID", "Annotation", "605aaa6d-682e-405c-964b-ca6aaa94be1b", "Annotation", annotationStatus, startingFrom, maximumResults, methodName);
    }

    public List<B> getAnnotationsForAsset(String userId, String assetGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        return null;
    }

    public List<B> getAnnotationsForAssetByStatus(String userId, String assetGUID, int status, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        return null;
    }
}

