/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class AssetBuilder
extends ReferenceableBuilder {
    private String technicalName = null;
    private String technicalDescription = null;

    AssetBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("896d14c2-7522-4f6c-8519-757711943fe6", "Asset", repositoryHelper, serviceName, serverName);
    }

    AssetBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, repositoryHelper, serviceName, serverName);
    }

    AssetBuilder(String qualifiedName, String technicalName, String technicalDescription, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.technicalName = technicalName;
        this.technicalDescription = technicalDescription;
    }

    AssetBuilder(String qualifiedName, String technicalName, String technicalDescription, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, InstanceStatus initialStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, initialStatus, repositoryHelper, serviceName, serverName);
        this.technicalName = technicalName;
        this.technicalDescription = technicalDescription;
    }

    void setAssetZones(String userId, List<String> zoneMembership, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetZoneMembership", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getZoneMembershipProperties(zoneMembership, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetZoneMembership");
        }
    }

    InstanceProperties getZoneMembershipProperties(List<String> zoneMembership, String methodName) {
        InstanceProperties properties = null;
        if (zoneMembership != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, "zoneMembership", zoneMembership, methodName);
        }
        return properties;
    }

    void setAssetOwnership(String userId, String owner, int ownerType, String methodName) throws InvalidParameterException {
        if (owner != null) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetOwnership", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOwnerProperties(userId, owner, ownerType, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOwnership");
            }
        }
    }

    InstanceProperties getOwnerProperties(String userId, String owner, int ownerType, String methodName) throws InvalidParameterException {
        InstanceProperties properties;
        if (owner != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "owner", owner, methodName);
            try {
                properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "ownerType", "9548390c-69f5-4dc6-950d-6feeee257b56", "AssetOwnerType", 0, methodName);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOwnerType");
            }
        } else {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "owner", userId, methodName);
            try {
                properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "ownerType", "9548390c-69f5-4dc6-950d-6feeee257b56", "AssetOwnerType", ownerType, methodName);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOwnerType");
            }
        }
        return properties;
    }

    void setAssetOrigin(String userId, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues, String methodName) throws InvalidParameterException {
        if (organizationGUID != null || businessCapabilityGUID != null || otherOriginValues != null && !otherOriginValues.isEmpty()) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetOrigin", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOriginProperties(organizationGUID, businessCapabilityGUID, otherOriginValues, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOrigin");
            }
        }
    }

    InstanceProperties getOriginProperties(String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues, String methodName) {
        InstanceProperties properties = null;
        if (organizationGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "organization", organizationGUID, methodName);
        }
        if (businessCapabilityGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapability", businessCapabilityGUID, methodName);
        }
        if (otherOriginValues != null && !otherOriginValues.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "otherOriginValues", otherOriginValues, methodName);
        }
        return properties;
    }

    void setReferenceData(String userId, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "ReferenceData", this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "ReferenceData");
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.technicalName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.technicalName, methodName);
        }
        if (this.technicalDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.technicalDescription, methodName);
        }
        return properties;
    }
}

