/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EmbeddedConnectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.metadatasecurity.properties.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionHandler<B>
extends ReferenceableHandler<B> {
    private EndpointHandler<OpenMetadataAPIDummyBean> endpointHandler;
    private ConnectorTypeHandler<OpenMetadataAPIDummyBean> connectorTypeHandler;

    public ConnectionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.endpointHandler = new EndpointHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String findConnection(String userId, String connectionGUID, String qualifiedName, String displayName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectionGUID";
        String qualifiedNameParameter = "qualifiedName";
        String displayNameParameter = "displayName";
        if (connectionGUID != null) {
            try {
                if (this.getEntityFromRepository(userId, connectionGUID, "connectionGUID", "Connection", methodName) != null) {
                    return connectionGUID;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        }
        String retrievedGUID = null;
        if (qualifiedName != null) {
            retrievedGUID = this.getBeanGUIDByUniqueName(userId, qualifiedName, "qualifiedName", "qualifiedName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.supportedZones, methodName);
        }
        if (retrievedGUID == null && displayName != null) {
            retrievedGUID = this.getBeanGUIDByUniqueName(userId, displayName, "displayName", "displayName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.supportedZones, methodName);
        }
        return retrievedGUID;
    }

    public String saveConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection connection, String assetSummary, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionParameterName = "connection";
        String connectorTypeParameterName = "connection.connectorType";
        this.invalidParameterHandler.validateObject((Object)connection, "connection", methodName);
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection.connectorType", methodName);
        String existingConnectionGUID = this.findConnection(userId, connection.getGUID(), connection.getQualifiedName(), connection.getDisplayName(), methodName);
        if (existingConnectionGUID == null) {
            return this.addConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, assetGUID, assetGUIDParameterName, assetTypeName, connection, assetSummary, methodName);
        }
        return this.updateConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, assetGUID, assetGUIDParameterName, assetTypeName, existingConnectionGUID, connection, methodName);
    }

    private void saveAssociatedConnectionEntities(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, String connectionGUID, Endpoint endpoint, ConnectorType connectorType, List<EmbeddedConnection> embeddedConnections, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUIDParameterName = "connectionGUID";
        if (endpoint != null) {
            String endpointGUID = this.endpointHandler.saveEndpoint(userId, externalSourceGUID, externalSourceName, endpoint, methodName);
            if (endpointGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, "Endpoint", null, null, endpointGUID, connectionGUID, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", methodName);
        }
        if (connectorType != null) {
            String connectorTypeGUID = this.connectorTypeHandler.saveConnectorType(userId, externalSourceGUID, externalSourceName, connectorType, methodName);
            if (connectorTypeGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, externalSourceGUID, externalSourceName, "Connection", connectionGUID, connectorTypeGUID, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", methodName);
        }
        this.unlinkAllElements(userId, false, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "Connection", this.supportedZones, "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", methodName);
        if (embeddedConnections != null && !embeddedConnections.isEmpty()) {
            for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                if (embeddedConnection == null) continue;
                org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection realConnection = embeddedConnection.getEmbeddedConnection();
                String realConnectionGUID = this.saveConnection(userId, externalSourceGUID, externalSourceName, assetGUID, null, null, assetTypeName, realConnection, null, methodName);
                if (realConnection == null) continue;
                EmbeddedConnectionBuilder embeddedConnectionBuilder = new EmbeddedConnectionBuilder(embeddedConnection.getPosition(), embeddedConnection.getArguments(), embeddedConnection.getDisplayName(), this.repositoryHelper, this.serviceName, this.serverName);
                this.repositoryHandler.createRelationship(userId, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", externalSourceGUID, externalSourceName, connectionGUID, realConnectionGUID, embeddedConnectionBuilder.getInstanceProperties(methodName), methodName);
            }
        }
    }

    private String addConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection connection, String assetSummary, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        String connectionParameterName = "connection";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection", methodName);
        String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String connectionTypeName = "Connection";
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            connectionTypeGUID = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
            connectionTypeName = "VirtualConnection";
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", connection.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            connectionBuilder.setAnchors(userId, anchorGUID, methodName);
        }
        if ((connectionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionTypeGUID, connectionTypeName, connection.getQualifiedName(), "qualifiedName", connectionBuilder, methodName)) != null) {
            this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, anchorGUID, assetGUID, assetGUIDParameterName, assetTypeName, connectionGUID, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, methodName);
            if (assetGUID != null) {
                InstanceProperties properties = null;
                if (assetSummary != null) {
                    properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
                }
                this.linkElementToElement(userId, null, null, connectionGUID, "connection", "Connection", assetGUID, assetGUIDParameterName, assetTypeName, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", properties, methodName);
            }
        }
        return connectionGUID;
    }

    private String updateConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, String existingConnectionGUID, org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "connection";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection", methodName);
        String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String connectionTypeName = "Connection";
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            connectionTypeGUID = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
            connectionTypeName = "VirtualConnection";
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        this.updateConnection(userId, externalSourceGUID, externalSourceName, existingConnectionGUID, "connection", connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectionTypeGUID, connectionTypeName, connection.getExtendedProperties(), methodName);
        this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, anchorGUID, assetGUID, assetGUIDParameterName, assetTypeName, existingConnectionGUID, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, methodName);
        return existingConnectionGUID;
    }

    public String createConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectorTypeGUID, String connectorTypeGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetSummary, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, connectorTypeGUID, connectorTypeGUIDParameterName, endpointGUID, endpointGUIDParameterName, methodName);
    }

    public String createVirtualConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectorTypeGUID, String connectorTypeGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetSummary, "82f9c664-e59d-484c-a8f3-17088c23a2f3", "VirtualConnection", qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, connectorTypeGUID, connectorTypeGUIDParameterName, null, null, methodName);
    }

    public String createConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetSummary, String connectionTypeId, String connectionTypeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectorTypeGUID, String connectorTypeGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        String nameParameter = "qualifiedName";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, connectionTypeId, connectionTypeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        if (assetGUID != null) {
            builder.setAnchors(userId, assetGUID, methodName);
        }
        if ((connectionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionTypeId, connectionTypeName, qualifiedName, "qualifiedName", builder, methodName)) != null) {
            if (assetGUID != null) {
                InstanceProperties relationshipProperties = null;
                if (assetSummary != null) {
                    relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
                }
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", connectionTypeName, assetGUID, assetGUIDParameterName, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", relationshipProperties, methodName);
            }
            if (connectorTypeGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", connectionTypeName, connectorTypeGUID, connectorTypeGUIDParameterName, "ConnectorType", "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, methodName);
            }
            if (endpointGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, "Endpoint", connectionGUID, "connectionGUID", connectionTypeName, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, methodName);
            }
        }
        return connectionGUID;
    }

    public void addEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, String virtualConnectionGUID, String virtualConnectionGUIDParameterName, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID, String embeddedConnectionGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(virtualConnectionGUID, virtualConnectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, embeddedConnectionGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "position", position, methodName);
        if (displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", displayName, methodName);
        }
        if (arguments != null && !arguments.isEmpty()) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "arguments", arguments, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, virtualConnectionGUID, virtualConnectionGUIDParameterName, "VirtualConnection", embeddedConnectionGUID, embeddedConnectionGUIDParameterName, "Connection", "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", properties, methodName);
    }

    public void updateConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String typeGUID, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, typeGUID, typeName, this.supportedZones, builder.getInstanceProperties(methodName), true, methodName);
    }

    public int countConnections(String userId, String assetGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.countAttachments(userId, assetGUID, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
    }

    public B getConnectionForAsset(String userId, String assetGUID, String assetGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getConnectionForAsset(userId, assetGUID, assetGUIDParameterName, this.supportedZones, methodName);
    }

    public B getConnectionForAsset(String userId, String assetGUID, String assetGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> connectionEntities = this.getAttachedEntities(userId, assetGUID, assetGUIDParameterName, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", null, null, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        EntityDetail selectedEntity = null;
        if (connectionEntities == null) {
            return null;
        }
        if (connectionEntities.size() == 1) {
            selectedEntity = connectionEntities.get(0);
        } else {
            ArrayList<Connection> candidateConnections = new ArrayList<Connection>();
            for (EntityDetail connectionEntity : connectionEntities) {
                if (connectionEntity == null) continue;
                Connection candidateConnection = super.getConnectionFromEntity(connectionEntity, methodName);
                candidateConnections.add(candidateConnection);
            }
            Connection connection = this.securityVerifier.validateUserForAssetConnectionList(userId, null, candidateConnections);
            if (connection != null) {
                for (EntityDetail connectionEntity : connectionEntities) {
                    if (connectionEntity == null || connectionEntity.getGUID() == null || !connectionEntity.getGUID().equals(connection.getGUID())) continue;
                    selectedEntity = connectionEntity;
                }
            } else {
                throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_CONNECTIONS_FOUND.getMessageDefinition(Integer.toString(candidateConnections.size()), assetGUID, methodName, this.serverName), this.getClass().getName(), methodName);
            }
        }
        return this.getConnection(userId, selectedEntity, methodName);
    }

    private B getConnection(String userId, EntityDetail connectionEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (connectionEntity != null && connectionEntity.getType() != null) {
            List<Relationship> supplementaryRelationships = this.getEmbeddedRelationships(userId, (EntitySummary)connectionEntity, methodName);
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            if (supplementaryRelationships != null) {
                for (Relationship relationship : supplementaryRelationships) {
                    if (relationship == null || relationship.getType() == null) continue;
                    EntityProxy entityProxy = null;
                    if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionConnectorType") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection")) {
                        entityProxy = relationship.getEntityTwoProxy();
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionEndpoint")) {
                        entityProxy = relationship.getEntityOneProxy();
                    }
                    if (entityProxy == null || entityProxy.getGUID() == null || entityProxy.getType() == null) continue;
                    String entityGUIDParameterName = "embeddedRelationship proxy";
                    EntityDetail supplementaryEntity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "embeddedRelationship proxy", entityProxy.getType().getTypeDefName(), methodName);
                    if (supplementaryEntity == null) continue;
                    supplementaryEntities.add(supplementaryEntity);
                }
            }
            if (supplementaryEntities.isEmpty()) {
                supplementaryEntities = null;
            }
            return this.converter.getNewComplexBean(this.beanClass, connectionEntity, supplementaryEntities, supplementaryRelationships, methodName);
        }
        return null;
    }

    private List<Relationship> getEmbeddedRelationships(String userId, EntitySummary connectionEntity, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
        if (connectionEntity != null && connectionEntity.getType() != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, connectionEntity.getGUID(), connectionEntity.getType().getTypeDefName(), null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            while (iterator.moreToReceive()) {
                List<Relationship> embeddedConnectionRelationships;
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionEndpoint") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectorType") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "ConnectionToAsset")) {
                    supplementaryRelationships.add(relationship);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "EmbeddedConnection")) continue;
                supplementaryRelationships.add(relationship);
                EntityProxy embeddedConnectionEnd = relationship.getEntityTwoProxy();
                if (embeddedConnectionEnd == null || embeddedConnectionEnd.getGUID() == null || (embeddedConnectionRelationships = this.getEmbeddedRelationships(userId, (EntitySummary)embeddedConnectionEnd, methodName)) == null) continue;
                supplementaryRelationships.addAll(embeddedConnectionRelationships);
            }
        }
        if (supplementaryRelationships.isEmpty()) {
            return null;
        }
        return supplementaryRelationships;
    }

    public List<B> getConnectionsForAsset(String userId, String assetGUID, String assetGUIDParameterName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> connectionEntities = super.getAttachedEntities(userId, assetGUID, assetGUIDParameterName, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "Connection", null, null, serviceSupportedZones, startingFrom, pageSize, methodName);
        if (connectionEntities != null && !connectionEntities.isEmpty()) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : connectionEntities) {
                B bean;
                if (entity == null || (bean = this.getConnection(userId, entity, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }
}

