/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String connectorProviderClassName = null;
    private List<String> recognizedAdditionalProperties = null;
    private List<String> recognizedSecuredProperties = null;
    private List<String> recognizedConfigurationProperties = null;

    public ConnectorTypeBuilder(String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.connectorProviderClassName = connectorProviderClassName;
        this.recognizedAdditionalProperties = recognizedAdditionalProperties;
        this.recognizedSecuredProperties = recognizedSecuredProperties;
        this.recognizedConfigurationProperties = recognizedConfigurationProperties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.connectorProviderClassName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "connectorProviderClassName", this.connectorProviderClassName, methodName);
        }
        if (this.recognizedAdditionalProperties != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "recognizedAdditionalProperties", this.recognizedAdditionalProperties, methodName);
        }
        if (this.recognizedSecuredProperties != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "recognizedSecuredProperties", this.recognizedSecuredProperties, methodName);
        }
        if (this.recognizedConfigurationProperties != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "recognizedConfigurationProperties", this.recognizedConfigurationProperties, methodName);
        }
        return properties;
    }
}

