/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

class ExternalIdentifierBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private int keyPattern = 0;

    ExternalIdentifierBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("7c8f8c2c-cc48-429e-8a21-a1f1851ccdb0", "ExternalId", repositoryHelper, serviceName, serverName);
    }

    ExternalIdentifierBuilder(String identifier, int keyPattern, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(identifier + UUID.randomUUID().toString(), "7c8f8c2c-cc48-429e-8a21-a1f1851ccdb0", "ExternalId", repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.keyPattern = keyPattern;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.identifier != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "identifier", this.identifier, methodName);
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "keyPattern", "8904df8f-1aca-4de8-9abd-1ef2aadba300", "KeyPattern", this.keyPattern, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "keyPattern");
        }
        return properties;
    }

    InstanceProperties getExternalIdResourceLinkProperties(String description, String usage, String source, Map<String, String> mappingProperties, String methodName) {
        InstanceProperties properties = null;
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        }
        if (usage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "usage", usage, methodName);
        }
        if (source != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", source, methodName);
        }
        if (mappingProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "mappingProperties", mappingProperties, methodName);
        }
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "lastSynchronized", new Date(), methodName);
        return properties;
    }

    InstanceProperties getExternalIdScopeProperties(String description, int permittedSynchronization, String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "description", description, methodName);
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "permittedSynchronization", "973a9f4c-93fa-43a5-a0c5-d97dbd164e78", "PermittedSynchronization", permittedSynchronization, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "keyPattern");
        }
        return properties;
    }
}

