/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.datastore.avrofile.AvroFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FilesAndFoldersHandler<FILESYSTEM, FOLDER, FILE> {
    private String serviceName;
    private String serverName;
    private String localServerUserId;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private SoftwareServerCapabilityHandler<FILESYSTEM> fileSystemHandler;
    private AssetHandler<FOLDER> folderHandler;
    private AssetHandler<FILE> fileHandler;
    private ConnectionHandler<OpenMetadataAPIDummyBean> connectionHandler;
    private ConnectorTypeHandler<OpenMetadataAPIDummyBean> connectorTypeHandler;
    private EndpointHandler<OpenMetadataAPIDummyBean> endpointHandler;
    private SchemaAttributeHandler<OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean> schemaAttributeHandler;
    private static final String folderDivider = "/";
    private static final String fileSystemDivider = "://";
    private static final String fileTypeDivider = "\\.";
    private static final String defaultAvroFileType = "avro";
    private static final String defaultCSVFileType = "csv";
    private static final BasicFileStoreProvider basicFileStoreProvider = new BasicFileStoreProvider();
    private static final DataFolderProvider dataFolderProvider = new DataFolderProvider();
    private static final AvroFileStoreProvider avroFileStoreProvider = new AvroFileStoreProvider();
    private static final CSVFileStoreProvider csvFileStoreProvider = new CSVFileStoreProvider();

    public FilesAndFoldersHandler(OpenMetadataAPIGenericConverter<FILESYSTEM> fileSystemConverter, Class<FILESYSTEM> fileSystemBeanClass, OpenMetadataAPIGenericConverter<FOLDER> folderConverter, Class<FOLDER> folderBeanClass, OpenMetadataAPIGenericConverter<FILE> fileConverter, Class<FILE> fileBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.localServerUserId = localServerUserId;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.fileSystemHandler = new SoftwareServerCapabilityHandler<FILESYSTEM>(fileSystemConverter, fileSystemBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.folderHandler = new AssetHandler<FOLDER>(folderConverter, folderBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.fileHandler = new AssetHandler<FILE>(fileConverter, fileBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        OpenMetadataAPIDummyBeanConverter dummyConverter = new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName);
        this.connectionHandler = new ConnectionHandler<OpenMetadataAPIDummyBean>(dummyConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler<OpenMetadataAPIDummyBean>(dummyConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.endpointHandler = new EndpointHandler<OpenMetadataAPIDummyBean>(dummyConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        OpenMetadataAPIDummyBeanConverter dummySchemaAttributeConverter = new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName);
        this.schemaAttributeHandler = new SchemaAttributeHandler<OpenMetadataAPIDummyBean, OpenMetadataAPIDummyBean>(dummySchemaAttributeConverter, OpenMetadataAPIDummyBean.class, dummySchemaAttributeConverter, OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String getFileSystemName(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileSystemDivider)).length > 1) {
            result = tokens[0] + fileSystemDivider;
        }
        return result;
    }

    private List<String> getFolderNames(String pathName) {
        String[] tokens;
        ArrayList<String> result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(folderDivider)).length > 1) {
            int startingToken = 0;
            if (this.getFileSystemName(pathName) != null) {
                startingToken = 2;
            }
            int endingToken = tokens.length;
            if (this.getFileName(pathName) != null) {
                --endingToken;
            }
            if (startingToken != endingToken) {
                result = new ArrayList<String>(Arrays.asList(tokens).subList(startingToken, endingToken));
            }
        }
        return result;
    }

    private String getFileName(String pathName) {
        String result = null;
        if (pathName != null && !pathName.isEmpty()) {
            String[] tokens = pathName.split(folderDivider);
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String getFileType(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileTypeDivider)).length > 1) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileSystemHandler.createFileSystem(userId, externalSourceGUID, externalSourceName, uniqueName, displayName, description, type, version, patchLevel, source, format, encryption, additionalProperties, vendorProperties, methodName);
    }

    private String createFolder(String userId, String externalSourceGUID, String externalSourceName, String pathName, String displayName, String description, String typeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderAssetTypeName = "FileFolder";
        if (typeName != null) {
            folderAssetTypeName = typeName;
        }
        String folderAssetTypeGUID = this.invalidParameterHandler.validateTypeName(folderAssetTypeName, "FileFolder", this.serviceName, methodName, this.repositoryHelper);
        return this.folderHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, pathName, displayName, description, null, null, 0, null, null, null, null, folderAssetTypeGUID, folderAssetTypeName, null, methodName);
    }

    private String createFileAsset(String userId, String externalSourceGUID, String externalSourceName, String fileType, String pathName, String displayName, String description, String typeName, Map<String, Object> initialExtendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        HashMap<String, Object> extendedProperties = new HashMap<String, String>();
        if (initialExtendedProperties != null) {
            extendedProperties = new HashMap<String, Object>(initialExtendedProperties);
        }
        extendedProperties.put("fileType", fileType);
        String fileAssetTypeName = "DataFile";
        if (typeName != null) {
            fileAssetTypeName = typeName;
        }
        String fileAssetTypeGUID = this.invalidParameterHandler.validateTypeName(fileAssetTypeName, "DataFile", this.serviceName, methodName, this.repositoryHelper);
        return this.fileHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, pathName, displayName, description, null, null, 0, null, null, null, null, fileAssetTypeGUID, fileAssetTypeName, extendedProperties, methodName);
    }

    private String createFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String pathName, String folderName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectToParameterName = "connectToGUID";
        String folderParameterName = "folderGUID";
        String folderGUID = this.createFolder(userId, externalSourceGUID, externalSourceName, pathName, folderName, null, "FileFolder", methodName);
        if (connectToGUID != null) {
            if (this.repositoryHandler.isEntityATypeOf(userId, connectToGUID, "connectToGUID", "SoftwareServerCapability", methodName)) {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectToGUID, "connectToGUID", "SoftwareServerCapability", folderGUID, "folderGUID", "FileFolder", "92b75926-8e9a-46c7-9d98-89009f622397", "ServerAssetUse", null, methodName);
            } else {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectToGUID, "connectToGUID", "FileFolder", folderGUID, "folderGUID", "FileFolder", "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", null, methodName);
            }
        }
        return folderGUID;
    }

    private List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String fileSystemName, List<String> folderNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> folderGUIDs = new ArrayList<String>();
        if (folderNames != null && !folderNames.isEmpty()) {
            String pathName = null;
            String folderName = null;
            String nextConnectToGUID = connectToGUID;
            for (String folderFragment : folderNames) {
                pathName = pathName == null ? (fileSystemName != null ? fileSystemName + folderFragment : folderFragment) : pathName + folderDivider + folderFragment;
                folderName = folderName != null ? folderName + folderDivider + folderFragment : folderFragment;
                String currentFolderGUID = this.getFolderGUIDByPathName(userId, pathName, methodName);
                if (currentFolderGUID == null) {
                    String folderGUID = this.createFolderInCatalog(userId, externalSourceGUID, externalSourceName, nextConnectToGUID, pathName, folderName, methodName);
                    folderGUIDs.add(folderGUID);
                    nextConnectToGUID = folderGUID;
                    continue;
                }
                folderGUIDs.add(currentFolderGUID);
                nextConnectToGUID = currentFolderGUID;
            }
        }
        if (folderGUIDs.isEmpty()) {
            return null;
        }
        return folderGUIDs;
    }

    public List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String connectToGUID, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, externalSourceGUID, externalSourceName, connectToGUID, this.getFileSystemName(pathName), this.getFolderNames(pathName), methodName);
    }

    public List<String> createFolderStructureInCatalog(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, this.getFolderNames(pathName), methodName);
    }

    public void attachFolderToFileSystem(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemGUIDParameterName, String folderGUID, String folderGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemGUIDParameterName, "SoftwareServerCapability", folderGUID, folderGUIDParameterName, "FileFolder", "92b75926-8e9a-46c7-9d98-89009f622397", "ServerAssetUse", null, methodName);
    }

    public void detachFolderFromFileSystem(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemGUIDParameterName, String folderGUID, String folderGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemGUIDParameterName, "SoftwareServerCapability", folderGUID, folderGUIDParameterName, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", "92b75926-8e9a-46c7-9d98-89009f622397", "ServerAssetUse", methodName);
    }

    public void attachDataFileAssetToFolder(String userId, String externalSourceGUID, String externalSourceName, String folderGUID, String folderGUIDParameterName, String fileGUID, String fileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.fileHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, folderGUID, folderGUIDParameterName, "FileFolder", fileGUID, fileGUIDParameterName, "DataFile", "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, methodName);
    }

    public void detachDataFileAssetFromFolder(String userId, String externalSourceGUID, String externalSourceName, String folderGUID, String folderGUIDParameterName, String fileGUID, String fileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.folderHandler.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, "DataFile", folderGUID, folderGUIDParameterName, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", methodName);
    }

    public void moveDataFileInCatalog(String userId, String externalSourceGUID, String externalSourceName, String newParentFolder, String newParentFolderGUIDParameterName, String fileGUID, String fileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUIDParameterName = "endpointGUID";
        String newFolderPathName = this.folderHandler.getBeanStringPropertyFromRepository(userId, newParentFolder, newParentFolderGUIDParameterName, "FileFolder", "qualifiedName", methodName);
        String existingFilePathName = this.fileHandler.getBeanStringPropertyFromRepository(userId, newParentFolder, newParentFolderGUIDParameterName, "DataFile", "qualifiedName", methodName);
        String fileName = this.getFileName(existingFilePathName);
        String fullPathName = newFolderPathName + folderDivider + fileName;
        this.fileHandler.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, "DataFile", false, newParentFolder, newParentFolderGUIDParameterName, "FileFolder", "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, methodName);
        this.fileHandler.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, fileGUID, fileGUIDParameterName, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", "qualifiedName", fullPathName, methodName);
        ArrayList<String> relationshipPath = new ArrayList<String>();
        relationshipPath.add("e777d660-8dbe-453e-8b83-903771f054c0");
        relationshipPath.add("887a7132-d6bc-4b92-a483-e80b60c86fb2");
        List<Object> endpointGUIDs = new ArrayList();
        while (endpointGUIDs != null) {
            endpointGUIDs = this.fileHandler.getRelatedEntityGUIDs(userId, fileGUID, fileGUIDParameterName, "10752b4a-4b5d-4519-9eae-fdd6d162122f", relationshipPath, "Endpoint", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            if (endpointGUIDs.isEmpty()) {
                endpointGUIDs = null;
                continue;
            }
            for (String string : endpointGUIDs) {
                if (string == null) continue;
                this.fileSystemHandler.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, string, "endpointGUID", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", "networkAddress", fullPathName, methodName);
            }
        }
    }

    public void moveDataFolderInCatalog(String userId, String externalSourceGUID, String externalSourceName, String newParentFolderGUID, String newParentFolderGUIDParameterName, String movingFolderGUID, String movingFolderGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(newParentFolderGUID, newParentFolderGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(movingFolderGUID, movingFolderGUIDParameterName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    private List<String> addFileAssetPath(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String fileAssetGUID, String fileAssetParameterName, String pathName, String pathNameParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> assetGUIDList = new ArrayList<String>();
        if (fileSystemName != null && (fileSystemGUID = this.fileSystemHandler.getBeanGUIDByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", fileSystemName, pathNameParameterName, methodName)) == null) {
            fileSystemGUID = this.fileSystemHandler.createFileSystem(this.localServerUserId, externalSourceGUID, externalSourceName, fileSystemName, fileSystemName, null, null, null, null, null, null, null, null, null, methodName);
        }
        List<String> folderNames = this.getFolderNames(pathName);
        List<String> folderGUIDs = null;
        String fileParentGUID = folderNames == null ? fileSystemGUID : ((folderGUIDs = this.createFolderStructureInCatalog(this.localServerUserId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, folderNames, methodName)) != null && !folderGUIDs.isEmpty() ? folderGUIDs.get(folderGUIDs.size() - 1) : fileSystemGUID);
        if (fileAssetGUID != null && fileParentGUID != null) {
            if (fileParentGUID.equals(fileSystemGUID)) {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileParentGUID, pathNameParameterName, "SoftwareServerCapability", fileAssetGUID, fileAssetParameterName, "DataFile", "92b75926-8e9a-46c7-9d98-89009f622397", "ServerAssetUse", null, methodName);
            } else {
                this.folderHandler.linkElementToElement(userId, externalSourceGUID, externalSourceName, fileParentGUID, pathNameParameterName, "FileFolder", fileAssetGUID, fileAssetParameterName, "DataFile", "4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", null, methodName);
            }
        }
        if (fileSystemGUID != null) {
            assetGUIDList.add(fileSystemGUID);
        }
        if (folderGUIDs != null) {
            assetGUIDList.addAll(folderGUIDs);
        }
        if (fileAssetGUID != null) {
            assetGUIDList.add(fileAssetGUID);
        }
        if (assetGUIDList.isEmpty()) {
            return null;
        }
        return assetGUIDList;
    }

    public List<String> addDataFileAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileType = this.getFileType(pathName);
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, pathName, displayName, description, "DataFile", null, methodName);
        this.addDataFileConnection(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", pathName, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, fileAssetGUID, "fileAssetGUID", pathName, "pathName", methodName);
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        String folderAssetParameterName = "folderAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String folderAssetGUID = this.createFolder(userId, externalSourceGUID, externalSourceName, pathName, displayName, description, "DataFolder", methodName);
        this.addDataFolderConnection(userId, externalSourceGUID, externalSourceName, folderAssetGUID, "folderAssetGUID", pathName, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, folderAssetGUID, "folderAssetGUID", pathName, "pathName", methodName);
    }

    public List<String> addFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String fullPath, String displayName, String description, Map<String, String> additionalProperties, String connectorClassName, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileAssetTypeName;
        String pathParameterName = "fullPath";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        Map<String, Object> assetExtendedProperties = extendedProperties;
        String fileType = this.getFileType(fullPath);
        if (fileType != null) {
            if (assetExtendedProperties == null) {
                assetExtendedProperties = new HashMap<String, Object>();
            }
            assetExtendedProperties.put("fileType", fileType);
        }
        if ((fileAssetTypeName = typeName) == null) {
            fileAssetTypeName = defaultCSVFileType.equals(fileType) ? "CSVFile" : (defaultAvroFileType.equals(fileType) ? "AvroFile" : "DataFile");
        }
        String fileAssetTypeGUID = this.invalidParameterHandler.validateTypeName(fileAssetTypeName, "DataFile", this.serviceName, methodName, this.repositoryHelper);
        String fileAssetGUID = this.fileHandler.createAssetInRepository(userId, externalSourceGUID, externalSourceName, fullPath, displayName, description, null, null, 0, null, null, null, additionalProperties, fileAssetTypeGUID, fileAssetTypeName, assetExtendedProperties, methodName);
        this.addConnectionForFile(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fileType, fullPath, connectorClassName, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, fileAssetGUID, "fileAssetGUID", fullPath, "fullPath", methodName);
    }

    public List<String> addAvroFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String displayName, String description, String fullPath, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        String fileAssetParameterName = "fileAssetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultAvroFileType;
        }
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fullPath, displayName, description, "AvroFile", null, methodName);
        this.addAvroFileConnection(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fullPath, methodName);
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, fileAssetGUID, "fileAssetGUID", fullPath, "fullPath", methodName);
    }

    public List<String> addCSVFileToCatalog(String userId, String externalSourceGUID, String externalSourceName, String fileSystemGUID, String fileSystemName, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        String fileAssetGUIDParameterName = "fileAssetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultCSVFileType;
        }
        if (delimiterCharacter == null) {
            delimiterCharacter = Character.valueOf(',');
        }
        if (quoteCharacter == null) {
            quoteCharacter = Character.valueOf('\"');
        }
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        extendedProperties.put("delimiterCharacter", delimiterCharacter.toString());
        extendedProperties.put("quoteCharacter", quoteCharacter.toString());
        extendedProperties.put("fileType", fileType);
        String fileAssetGUID = this.createFileAsset(userId, externalSourceGUID, externalSourceName, fileType, fullPath, displayName, description, "CSVFile", extendedProperties, methodName);
        this.addCSVFileConnection(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", fullPath, columnHeaders, delimiterCharacter, quoteCharacter, methodName);
        if (columnHeaders != null && !columnHeaders.isEmpty()) {
            String schemaTypeGUID = this.schemaAttributeHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, fileAssetGUID, "fileAssetGUID", "CSVFile", "248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", methodName);
            int columnCount = 0;
            for (String columnName : columnHeaders) {
                if (columnName == null) continue;
                String columnQualifiedName = "qualifiedName::" + columnName;
                SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(columnQualifiedName, columnQualifiedName, null, columnCount, 1, 1, false, null, true, false, 0, 0, 0, 0, false, null, null, null, "d81a0425-4e9b-4f31-bc1c-e18c3566da10", "TabularColumn", extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
                ++columnCount;
                schemaAttributeBuilder.setAnchors(userId, fileAssetGUID, methodName);
                SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(columnQualifiedName + ":columnType", "a7392281-348d-48a4-bad7-f9742d7696fe", "TabularColumnType", this.repositoryHelper, this.serviceName, this.serverName);
                schemaTypeBuilder.setDataType("String");
                schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
                this.schemaAttributeHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", "CSVFile", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", columnQualifiedName, "qualifiedName", schemaAttributeBuilder, methodName);
            }
        }
        return this.addFileAssetPath(userId, externalSourceGUID, externalSourceName, fileSystemGUID, fileSystemName, fileAssetGUID, "fileAssetGUID", fullPath, "fullPath", methodName);
    }

    private void addConnectionForFile(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String fileType, String fullPath, String connectorClassName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String providerClass = connectorClassName;
        if (providerClass == null) {
            if (defaultCSVFileType.equals(fileType)) {
                providerClass = csvFileStoreProvider.getClass().getName();
            } else if (defaultAvroFileType.equals(fileType)) {
                providerClass = avroFileStoreProvider.getClass().getName();
            }
        }
        String endpointName = "File.Endpoint." + fullPath;
        String connectionName = fullPath + " File Connection";
        this.addAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, fullPath, connectionName, null, providerClass, endpointName, methodName);
    }

    private void addDataFileConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String fileName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String endpointName = "FileStore.Endpoint." + fileName;
        String connectionName = fileName + " File Store Connection";
        this.addAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, fileName, connectionName, null, basicFileStoreProvider.getClass().getName(), endpointName, methodName);
    }

    private void addCSVFileConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String fileName, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String endpointName = "CSVFileStore.Endpoint." + fileName;
        String connectionName = fileName + " CSV File Store Connection";
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        if (delimiterCharacter != null) {
            configurationProperties.put("delimiterCharacter", delimiterCharacter);
        }
        if (quoteCharacter != null) {
            configurationProperties.put("quoteCharacter", quoteCharacter);
        }
        if (columnHeaders != null) {
            configurationProperties.put("columnNames", columnHeaders);
        }
        if (configurationProperties.isEmpty()) {
            configurationProperties = null;
        }
        this.addAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, fileName, connectionName, configurationProperties, csvFileStoreProvider.getClass().getName(), endpointName, methodName);
    }

    private void addAvroFileConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String fileName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String endpointName = "AvroFileStore.Endpoint." + fileName;
        String connectionName = fileName + " Avro File Store Connection";
        this.addAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, fileName, connectionName, null, avroFileStoreProvider.getClass().getName(), endpointName, methodName);
    }

    private void addDataFolderConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String folderName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String endpointName = "DataFolder.Endpoint." + folderName;
        String connectionName = folderName + " Data Folder Connection";
        this.addAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, folderName, connectionName, null, dataFolderProvider.getClass().getName(), endpointName, methodName);
    }

    private void addAssetConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String fullPathName, String connectionName, Map<String, Object> configurationProperties, String connectorProviderClassName, String endpointName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String endpointGUIDParameterName = "endpointGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        String endpointGUID = this.getEndpoint(userId, externalSourceGUID, externalSourceName, assetGUID, endpointName, fullPathName, methodName);
        String connectorTypeGUID = this.getConnectorType(userId, externalSourceGUID, externalSourceName, connectorProviderClassName, methodName);
        this.connectionHandler.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, null, connectionName, connectionName, null, null, null, configurationProperties, null, null, null, connectorTypeGUID, "connectorTypeGUID", endpointGUID, "endpointGUID", methodName);
    }

    private String getConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectorProviderClassName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ConnectorType connectorType;
        if (connectorProviderClassName == null) {
            connectorType = basicFileStoreProvider.getConnectorType();
        } else if (basicFileStoreProvider.getClass().getName().equals(connectorProviderClassName)) {
            connectorType = basicFileStoreProvider.getConnectorType();
        } else if (dataFolderProvider.getClass().getName().equals(connectorProviderClassName)) {
            connectorType = dataFolderProvider.getConnectorType();
        } else if (avroFileStoreProvider.getClass().getName().equals(connectorProviderClassName)) {
            connectorType = avroFileStoreProvider.getConnectorType();
        } else if (csvFileStoreProvider.getClass().getName().equals(connectorProviderClassName)) {
            connectorType = csvFileStoreProvider.getConnectorType();
        } else {
            connectorType = new ConnectorType();
            connectorType.setConnectorProviderClassName(connectorProviderClassName);
        }
        return this.connectorTypeHandler.getConnectorTypeForConnection(userId, externalSourceGUID, externalSourceName, null, connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorProviderClassName, connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), methodName);
    }

    private String getEndpoint(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String endpointName, String fileName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String endpointDescription = "Access information to connect to the actual asset: ";
        return this.endpointHandler.getEndpointForConnection(userId, externalSourceGUID, externalSourceName, assetGUID, endpointName, endpointName, "Access information to connect to the actual asset: " + fileName, fileName, null, null, null, methodName);
    }

    public FILESYSTEM getFileSystemByGUID(String userId, String softwareServerCapabilityGUID, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILESYSTEM)this.fileSystemHandler.getBeanFromRepository(userId, softwareServerCapabilityGUID, guidParameterName, "SoftwareServerCapability", methodName);
    }

    public FILESYSTEM getFileSystemByUniqueName(String userId, String uniqueName, String parameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILESYSTEM)this.fileSystemHandler.getBeanByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", uniqueName, parameterName, methodName);
    }

    public List<String> getFileSystems(String userId, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileSystemHandler.getSoftwareServerCapabilityGUIDsByClassification(userId, "FileSystem", startingFrom, pageSize, methodName);
    }

    public FOLDER getFolderByGUID(String userId, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "folderGUID";
        return (FOLDER)this.folderHandler.getBeanFromRepository(userId, folderGUID, "folderGUID", "FileFolder", methodName);
    }

    public String getFolderGUIDByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        return this.folderHandler.getBeanGUIDByQualifiedName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", pathName, "pathName", methodName);
    }

    public FOLDER getFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        return (FOLDER)this.folderHandler.getBeanByQualifiedName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", pathName, "pathName", methodName);
    }

    public List<FOLDER> findFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        return this.folderHandler.findBeansByQualifiedName(pathName, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", pathName, "pathName", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
    }

    public List<FOLDER> findFolderByName(String userId, String name, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "name";
        return this.folderHandler.findAssetsByName(userId, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", name, "name", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
    }

    public List<String> getNestedFolders(String userId, String parentFolderGUID, String parentFolderParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.folderHandler.getAttachedElementGUIDs(userId, parentFolderGUID, parentFolderParameterName, "FileFolder", "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", "FileFolder", startingFrom, pageSize, methodName);
    }

    public List<String> getFolderFiles(String userId, String folderGUID, String folderGUIDParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.getAttachedElementGUIDs(userId, folderGUID, folderGUIDParameterName, "FileFolder", "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", "FileFolder", startingFrom, pageSize, methodName);
    }

    public FILE getDataFileByGUID(String userId, String dataFileGUID, String dataFileGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILE)this.fileHandler.getBeanFromRepository(userId, dataFileGUID, dataFileGUIDParameterName, "DataFile", methodName);
    }

    public FILE getDataFileByPathName(String userId, String pathName, String pathNameParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (FILE)this.fileHandler.getBeanByQualifiedName(userId, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", pathName, pathNameParameterName, methodName);
    }

    public List<FILE> findDataFileByPathName(String userId, String pathName, String pathNameParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.findBeansByQualifiedName(userId, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", pathName, pathNameParameterName, startingFrom, pageSize, methodName);
    }

    public List<FILE> findDataFilesByName(String userId, String name, String nameParameterName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.fileHandler.findAssetsByName(userId, "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", name, nameParameterName, startingFrom, pageSize, methodName);
    }
}

