/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossary(String userId, String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = "Glossary";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Glossary", this.serviceName, methodName, this.repositoryHelper);
        GlossaryBuilder glossaryBuilder = new GlossaryBuilder(qualifiedName, displayName, description, language, usage, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, null, null, typeGUID, typeName, qualifiedName, "qualifiedName", glossaryBuilder, methodName);
    }

    public String createGlossaryFromTemplate(String userId, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryBuilder glossaryBuilder = new GlossaryBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, null, null, templateGUID, "templateGUID", "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", qualifiedName, "qualifiedName", glossaryBuilder, methodName);
    }

    public void updateGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "Glossary", this.serviceName, methodName, this.repositoryHelper);
        GlossaryBuilder glossaryBuilder = new GlossaryBuilder(qualifiedName, displayName, description, language, usage, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, glossaryGUID, glossaryGUIDParameterName, typeGUID, typeName, glossaryBuilder.getInstanceProperties(methodName), false, methodName);
    }

    public void addTaxonomyClassificationToGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, String organizingPrinciple, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "37116c51-e6c9-4c37-942e-35d48c8c69a0", "Taxonomy", builder.getTaxonomyProperties(organizingPrinciple, methodName), methodName);
    }

    public void removeTaxonomyClassificationFromGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "37116c51-e6c9-4c37-942e-35d48c8c69a0", "37116c51-e6c9-4c37-942e-35d48c8c69a0", methodName);
    }

    public void addCanonicalVocabClassificationToGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, String scope, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "33ad3da2-0910-47be-83f1-daee018a4c05", "CanonicalVocabulary", builder.getCanonicalVocabularyProperties(scope, methodName), methodName);
    }

    public void removeCanonicalVocabClassificationFromGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", "33ad3da2-0910-47be-83f1-daee018a4c05", "CanonicalVocabulary", methodName);
    }

    public void removeGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, null, null, glossaryGUID, glossaryGUIDParameterName, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", null, null, methodName);
    }

    public List<B> findGlossaries(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", startFrom, pageSize, methodName);
    }

    public List<B> getGlossariesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        specificMatchPropertyNames.add("displayName");
        return this.getBeansByValue(userId, name, nameParameterName, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", specificMatchPropertyNames, true, null, null, startFrom, pageSize, methodName);
    }

    public B getGlossaryByGUID(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "Glossary", methodName);
    }
}

