/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class GlossaryTermBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String summary = null;
    private String examples = null;
    private String abbreviation = null;
    private String usage = null;

    GlossaryTermBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", repositoryHelper, serviceName, serverName);
    }

    GlossaryTermBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    GlossaryTermBuilder(String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, InstanceStatus initialStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", extendedProperties, initialStatus, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.summary = summary;
        this.description = description;
        this.examples = examples;
        this.abbreviation = abbreviation;
        this.usage = usage;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.summary != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "summary", this.description, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.examples != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "examples", this.description, methodName);
        }
        if (this.abbreviation != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "abbreviation", this.description, methodName);
        }
        if (this.usage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "usage", this.description, methodName);
        }
        return properties;
    }

    InstanceProperties getActivityTypeProperties(int activityType, String methodName) throws InvalidParameterException {
        try {
            return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "activityType", "af7e403d-9865-4ebb-8c1a-1fd57b4f4bca", "ActivityType", activityType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "activityType");
        }
    }

    InstanceProperties getContextDescriptionProperties(String description, String scope, String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        if (scope != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "scope", description, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        return properties;
    }

    InstanceProperties getTermCategorizationProperties(String description, int relationshipStatus, String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "status", "42282652-7d60-435e-ad3e-7cfe5291bcc7", "TermRelationshipStatus", relationshipStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "activityType");
        }
        return properties;
    }

    InstanceProperties getTermRelationshipProperties(String expression, String description, int relationshipStatus, String steward, String source, String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        if (expression != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "expression", description, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "status", "42282652-7d60-435e-ad3e-7cfe5291bcc7", "TermRelationshipStatus", relationshipStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "activityType");
        }
        if (steward != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", description, methodName);
        }
        if (source != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", description, methodName);
        }
        return properties;
    }
}

