/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public InformalTagHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int countTags(String userId, String elementGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.countAttachments(userId, elementGUID, "Referenceable", "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", methodName);
    }

    public List<B> getAttachedTags(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", "InformalTag", this.supportedZones, startingFrom, pageSize, methodName);
    }

    public List<B> getAttachedTags(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", "InformalTag", serviceSupportedZones, startingFrom, pageSize, methodName);
    }

    public String createTag(String userId, String externalSourceGUID, String externalSourceName, String tagName, String tagDescription, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "tagName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(tagName, "tagName", methodName);
        InformalTagBuilder builder = new InformalTagBuilder(tagName, tagDescription, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, null, builder, methodName);
    }

    public void updateTagDescription(String userId, String externalSourceGUID, String externalSourceName, String tagGUID, String tagGUIDParameterName, String tagDescription, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "tagDescription", tagDescription, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, tagGUID, tagGUIDParameterName, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", this.supportedZones, properties, false, methodName);
    }

    public void deleteTag(String userId, String externalSourceGUID, String externalSourceName, String tagGUID, String tagGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, tagGUID, tagGUIDParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, null, this.supportedZones, methodName);
    }

    public void deleteTag(String userId, String externalSourceGUID, String externalSourceName, String tagGUID, String tagGUIDParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, tagGUID, tagGUIDParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, null, serviceSupportedZones, methodName);
    }

    public B getTag(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "InformalTag", this.supportedZones, methodName);
    }

    public B getTag(String userId, String guid, String guidParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "InformalTag", serviceSupportedZones, methodName);
    }

    public List<B> getTagsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("tagName");
        return this.getBeansByValue(userId, name, nameParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", propertyNames, true, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> getMyTagsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("tagName");
        return this.getBeansByCreator(userId, name, nameParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", propertyNames, true, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findTags(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, false, this.supportedZones, startFrom, pageSize, methodName);
    }

    public List<B> findMyTags(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByCreator(userId, searchString, searchStringParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, false, this.supportedZones, startFrom, pageSize, methodName);
    }

    public void addTagToElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String tagGUID, String tagGUIDParameterName, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.addTagToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, tagGUID, tagGUIDParameterName, this.supportedZones, isPublic, methodName);
    }

    public void addTagToElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String tagGUID, String tagGUIDParameterName, List<String> suppliedSupportedZones, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isPublic", isPublic, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, tagGUID, tagGUIDParameterName, "InformalTag", suppliedSupportedZones, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", properties, methodName);
    }

    public void removeTagFromElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String tagGUID, String tagGUIDParameterName, List<String> suppliedSupportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, tagGUID, tagGUIDParameterName, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", suppliedSupportedZones, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", methodName);
    }
}

