/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class OpenMetadataAPIGenericBuilder {
    protected RepositoryErrorHandler errorHandler;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;
    protected Map<String, Object> extendedProperties;
    protected String typeGUID;
    protected String typeName;
    protected InstanceStatus instanceStatus;
    protected List<Classification> existingClassifications;
    protected Map<String, Classification> newClassifications = new HashMap<String, Classification>();
    protected InstanceProperties properties = null;

    protected OpenMetadataAPIGenericBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this(typeGUID, typeName, null, null, null, repositoryHelper, serviceName, serverName);
    }

    protected OpenMetadataAPIGenericBuilder(String typeGUID, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, List<Classification> existingClassifications, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        TypeDef typeDef;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.typeGUID = typeGUID;
        this.typeName = typeName;
        this.extendedProperties = extendedProperties;
        this.instanceStatus = instanceStatus;
        this.existingClassifications = existingClassifications;
        if (this.typeName == null) {
            this.typeName = "Referenceable";
        }
        if (this.typeGUID == null && (typeDef = repositoryHelper.getTypeDefByName(serviceName, this.typeName)) != null) {
            this.typeGUID = typeDef.getGUID();
        }
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName);
    }

    public void setClassification(Classification newClassification) {
        this.newClassifications.put(newClassification.getName(), newClassification);
    }

    public void setTemplateClassifications(String userId, String externalSourceGUID, String externalSourceName, List<Classification> templateClassifications, String methodName) throws InvalidParameterException {
        if (templateClassifications == null) {
            this.newClassifications = new HashMap<String, Classification>();
        } else {
            InstanceProvenanceType instanceProvenanceType = InstanceProvenanceType.LOCAL_COHORT;
            if (externalSourceGUID != null) {
                instanceProvenanceType = InstanceProvenanceType.EXTERNAL_SOURCE;
            }
            for (Classification templateClassification : templateClassifications) {
                if (templateClassification == null) continue;
                try {
                    Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, externalSourceGUID, externalSourceName, instanceProvenanceType, userId, templateClassification.getName(), this.typeName, ClassificationOrigin.ASSIGNED, null, templateClassification.getProperties());
                    this.newClassifications.put(classification.getName(), classification);
                }
                catch (TypeErrorException error) {
                    this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "Anchors");
                }
            }
        }
    }

    public void setAnchors(String userId, String anchorGUID, String methodName) {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "Anchors", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getAnchorsProperties(anchorGUID, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedAnchorsType((Throwable)error, methodName, "Anchors");
        }
    }

    private InstanceProperties getAnchorsProperties(String anchorGUID, String methodName) {
        InstanceProperties properties = null;
        if (anchorGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "anchorGUID", anchorGUID, methodName);
        }
        return properties;
    }

    public void setLatestChange(String userId, int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String actionDescription, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "LatestChange", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getLatestChangeProperties(latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationName, attachmentGUID, attachmentTypeName, relationshipTypeName, userId, actionDescription, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "LatestChange");
        }
    }

    private InstanceProperties getLatestChangeProperties(int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "changeTarget", "a0b7d7a0-4af5-4539-9b81-cbef52d8cc5d", "LatestChangeTarget", latestChangeTargetOrdinal, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "LatestChangeTarget");
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "changeAction", "032d844b-868f-4c4a-bc5d-81f0f9704c4d", "LatestChangeAction", latestChangeActionOrdinal, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "LatestChangeAction");
        }
        if (classificationName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "classificationName", classificationName, methodName);
        }
        if (attachmentGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "attachmentGUID", attachmentGUID, methodName);
        }
        if (attachmentTypeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "attachmentType", attachmentTypeName, methodName);
        }
        if (userId != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "user", userId, methodName);
        }
        if (relationshipTypeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "relationshipType", relationshipTypeName, methodName);
        }
        if (actionDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", actionDescription, methodName);
        }
        return properties;
    }

    void setTemplateProperties(InstanceProperties templateProperties) {
        this.properties = templateProperties;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeGUID() {
        return this.typeGUID;
    }

    public InstanceStatus getInstanceStatus() {
        return this.instanceStatus;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        if (this.extendedProperties != null) {
            try {
                this.properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, this.extendedProperties, methodName);
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Throwable)error, methodName, "extendedProperties");
            }
        }
        return this.properties;
    }

    public List<Classification> getEntityClassifications(String userId, String methodName) throws InvalidParameterException {
        ArrayList<Classification> entityClassifications = new ArrayList<Classification>();
        if (this.newClassifications != null && !this.newClassifications.isEmpty()) {
            entityClassifications = new ArrayList<Classification>(this.newClassifications.values());
        }
        if (this.existingClassifications != null && !this.existingClassifications.isEmpty()) {
            for (Classification classification : entityClassifications) {
                if (classification == null || this.newClassifications.get(classification.getName()) != null) continue;
                entityClassifications.add(classification);
            }
        }
        if (entityClassifications.isEmpty()) {
            return null;
        }
        return entityClassifications;
    }

    private Classification getEntityClassification(String classificationName, String methodName) throws InvalidParameterException {
        if (classificationName == null) {
            String parameterName = "classificationName";
            this.errorHandler.handleUnsupportedParameter(methodName, "classificationName", null);
            return null;
        }
        Classification result = this.newClassifications.get(classificationName);
        if (result == null && this.existingClassifications != null) {
            for (Classification classification : this.existingClassifications) {
                if (classification == null || !classificationName.equals(classification.getName())) continue;
                return classification;
            }
        }
        return result;
    }

    public InstanceAuditHeader getExistingEntityClassificationHeader(String elementClassificationName, String methodName) throws InvalidParameterException {
        return this.getEntityClassification(elementClassificationName, methodName);
    }

    public InstanceProperties getEntityClassificationProperties(String elementClassificationName, String methodName) throws InvalidParameterException {
        Classification entityClassification = this.getEntityClassification(elementClassificationName, methodName);
        if (entityClassification != null) {
            return entityClassification.getProperties();
        }
        return null;
    }
}

