/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.AssetBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ProcessBuilder
extends AssetBuilder {
    private String formula = null;
    private String implementationLanguage = null;

    ProcessBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("486af62c-dcfd-4859-ab24-eab2e380ecfd", "DeployedSoftwareComponent", repositoryHelper, serviceName, serverName);
    }

    ProcessBuilder(String qualifiedName, String technicalName, String technicalDescription, String formula, String implementationLanguage, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, technicalName, technicalDescription, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.formula = formula;
        this.implementationLanguage = implementationLanguage;
    }

    InstanceProperties getDataFlowProperties(String qualifiedName, String description, String formula, String methodName) {
        InstanceProperties properties = null;
        if (qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        if (formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", formula, methodName);
        }
        return properties;
    }

    InstanceProperties getControlFlowProperties(String qualifiedName, String description, String guard, String methodName) {
        InstanceProperties properties = null;
        if (qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        if (guard != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "guard", guard, methodName);
        }
        return properties;
    }

    InstanceProperties getProcessCallProperties(String qualifiedName, String description, String formula, String methodName) {
        InstanceProperties properties = null;
        if (qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, methodName);
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, methodName);
        }
        if (formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", formula, methodName);
        }
        return properties;
    }

    @Override
    void setAssetOwnership(String userId, String owner, int ownerType, String methodName) throws InvalidParameterException {
        if (owner != null) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetOwnership", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOwnerProperties(userId, owner, ownerType, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOwnership");
            }
        }
    }

    @Override
    InstanceProperties getOwnerProperties(String userId, String owner, int ownerType, String methodName) throws InvalidParameterException {
        InstanceProperties properties;
        if (owner != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "owner", owner, methodName);
            try {
                properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "ownerType", "9548390c-69f5-4dc6-950d-6feeee257b56", "AssetOwnerType", 0, methodName);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOwnerType");
            }
        } else {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "owner", userId, methodName);
            try {
                properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "ownerType", "9548390c-69f5-4dc6-950d-6feeee257b56", "AssetOwnerType", ownerType, methodName);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOwnerType");
            }
        }
        return properties;
    }

    @Override
    void setAssetOrigin(String userId, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues, String methodName) throws InvalidParameterException {
        if (organizationGUID != null || businessCapabilityGUID != null || otherOriginValues != null && !otherOriginValues.isEmpty()) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "AssetOrigin", this.typeName, ClassificationOrigin.ASSIGNED, null, this.getOriginProperties(organizationGUID, businessCapabilityGUID, otherOriginValues, methodName));
                this.newClassifications.put(classification.getName(), classification);
            }
            catch (TypeErrorException error) {
                this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "AssetOrigin");
            }
        }
    }

    @Override
    InstanceProperties getOriginProperties(String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues, String methodName) {
        InstanceProperties properties = null;
        if (organizationGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "organization", organizationGUID, methodName);
        }
        if (businessCapabilityGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapability", businessCapabilityGUID, methodName);
        }
        if (otherOriginValues != null && !otherOriginValues.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "otherOriginValues", otherOriginValues, methodName);
        }
        return properties;
    }

    @Override
    void setReferenceData(String userId, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "ReferenceData", this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "ReferenceData");
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", this.formula, methodName);
        }
        if (this.implementationLanguage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "implementationLanguage", this.implementationLanguage, methodName);
        }
        return properties;
    }
}

