/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class SchemaAttributeBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private int elementPosition = 0;
    private int minCardinality = 0;
    private int maxCardinality = 0;
    private boolean isDeprecated = false;
    private String cardinality = null;
    private boolean allowsDuplicateValues = false;
    private boolean orderedValues = false;
    private int sortOrder = 0;
    private int minimumLength = 0;
    private int length = 0;
    private int significantDigits = 0;
    private boolean isNullable = true;
    private String defaultValueOverride = null;
    private String nativeJavaClass = null;
    private List<String> aliases = null;
    private String formula = null;
    private SchemaTypeBuilder schemaTypeBuilder = null;

    public SchemaAttributeBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public SchemaAttributeBuilder(String qualifiedName, String displayName, String description, int elementPosition, int minCardinality, int maxCardinality, boolean isDeprecated, String defaultValueOverride, boolean allowsDuplicateValues, boolean orderedValues, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.elementPosition = elementPosition;
        this.cardinality = null;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
        this.isDeprecated = isDeprecated;
        this.defaultValueOverride = defaultValueOverride;
        this.allowsDuplicateValues = allowsDuplicateValues;
        this.orderedValues = orderedValues;
        this.sortOrder = sortOrder;
        this.minimumLength = minimumLength;
        this.length = length;
        this.significantDigits = significantDigits;
        this.isNullable = isNullable;
        this.nativeJavaClass = nativeJavaClass;
        this.aliases = aliases;
    }

    public void setSchemaType(String userId, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException {
        this.schemaTypeBuilder = schemaTypeBuilder;
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "TypeEmbeddedAttribute", schemaTypeBuilder.getTypeName(), ClassificationOrigin.ASSIGNED, null, schemaTypeBuilder.getTypeEmbeddedInstanceProperties(methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "TypeEmbeddedAttribute");
        }
    }

    public SchemaTypeBuilder getSchemaTypeBuilder() {
        return this.schemaTypeBuilder;
    }

    void setCalculatedValue(String userId, String externalSourceGUID, String externalSourceName, String formula, String methodName) throws InvalidParameterException {
        try {
            InstanceProvenanceType instanceProvenanceType = InstanceProvenanceType.LOCAL_COHORT;
            if (externalSourceGUID != null) {
                instanceProvenanceType = InstanceProvenanceType.EXTERNAL_SOURCE;
            }
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, externalSourceGUID, externalSourceName, instanceProvenanceType, userId, "CalculatedValue", formula, ClassificationOrigin.ASSIGNED, null, this.getCalculatedValueProperties(formula, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Throwable)error, methodName, "CalculatedValue");
        }
    }

    private InstanceProperties getCalculatedValueProperties(String formula, String methodName) {
        InstanceProperties properties = null;
        if (formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "formula", formula, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "position", this.elementPosition, methodName);
        if (this.cardinality != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "cardinality", this.cardinality, methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "minCardinality", this.minCardinality, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "maxCardinality", this.maxCardinality, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", this.isDeprecated, methodName);
        if (this.defaultValueOverride != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValueOverride", this.defaultValueOverride, methodName);
        }
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "allowsDuplicateValues", this.allowsDuplicateValues, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "orderedValues", this.orderedValues, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "sortOrder", "aaa4df8f-1aca-4de8-9abd-1ef2aadba300", "DataItemSortOrder", this.sortOrder, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, "sortOrder");
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "minimumLength", this.minimumLength, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "length", this.length, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "significantDigits", this.significantDigits, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isNullable", this.isNullable, methodName);
        if (this.nativeJavaClass != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "nativeClass", this.nativeJavaClass, methodName);
        }
        if (this.aliases != null && !this.aliases.isEmpty()) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "aliases", this.aliases, methodName);
        }
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", this.formula, methodName);
        }
        return properties;
    }
}

