/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CommentBuilder
extends ReferenceableBuilder {
    private int commentType;
    private String commentText;
    private boolean isPublic;

    public CommentBuilder(String qualifiedName, int commentType, String commentText, boolean isPublic, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", repositoryHelper, serviceName, serverName);
        this.commentText = commentText;
        this.commentType = commentType;
        this.isPublic = isPublic;
    }

    public InstanceProperties getRelationshipInstanceProperties(String methodName) {
        return this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isPublic", this.isPublic, methodName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.commentText != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "text", this.commentText, methodName);
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "commentType", "06d5032e-192a-4f77-ade1-a4b97926e867", "CommentType", this.commentType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "commentType");
        }
        return properties;
    }
}

