/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private Map<String, String> securedProperties;
    private Map<String, Object> configurationProperties;
    private String connectorUserId;
    private String clearPassword;
    private String encryptedPassword;

    ConnectionBuilder(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.securedProperties = securedProperties;
        this.configurationProperties = configurationProperties;
        this.connectorUserId = connectorUserId;
        this.clearPassword = clearPassword;
        this.encryptedPassword = encryptedPassword;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.securedProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "securedProperties", this.securedProperties, methodName);
        }
        if (this.configurationProperties != null) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "configurationProperties", this.configurationProperties, methodName);
        }
        if (this.connectorUserId != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "userId", this.connectorUserId, methodName);
        }
        if (this.clearPassword != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "clearPassword", this.clearPassword, methodName);
        }
        if (this.encryptedPassword != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encryptedPassword", this.encryptedPassword, methodName);
        }
        return properties;
    }
}

