/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EndpointHandler<B>
extends ReferenceableHandler<B> {
    public EndpointHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    String findEndpoint(String userId, Endpoint endpoint, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "endpoint.getGUID";
        String qualifiedNameParameter = "endpoint.getQualifiedName";
        String displayNameParameter = "endpoint.getDisplayName";
        if (endpoint != null) {
            if (endpoint.getGUID() != null) {
                try {
                    if (this.getEntityFromRepository(userId, endpoint.getGUID(), "Endpoint", methodName, "endpoint.getGUID") != null) {
                        return endpoint.getGUID();
                    }
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            String retrievedGUID = null;
            if (endpoint.getQualifiedName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, endpoint.getQualifiedName(), "endpoint.getQualifiedName", "qualifiedName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.supportedZones, methodName);
            }
            if (retrievedGUID == null && endpoint.getDisplayName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, endpoint.getDisplayName(), "endpoint.getDisplayName", "name", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.supportedZones, methodName);
            }
            return retrievedGUID;
        }
        return null;
    }

    public String saveEndpoint(String userId, String externalSourceGUID, String externalSourceName, Endpoint endpoint, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String existingEndpointGUID = this.findEndpoint(userId, endpoint, methodName);
        if (existingEndpointGUID == null) {
            return this.createEndpoint(userId, externalSourceGUID, externalSourceName, null, endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), endpoint.getAddress(), endpoint.getProtocol(), endpoint.getEncryptionMethod(), endpoint.getAdditionalProperties(), methodName);
        }
        this.updateEndpoint(userId, externalSourceGUID, externalSourceName, existingEndpointGUID, null, endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), endpoint.getAddress(), endpoint.getProtocol(), endpoint.getEncryptionMethod(), endpoint.getAdditionalProperties(), methodName);
        return existingEndpointGUID;
    }

    public String createEndpoint(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        EndpointBuilder builder = new EndpointBuilder(qualifiedName, displayName, description, networkAddress, protocol, encryptionMethod, additionalProperties, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", null, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null) {
            builder.setAnchors(userId, anchorGUID, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", qualifiedName, "qualifiedName", builder, methodName);
    }

    public String getEndpointForConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String networkAddressParameterName = "networkAddress";
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("networkAddress");
        List<EntityDetail> currentEndpoints = this.getEntitiesByValue(userId, networkAddress, "networkAddress", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", propertyNames, true, null, null, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (currentEndpoints != null && !currentEndpoints.isEmpty()) {
            for (EntityDetail endpoint : currentEndpoints) {
                if (endpoint == null || endpoint.getGUID() == null) continue;
                return endpoint.getGUID();
            }
        }
        return this.createEndpoint(userId, externalSourceGUID, externalSourceName, anchorGUID, qualifiedName, displayName, description, networkAddress, protocol, encryptionMethod, additionalProperties, methodName);
    }

    public void updateEndpoint(String userId, String externalSourceGUID, String externalSourceName, String endpointGUID, String endpointGUIDParameterName, String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        EndpointBuilder builder = new EndpointBuilder(qualifiedName, displayName, description, networkAddress, protocol, encryptionMethod, additionalProperties, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", null, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", this.supportedZones, builder.getInstanceProperties(methodName), true, methodName);
    }

    public int countEndpoints(String userId, String elementGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.countAttachments(userId, elementGUID, "Referenceable", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", methodName);
    }

    public List<B> getEndpointsByNetworkAddress(String userId, String networkAddress, String networkAddressParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("networkAddress");
        return this.getBeansByValue(userId, networkAddress, networkAddressParameterName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", propertyNames, true, serviceSupportedZones, startFrom, pageSize, methodName);
    }
}

