/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class GovernanceActionHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceActionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String initiateGovernanceAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<String> actionTargetGUIDs, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestProperties, String originatorServiceName, String originatorEngineName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        String governanceEngineGUID = this.validateGovernanceEngineName(userId, governanceEngineName, "governanceEngineName", methodName);
        GovernanceActionBuilder builder = new GovernanceActionBuilder(qualifiedName, domainIdentifier, displayName, description, null, 0, startTime, null, null, null, null, this.repositoryHelper, this.serviceName, this.serverName);
        String governanceActionGUID = this.createBeanInRepository(userId, null, null, "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", qualifiedName, "qualifiedName", builder, methodName);
        if (governanceActionGUID != null) {
            String governanceActionGUIDParameterName = "governanceActionGUID";
            String governanceEngineGUIDParameterName = "governanceEngineGUID";
            InstanceProperties relationshipProperties = null;
            if (requestType != null) {
                relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "requestType", requestType, methodName);
            }
            if (requestProperties != null && !requestProperties.isEmpty()) {
                relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, "requestParameters", requestProperties, methodName);
            }
            this.linkElementToElement(userId, null, null, governanceActionGUID, "governanceActionGUID", "GovernanceAction", governanceEngineGUID, "governanceEngineGUID", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "390559eb-6a0c-4dd7-bc95-b9074caffa7f", "GovernanceActionExecutor", relationshipProperties, methodName);
            if (requestSourceGUIDs != null && !requestSourceGUIDs.isEmpty()) {
                String requestSourceGUIDParameterName = "requestSourceGUIDs[x]";
                relationshipProperties = null;
                if (originatorServiceName != null) {
                    relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "originGovernanceService", originatorServiceName, methodName);
                }
                if (originatorEngineName != null) {
                    relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "originGovernanceEngine", originatorEngineName, methodName);
                }
                for (String requestSourceGUID : requestSourceGUIDs) {
                    if (requestSourceGUID == null) continue;
                    this.linkElementToElement(userId, null, null, requestSourceGUID, "requestSourceGUIDs[x]", "OpenMetadataRoot", governanceActionGUID, "governanceActionGUID", "GovernanceAction", "5323a705-4c1f-456a-9741-41fdcb8e93ac", "GovernanceActionRequestSource", relationshipProperties, methodName);
                }
            }
            this.addActionTargets(userId, governanceActionGUID, "governanceActionGUID", actionTargetGUIDs, methodName);
        }
        return governanceActionGUID;
    }

    private void addActionTargets(String userId, String governanceActionGUID, String governanceActionGUIDParameterName, List<String> actionTargetGUIDs, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (actionTargetGUIDs != null && !actionTargetGUIDs.isEmpty()) {
            String actionTargetGUIDParameterName = "actionTargetGUIDs[x]";
            for (String actionTargetGUID : actionTargetGUIDs) {
                if (actionTargetGUID == null) continue;
                this.linkElementToElement(userId, null, null, governanceActionGUID, governanceActionGUIDParameterName, "GovernanceAction", actionTargetGUID, "actionTargetGUIDs[x]", "Referenceable", "46ec49bf-af66-4575-aab7-06ce895120cd", "TargetForAction", null, methodName);
            }
        }
    }

    private String validateGovernanceEngineName(String userId, String governanceEngineName, String governanceEngineNameParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceEngineGUID = this.getBeanGUIDByUniqueName(userId, governanceEngineName, governanceEngineNameParameterName, "qualifiedName", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", this.supportedZones, methodName);
        if (governanceEngineGUID == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_ENGINE_NAME.getMessageDefinition(governanceEngineName, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
        }
        return governanceEngineGUID;
    }

    public B getGovernanceAction(String userId, String governanceActionGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionGUIDParameterName = "governanceActionGUID";
        String actionTargetGUIDParameterName = "actionTargetGUID";
        String requestSourceGUIDParameterName = "requestSourceGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail primaryEntity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", methodName);
        if (primaryEntity != null) {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, governanceActionGUID, "GovernanceAction", null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                String actualTypeName = relationship.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionExecutor")) {
                    relationships.add(relationship);
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "TargetForAction")) {
                    relationships.add(relationship);
                    String actionTargetGUID = relationship.getEntityTwoProxy().getGUID();
                    supplementaryEntities.add(this.getEntityFromRepository(userId, actionTargetGUID, "actionTargetGUID", "Referenceable", methodName));
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionRequestSource")) continue;
                relationships.add(relationship);
                String requestSourceGUID = relationship.getEntityOneProxy().getGUID();
                supplementaryEntities.add(this.getEntityFromRepository(userId, requestSourceGUID, "requestSourceGUID", "OpenMetadataRoot", methodName));
            }
            return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
        }
        return null;
    }

    public GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                    break;
                }
                case 99: {
                    governanceActionStatus = GovernanceActionStatus.OTHER;
                }
            }
        }
        return governanceActionStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void claimGovernanceAction(String userId, String governanceActionGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        GovernanceActionStatus status = this.getActionStatus("actionStatus", properties);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if (status != GovernanceActionStatus.REQUESTED && status != GovernanceActionStatus.APPROVED || processingEngineUserId != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.INVALID_GOVERNANCE_ACTION_STATUS.getMessageDefinition(userId, governanceActionGUID, processingEngineUserId, status.getName()), this.getClass().getName(), methodName);
        }
        GovernanceActionBuilder builder = new GovernanceActionBuilder(2, userId, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", builder.getClaimInstanceProperties(methodName), true, methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateGovernanceActionStatus(String userId, String governanceActionGUID, int governanceActionStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if (!userId.equals(processingEngineUserId)) throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, governanceActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "actionStatus", "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", governanceActionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), "activityType");
        }
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", properties, true, methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recordCompletionStatus(String userId, String governanceActionGUID, int status, List<String> outputGuards, List<String> newActionTargetGUIDs, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, governanceActionGUID, "governanceActionGUID", "GovernanceAction", methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_GOVERNANCE_ACTION_PROPERTIES.getMessageDefinition(governanceActionGUID, "governanceActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, "processingEngineUserId", properties, methodName);
        if (!userId.equals(processingEngineUserId)) {
            throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, governanceActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        }
        GovernanceActionBuilder builder = new GovernanceActionBuilder(status, new Date(), outputGuards, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, governanceActionGUID, "governanceActionGUID", "c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", builder.getCompletionInstanceProperties(methodName), true, methodName);
        this.addActionTargets(userId, governanceActionGUID, "governanceActionGUID", newActionTargetGUIDs, methodName);
    }

    public List<B> getActiveClaimedGovernanceActions(String userId, String governanceEngineGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceEngineGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
        return null;
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, int status, Date startDate, Date completionDate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", methodName);
    }
}

