/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LikeHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public LikeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public int countLikes(String userId, String elementGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, elementGUID, "Referenceable", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", methodName);
    }

    public List<B> getLikes(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, elementGUID, elementGUIDParameterName, elementTypeName, "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", "Like", serviceSupportedZones, startingFrom, pageSize, methodName);
    }

    public String saveLike(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            this.removeLike(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, methodName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LikeBuilder builder = new LikeBuilder(isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        String likeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, "deaa5ca0-47a0-483d-b943-d91c76744e01", "Like", null, null, builder, methodName);
        if (likeGUID != null) {
            String likeGUIDParameterName = "likeGUID";
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, "Referenceable", likeGUID, "likeGUID", "Like", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", builder.getRelationshipInstanceProperties(methodName), methodName);
        }
        return likeGUID;
    }

    public void removeLike(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ratingGUID = this.unlinkConnectedElement(userId, true, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, "Referenceable", this.supportedZones, "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", "Like", methodName);
        if (ratingGUID != null) {
            String ratingGUIDParameterName = "ratingGUID";
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, ratingGUID, "ratingGUID", "deaa5ca0-47a0-483d-b943-d91c76744e01", "Like", null, null, methodName);
        }
    }
}

